package websearch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AnswerType enumerates the values for answer type.
type AnswerType string

const (
	// AnswerTypeComputation ...
	AnswerTypeComputation AnswerType = "Computation"
	// AnswerTypeImages ...
	AnswerTypeImages AnswerType = "Images"
	// AnswerTypeNews ...
	AnswerTypeNews AnswerType = "News"
	// AnswerTypeRelatedSearches ...
	AnswerTypeRelatedSearches AnswerType = "RelatedSearches"
	// AnswerTypeSpellSuggestions ...
	AnswerTypeSpellSuggestions AnswerType = "SpellSuggestions"
	// AnswerTypeTimeZone ...
	AnswerTypeTimeZone AnswerType = "TimeZone"
	// AnswerTypeVideos ...
	AnswerTypeVideos AnswerType = "Videos"
	// AnswerTypeWebPages ...
	AnswerTypeWebPages AnswerType = "WebPages"
)

// PossibleAnswerTypeValues returns an array of possible values for the AnswerType const type.
func PossibleAnswerTypeValues() []AnswerType {
	return []AnswerType{AnswerTypeComputation, AnswerTypeImages, AnswerTypeNews, AnswerTypeRelatedSearches, AnswerTypeSpellSuggestions, AnswerTypeTimeZone, AnswerTypeVideos, AnswerTypeWebPages}
}

// ErrorCode enumerates the values for error code.
type ErrorCode string

const (
	// InsufficientAuthorization ...
	InsufficientAuthorization ErrorCode = "InsufficientAuthorization"
	// InvalidAuthorization ...
	InvalidAuthorization ErrorCode = "InvalidAuthorization"
	// InvalidRequest ...
	InvalidRequest ErrorCode = "InvalidRequest"
	// None ...
	None ErrorCode = "None"
	// RateLimitExceeded ...
	RateLimitExceeded ErrorCode = "RateLimitExceeded"
	// ServerError ...
	ServerError ErrorCode = "ServerError"
)

// PossibleErrorCodeValues returns an array of possible values for the ErrorCode const type.
func PossibleErrorCodeValues() []ErrorCode {
	return []ErrorCode{InsufficientAuthorization, InvalidAuthorization, InvalidRequest, None, RateLimitExceeded, ServerError}
}

// ErrorSubCode enumerates the values for error sub code.
type ErrorSubCode string

const (
	// AuthorizationDisabled ...
	AuthorizationDisabled ErrorSubCode = "AuthorizationDisabled"
	// AuthorizationExpired ...
	AuthorizationExpired ErrorSubCode = "AuthorizationExpired"
	// AuthorizationMissing ...
	AuthorizationMissing ErrorSubCode = "AuthorizationMissing"
	// AuthorizationRedundancy ...
	AuthorizationRedundancy ErrorSubCode = "AuthorizationRedundancy"
	// Blocked ...
	Blocked ErrorSubCode = "Blocked"
	// HTTPNotAllowed ...
	HTTPNotAllowed ErrorSubCode = "HttpNotAllowed"
	// NotImplemented ...
	NotImplemented ErrorSubCode = "NotImplemented"
	// ParameterInvalidValue ...
	ParameterInvalidValue ErrorSubCode = "ParameterInvalidValue"
	// ParameterMissing ...
	ParameterMissing ErrorSubCode = "ParameterMissing"
	// ResourceError ...
	ResourceError ErrorSubCode = "ResourceError"
	// UnexpectedError ...
	UnexpectedError ErrorSubCode = "UnexpectedError"
)

// PossibleErrorSubCodeValues returns an array of possible values for the ErrorSubCode const type.
func PossibleErrorSubCodeValues() []ErrorSubCode {
	return []ErrorSubCode{AuthorizationDisabled, AuthorizationExpired, AuthorizationMissing, AuthorizationRedundancy, Blocked, HTTPNotAllowed, NotImplemented, ParameterInvalidValue, ParameterMissing, ResourceError, UnexpectedError}
}

// Freshness enumerates the values for freshness.
type Freshness string

const (
	// Day ...
	Day Freshness = "Day"
	// Month ...
	Month Freshness = "Month"
	// Week ...
	Week Freshness = "Week"
)

// PossibleFreshnessValues returns an array of possible values for the Freshness const type.
func PossibleFreshnessValues() []Freshness {
	return []Freshness{Day, Month, Week}
}

// SafeSearch enumerates the values for safe search.
type SafeSearch string

const (
	// Moderate ...
	Moderate SafeSearch = "Moderate"
	// Off ...
	Off SafeSearch = "Off"
	// Strict ...
	Strict SafeSearch = "Strict"
)

// PossibleSafeSearchValues returns an array of possible values for the SafeSearch const type.
func PossibleSafeSearchValues() []SafeSearch {
	return []SafeSearch{Moderate, Off, Strict}
}

// TextFormat enumerates the values for text format.
type TextFormat string

const (
	// HTML ...
	HTML TextFormat = "Html"
	// Raw ...
	Raw TextFormat = "Raw"
)

// PossibleTextFormatValues returns an array of possible values for the TextFormat const type.
func PossibleTextFormatValues() []TextFormat {
	return []TextFormat{HTML, Raw}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeWebWebGrouping ...
	TypeWebWebGrouping Type = "Web/WebGrouping"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeWebWebGrouping}
}

// TypeBasicResponseBase enumerates the values for type basic response base.
type TypeBasicResponseBase string

const (
	// TypeAnswer ...
	TypeAnswer TypeBasicResponseBase = "Answer"
	// TypeArticle ...
	TypeArticle TypeBasicResponseBase = "Article"
	// TypeComputation ...
	TypeComputation TypeBasicResponseBase = "Computation"
	// TypeCreativeWork ...
	TypeCreativeWork TypeBasicResponseBase = "CreativeWork"
	// TypeErrorResponse ...
	TypeErrorResponse TypeBasicResponseBase = "ErrorResponse"
	// TypeIdentifiable ...
	TypeIdentifiable TypeBasicResponseBase = "Identifiable"
	// TypeImageObject ...
	TypeImageObject TypeBasicResponseBase = "ImageObject"
	// TypeImages ...
	TypeImages TypeBasicResponseBase = "Images"
	// TypeIntangible ...
	TypeIntangible TypeBasicResponseBase = "Intangible"
	// TypeMediaObject ...
	TypeMediaObject TypeBasicResponseBase = "MediaObject"
	// TypeNews ...
	TypeNews TypeBasicResponseBase = "News"
	// TypeNewsArticle ...
	TypeNewsArticle TypeBasicResponseBase = "NewsArticle"
	// TypePlaces ...
	TypePlaces TypeBasicResponseBase = "Places"
	// TypeRelatedSearchesRelatedSearchAnswer ...
	TypeRelatedSearchesRelatedSearchAnswer TypeBasicResponseBase = "RelatedSearches/RelatedSearchAnswer"
	// TypeResponse ...
	TypeResponse TypeBasicResponseBase = "Response"
	// TypeResponseBase ...
	TypeResponseBase TypeBasicResponseBase = "ResponseBase"
	// TypeSearchResponse ...
	TypeSearchResponse TypeBasicResponseBase = "SearchResponse"
	// TypeSearchResultsAnswer ...
	TypeSearchResultsAnswer TypeBasicResponseBase = "SearchResultsAnswer"
	// TypeSpellSuggestions ...
	TypeSpellSuggestions TypeBasicResponseBase = "SpellSuggestions"
	// TypeStructuredValue ...
	TypeStructuredValue TypeBasicResponseBase = "StructuredValue"
	// TypeThing ...
	TypeThing TypeBasicResponseBase = "Thing"
	// TypeTimeZone ...
	TypeTimeZone TypeBasicResponseBase = "TimeZone"
	// TypeVideoObject ...
	TypeVideoObject TypeBasicResponseBase = "VideoObject"
	// TypeVideos ...
	TypeVideos TypeBasicResponseBase = "Videos"
	// TypeWebPage ...
	TypeWebPage TypeBasicResponseBase = "WebPage"
	// TypeWebWebAnswer ...
	TypeWebWebAnswer TypeBasicResponseBase = "Web/WebAnswer"
)

// PossibleTypeBasicResponseBaseValues returns an array of possible values for the TypeBasicResponseBase const type.
func PossibleTypeBasicResponseBaseValues() []TypeBasicResponseBase {
	return []TypeBasicResponseBase{TypeAnswer, TypeArticle, TypeComputation, TypeCreativeWork, TypeErrorResponse, TypeIdentifiable, TypeImageObject, TypeImages, TypeIntangible, TypeMediaObject, TypeNews, TypeNewsArticle, TypePlaces, TypeRelatedSearchesRelatedSearchAnswer, TypeResponse, TypeResponseBase, TypeSearchResponse, TypeSearchResultsAnswer, TypeSpellSuggestions, TypeStructuredValue, TypeThing, TypeTimeZone, TypeVideoObject, TypeVideos, TypeWebPage, TypeWebWebAnswer}
}
