package account

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// DataLakeAnalyticsAccountState enumerates the values for data lake analytics account state.
type DataLakeAnalyticsAccountState string

const (
	// Active ...
	Active DataLakeAnalyticsAccountState = "active"
	// Suspended ...
	Suspended DataLakeAnalyticsAccountState = "suspended"
)

// PossibleDataLakeAnalyticsAccountStateValues returns an array of possible values for the DataLakeAnalyticsAccountState const type.
func PossibleDataLakeAnalyticsAccountStateValues() []DataLakeAnalyticsAccountState {
	return []DataLakeAnalyticsAccountState{Active, Suspended}
}

// DataLakeAnalyticsAccountStatus enumerates the values for data lake analytics account status.
type DataLakeAnalyticsAccountStatus string

const (
	// Creating ...
	Creating DataLakeAnalyticsAccountStatus = "Creating"
	// Deleted ...
	Deleted DataLakeAnalyticsAccountStatus = "Deleted"
	// Deleting ...
	Deleting DataLakeAnalyticsAccountStatus = "Deleting"
	// Failed ...
	Failed DataLakeAnalyticsAccountStatus = "Failed"
	// Patching ...
	Patching DataLakeAnalyticsAccountStatus = "Patching"
	// Resuming ...
	Resuming DataLakeAnalyticsAccountStatus = "Resuming"
	// Running ...
	Running DataLakeAnalyticsAccountStatus = "Running"
	// Succeeded ...
	Succeeded DataLakeAnalyticsAccountStatus = "Succeeded"
	// Suspending ...
	Suspending DataLakeAnalyticsAccountStatus = "Suspending"
)

// PossibleDataLakeAnalyticsAccountStatusValues returns an array of possible values for the DataLakeAnalyticsAccountStatus const type.
func PossibleDataLakeAnalyticsAccountStatusValues() []DataLakeAnalyticsAccountStatus {
	return []DataLakeAnalyticsAccountStatus{Creating, Deleted, Deleting, Failed, Patching, Resuming, Running, Succeeded, Suspending}
}

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// OperationStatusFailed ...
	OperationStatusFailed OperationStatus = "Failed"
	// OperationStatusInProgress ...
	OperationStatusInProgress OperationStatus = "InProgress"
	// OperationStatusSucceeded ...
	OperationStatusSucceeded OperationStatus = "Succeeded"
)

// PossibleOperationStatusValues returns an array of possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{OperationStatusFailed, OperationStatusInProgress, OperationStatusSucceeded}
}
