package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFabricConsortiumConfig invokes the baas.DescribeFabricConsortiumConfig API synchronously
// api document: https://help.aliyun.com/api/baas/describefabricconsortiumconfig.html
func (client *Client) DescribeFabricConsortiumConfig(request *DescribeFabricConsortiumConfigRequest) (response *DescribeFabricConsortiumConfigResponse, err error) {
	response = CreateDescribeFabricConsortiumConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFabricConsortiumConfigWithChan invokes the baas.DescribeFabricConsortiumConfig API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricconsortiumconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricConsortiumConfigWithChan(request *DescribeFabricConsortiumConfigRequest) (<-chan *DescribeFabricConsortiumConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeFabricConsortiumConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFabricConsortiumConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFabricConsortiumConfigWithCallback invokes the baas.DescribeFabricConsortiumConfig API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricconsortiumconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricConsortiumConfigWithCallback(request *DescribeFabricConsortiumConfigRequest, callback func(response *DescribeFabricConsortiumConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFabricConsortiumConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeFabricConsortiumConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFabricConsortiumConfigRequest is the request struct for api DescribeFabricConsortiumConfig
type DescribeFabricConsortiumConfigRequest struct {
	*requests.RpcRequest
}

// DescribeFabricConsortiumConfigResponse is the response struct for api DescribeFabricConsortiumConfig
type DescribeFabricConsortiumConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeFabricConsortiumConfigRequest creates a request to invoke DescribeFabricConsortiumConfig API
func CreateDescribeFabricConsortiumConfigRequest() (request *DescribeFabricConsortiumConfigRequest) {
	request = &DescribeFabricConsortiumConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeFabricConsortiumConfig", "baas", "openAPI")
	return
}

// CreateDescribeFabricConsortiumConfigResponse creates a response to parse from DescribeFabricConsortiumConfig response
func CreateDescribeFabricConsortiumConfigResponse() (response *DescribeFabricConsortiumConfigResponse) {
	response = &DescribeFabricConsortiumConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
