package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetConfigRuleComplianceByPack invokes the config.GetConfigRuleComplianceByPack API synchronously
func (client *Client) GetConfigRuleComplianceByPack(request *GetConfigRuleComplianceByPackRequest) (response *GetConfigRuleComplianceByPackResponse, err error) {
	response = CreateGetConfigRuleComplianceByPackResponse()
	err = client.DoAction(request, response)
	return
}

// GetConfigRuleComplianceByPackWithChan invokes the config.GetConfigRuleComplianceByPack API asynchronously
func (client *Client) GetConfigRuleComplianceByPackWithChan(request *GetConfigRuleComplianceByPackRequest) (<-chan *GetConfigRuleComplianceByPackResponse, <-chan error) {
	responseChan := make(chan *GetConfigRuleComplianceByPackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetConfigRuleComplianceByPack(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetConfigRuleComplianceByPackWithCallback invokes the config.GetConfigRuleComplianceByPack API asynchronously
func (client *Client) GetConfigRuleComplianceByPackWithCallback(request *GetConfigRuleComplianceByPackRequest, callback func(response *GetConfigRuleComplianceByPackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetConfigRuleComplianceByPackResponse
		var err error
		defer close(result)
		response, err = client.GetConfigRuleComplianceByPack(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetConfigRuleComplianceByPackRequest is the request struct for api GetConfigRuleComplianceByPack
type GetConfigRuleComplianceByPackRequest struct {
	*requests.RpcRequest
	CompliancePackId string `position:"Query" name:"CompliancePackId"`
}

// GetConfigRuleComplianceByPackResponse is the response struct for api GetConfigRuleComplianceByPack
type GetConfigRuleComplianceByPackResponse struct {
	*responses.BaseResponse
	RequestId                  string                     `json:"RequestId" xml:"RequestId"`
	ConfigRuleComplianceResult ConfigRuleComplianceResult `json:"ConfigRuleComplianceResult" xml:"ConfigRuleComplianceResult"`
}

// CreateGetConfigRuleComplianceByPackRequest creates a request to invoke GetConfigRuleComplianceByPack API
func CreateGetConfigRuleComplianceByPackRequest() (request *GetConfigRuleComplianceByPackRequest) {
	request = &GetConfigRuleComplianceByPackRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetConfigRuleComplianceByPack", "", "")
	request.Method = requests.GET
	return
}

// CreateGetConfigRuleComplianceByPackResponse creates a response to parse from GetConfigRuleComplianceByPack response
func CreateGetConfigRuleComplianceByPackResponse() (response *GetConfigRuleComplianceByPackResponse) {
	response = &GetConfigRuleComplianceByPackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
