package ddospro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWebLogPage invokes the ddospro.DescribeWebLogPage API synchronously
// api document: https://help.aliyun.com/api/ddospro/describeweblogpage.html
func (client *Client) DescribeWebLogPage(request *DescribeWebLogPageRequest) (response *DescribeWebLogPageResponse, err error) {
	response = CreateDescribeWebLogPageResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWebLogPageWithChan invokes the ddospro.DescribeWebLogPage API asynchronously
// api document: https://help.aliyun.com/api/ddospro/describeweblogpage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWebLogPageWithChan(request *DescribeWebLogPageRequest) (<-chan *DescribeWebLogPageResponse, <-chan error) {
	responseChan := make(chan *DescribeWebLogPageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWebLogPage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWebLogPageWithCallback invokes the ddospro.DescribeWebLogPage API asynchronously
// api document: https://help.aliyun.com/api/ddospro/describeweblogpage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWebLogPageWithCallback(request *DescribeWebLogPageRequest, callback func(response *DescribeWebLogPageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWebLogPageResponse
		var err error
		defer close(result)
		response, err = client.DescribeWebLogPage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWebLogPageRequest is the request struct for api DescribeWebLogPage
type DescribeWebLogPageRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Domain          string           `position:"Query" name:"Domain"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	CurrentPage     requests.Integer `position:"Query" name:"CurrentPage"`
}

// DescribeWebLogPageResponse is the response struct for api DescribeWebLogPage
type DescribeWebLogPageResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	TotalCount int      `json:"TotalCount" xml:"TotalCount"`
	WebLogList []WebLog `json:"WebLogList" xml:"WebLogList"`
}

// CreateDescribeWebLogPageRequest creates a request to invoke DescribeWebLogPage API
func CreateDescribeWebLogPageRequest() (request *DescribeWebLogPageRequest) {
	request = &DescribeWebLogPageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DDoSPro", "2017-07-25", "DescribeWebLogPage", "", "")
	return
}

// CreateDescribeWebLogPageResponse creates a response to parse from DescribeWebLogPage response
func CreateDescribeWebLogPageResponse() (response *DescribeWebLogPageResponse) {
	response = &DescribeWebLogPageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
