package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserName invokes the devops_rdc.GetUserName API synchronously
func (client *Client) GetUserName(request *GetUserNameRequest) (response *GetUserNameResponse, err error) {
	response = CreateGetUserNameResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserNameWithChan invokes the devops_rdc.GetUserName API asynchronously
func (client *Client) GetUserNameWithChan(request *GetUserNameRequest) (<-chan *GetUserNameResponse, <-chan error) {
	responseChan := make(chan *GetUserNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserNameWithCallback invokes the devops_rdc.GetUserName API asynchronously
func (client *Client) GetUserNameWithCallback(request *GetUserNameRequest, callback func(response *GetUserNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserNameResponse
		var err error
		defer close(result)
		response, err = client.GetUserName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserNameRequest is the request struct for api GetUserName
type GetUserNameRequest struct {
	*requests.RpcRequest
	UserId string `position:"Body" name:"UserId"`
	OrgId  string `position:"Body" name:"OrgId"`
}

// GetUserNameResponse is the response struct for api GetUserName
type GetUserNameResponse struct {
	*responses.BaseResponse
	Successful bool   `json:"Successful" xml:"Successful"`
	ErrorCode  string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Object     string `json:"Object" xml:"Object"`
}

// CreateGetUserNameRequest creates a request to invoke GetUserName API
func CreateGetUserNameRequest() (request *GetUserNameRequest) {
	request = &GetUserNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "GetUserName", "", "")
	request.Method = requests.POST
	return
}

// CreateGetUserNameResponse creates a response to parse from GetUserName response
func CreateGetUserNameResponse() (response *GetUserNameResponse) {
	response = &GetUserNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
