package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteProxy invokes the dms_enterprise.DeleteProxy API synchronously
func (client *Client) DeleteProxy(request *DeleteProxyRequest) (response *DeleteProxyResponse, err error) {
	response = CreateDeleteProxyResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteProxyWithChan invokes the dms_enterprise.DeleteProxy API asynchronously
func (client *Client) DeleteProxyWithChan(request *DeleteProxyRequest) (<-chan *DeleteProxyResponse, <-chan error) {
	responseChan := make(chan *DeleteProxyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteProxy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteProxyWithCallback invokes the dms_enterprise.DeleteProxy API asynchronously
func (client *Client) DeleteProxyWithCallback(request *DeleteProxyRequest, callback func(response *DeleteProxyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteProxyResponse
		var err error
		defer close(result)
		response, err = client.DeleteProxy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteProxyRequest is the request struct for api DeleteProxy
type DeleteProxyRequest struct {
	*requests.RpcRequest
	Tid     requests.Integer `position:"Query" name:"Tid"`
	ProxyId requests.Integer `position:"Query" name:"ProxyId"`
}

// DeleteProxyResponse is the response struct for api DeleteProxy
type DeleteProxyResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateDeleteProxyRequest creates a request to invoke DeleteProxy API
func CreateDeleteProxyRequest() (request *DeleteProxyRequest) {
	request = &DeleteProxyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "DeleteProxy", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteProxyResponse creates a response to parse from DeleteProxy response
func CreateDeleteProxyResponse() (response *DeleteProxyResponse) {
	response = &DeleteProxyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
