package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListResourceInstances invokes the eas.ListResourceInstances API synchronously
func (client *Client) ListResourceInstances(request *ListResourceInstancesRequest) (response *ListResourceInstancesResponse, err error) {
	response = CreateListResourceInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// ListResourceInstancesWithChan invokes the eas.ListResourceInstances API asynchronously
func (client *Client) ListResourceInstancesWithChan(request *ListResourceInstancesRequest) (<-chan *ListResourceInstancesResponse, <-chan error) {
	responseChan := make(chan *ListResourceInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListResourceInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListResourceInstancesWithCallback invokes the eas.ListResourceInstances API asynchronously
func (client *Client) ListResourceInstancesWithCallback(request *ListResourceInstancesRequest, callback func(response *ListResourceInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListResourceInstancesResponse
		var err error
		defer close(result)
		response, err = client.ListResourceInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListResourceInstancesRequest is the request struct for api ListResourceInstances
type ListResourceInstancesRequest struct {
	*requests.RoaRequest
	ResourceId string           `position:"Path" name:"ResourceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	ClusterId  string           `position:"Path" name:"ClusterId"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListResourceInstancesResponse is the response struct for api ListResourceInstances
type ListResourceInstancesResponse struct {
	*responses.BaseResponse
}

// CreateListResourceInstancesRequest creates a request to invoke ListResourceInstances API
func CreateListResourceInstancesRequest() (request *ListResourceInstancesRequest) {
	request = &ListResourceInstancesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2021-07-01", "ListResourceInstances", "/api/v2/resources/[ClusterId]/[ResourceId]/instances", "eas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListResourceInstancesResponse creates a response to parse from ListResourceInstances response
func CreateListResourceInstancesResponse() (response *ListResourceInstancesResponse) {
	response = &ListResourceInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
