package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDistributedDevice invokes the iot.ListDistributedDevice API synchronously
func (client *Client) ListDistributedDevice(request *ListDistributedDeviceRequest) (response *ListDistributedDeviceResponse, err error) {
	response = CreateListDistributedDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// ListDistributedDeviceWithChan invokes the iot.ListDistributedDevice API asynchronously
func (client *Client) ListDistributedDeviceWithChan(request *ListDistributedDeviceRequest) (<-chan *ListDistributedDeviceResponse, <-chan error) {
	responseChan := make(chan *ListDistributedDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDistributedDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDistributedDeviceWithCallback invokes the iot.ListDistributedDevice API asynchronously
func (client *Client) ListDistributedDeviceWithCallback(request *ListDistributedDeviceRequest, callback func(response *ListDistributedDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDistributedDeviceResponse
		var err error
		defer close(result)
		response, err = client.ListDistributedDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDistributedDeviceRequest is the request struct for api ListDistributedDevice
type ListDistributedDeviceRequest struct {
	*requests.RpcRequest
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	SourceInstanceId string           `position:"Query" name:"SourceInstanceId"`
	CurrentPage      requests.Integer `position:"Query" name:"CurrentPage"`
	ProductKey       string           `position:"Query" name:"ProductKey"`
	TargetInstanceId string           `position:"Query" name:"TargetInstanceId"`
	ApiProduct       string           `position:"Body" name:"ApiProduct"`
	ApiRevision      string           `position:"Body" name:"ApiRevision"`
	DeviceName       string           `position:"Query" name:"DeviceName"`
	TargetUid        string           `position:"Query" name:"TargetUid"`
}

// ListDistributedDeviceResponse is the response struct for api ListDistributedDevice
type ListDistributedDeviceResponse struct {
	*responses.BaseResponse
	RequestId    string                      `json:"RequestId" xml:"RequestId"`
	Success      bool                        `json:"Success" xml:"Success"`
	Code         string                      `json:"Code" xml:"Code"`
	ErrorMessage string                      `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInListDistributedDevice `json:"Data" xml:"Data"`
}

// CreateListDistributedDeviceRequest creates a request to invoke ListDistributedDevice API
func CreateListDistributedDeviceRequest() (request *ListDistributedDeviceRequest) {
	request = &ListDistributedDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "ListDistributedDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateListDistributedDeviceResponse creates a response to parse from ListDistributedDevice response
func CreateListDistributedDeviceResponse() (response *ListDistributedDeviceResponse) {
	response = &ListDistributedDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
