package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetStudioProjectCooperation invokes the iot.SetStudioProjectCooperation API synchronously
func (client *Client) SetStudioProjectCooperation(request *SetStudioProjectCooperationRequest) (response *SetStudioProjectCooperationResponse, err error) {
	response = CreateSetStudioProjectCooperationResponse()
	err = client.DoAction(request, response)
	return
}

// SetStudioProjectCooperationWithChan invokes the iot.SetStudioProjectCooperation API asynchronously
func (client *Client) SetStudioProjectCooperationWithChan(request *SetStudioProjectCooperationRequest) (<-chan *SetStudioProjectCooperationResponse, <-chan error) {
	responseChan := make(chan *SetStudioProjectCooperationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetStudioProjectCooperation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetStudioProjectCooperationWithCallback invokes the iot.SetStudioProjectCooperation API asynchronously
func (client *Client) SetStudioProjectCooperationWithCallback(request *SetStudioProjectCooperationRequest, callback func(response *SetStudioProjectCooperationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetStudioProjectCooperationResponse
		var err error
		defer close(result)
		response, err = client.SetStudioProjectCooperation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetStudioProjectCooperationRequest is the request struct for api SetStudioProjectCooperation
type SetStudioProjectCooperationRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Body" name:"IotInstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	Status        string `position:"Body" name:"Status"`
}

// SetStudioProjectCooperationResponse is the response struct for api SetStudioProjectCooperation
type SetStudioProjectCooperationResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         bool   `json:"Data" xml:"Data"`
}

// CreateSetStudioProjectCooperationRequest creates a request to invoke SetStudioProjectCooperation API
func CreateSetStudioProjectCooperationRequest() (request *SetStudioProjectCooperationRequest) {
	request = &SetStudioProjectCooperationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "SetStudioProjectCooperation", "", "")
	request.Method = requests.POST
	return
}

// CreateSetStudioProjectCooperationResponse creates a response to parse from SetStudioProjectCooperation response
func CreateSetStudioProjectCooperationResponse() (response *SetStudioProjectCooperationResponse) {
	response = &SetStudioProjectCooperationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
