package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutSecretValue invokes the kms.PutSecretValue API synchronously
func (client *Client) PutSecretValue(request *PutSecretValueRequest) (response *PutSecretValueResponse, err error) {
	response = CreatePutSecretValueResponse()
	err = client.DoAction(request, response)
	return
}

// PutSecretValueWithChan invokes the kms.PutSecretValue API asynchronously
func (client *Client) PutSecretValueWithChan(request *PutSecretValueRequest) (<-chan *PutSecretValueResponse, <-chan error) {
	responseChan := make(chan *PutSecretValueResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutSecretValue(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutSecretValueWithCallback invokes the kms.PutSecretValue API asynchronously
func (client *Client) PutSecretValueWithCallback(request *PutSecretValueRequest, callback func(response *PutSecretValueResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutSecretValueResponse
		var err error
		defer close(result)
		response, err = client.PutSecretValue(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutSecretValueRequest is the request struct for api PutSecretValue
type PutSecretValueRequest struct {
	*requests.RpcRequest
	VersionId      string `position:"Query" name:"VersionId"`
	VersionStages  string `position:"Query" name:"VersionStages"`
	SecretData     string `position:"Query" name:"SecretData"`
	SecretName     string `position:"Query" name:"SecretName"`
	SecretDataType string `position:"Query" name:"SecretDataType"`
}

// PutSecretValueResponse is the response struct for api PutSecretValue
type PutSecretValueResponse struct {
	*responses.BaseResponse
	RequestId     string                        `json:"RequestId" xml:"RequestId"`
	SecretName    string                        `json:"SecretName" xml:"SecretName"`
	VersionId     string                        `json:"VersionId" xml:"VersionId"`
	VersionStages VersionStagesInPutSecretValue `json:"VersionStages" xml:"VersionStages"`
}

// CreatePutSecretValueRequest creates a request to invoke PutSecretValue API
func CreatePutSecretValueRequest() (request *PutSecretValueRequest) {
	request = &PutSecretValueRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "PutSecretValue", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePutSecretValueResponse creates a response to parse from PutSecretValue response
func CreatePutSecretValueResponse() (response *PutSecretValueResponse) {
	response = &PutSecretValueResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
