package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAppResourceAlloc invokes the retailcloud.DescribeAppResourceAlloc API synchronously
func (client *Client) DescribeAppResourceAlloc(request *DescribeAppResourceAllocRequest) (response *DescribeAppResourceAllocResponse, err error) {
	response = CreateDescribeAppResourceAllocResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAppResourceAllocWithChan invokes the retailcloud.DescribeAppResourceAlloc API asynchronously
func (client *Client) DescribeAppResourceAllocWithChan(request *DescribeAppResourceAllocRequest) (<-chan *DescribeAppResourceAllocResponse, <-chan error) {
	responseChan := make(chan *DescribeAppResourceAllocResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAppResourceAlloc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAppResourceAllocWithCallback invokes the retailcloud.DescribeAppResourceAlloc API asynchronously
func (client *Client) DescribeAppResourceAllocWithCallback(request *DescribeAppResourceAllocRequest, callback func(response *DescribeAppResourceAllocResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAppResourceAllocResponse
		var err error
		defer close(result)
		response, err = client.DescribeAppResourceAlloc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAppResourceAllocRequest is the request struct for api DescribeAppResourceAlloc
type DescribeAppResourceAllocRequest struct {
	*requests.RpcRequest
	AppEnvId requests.Integer `position:"Query" name:"AppEnvId"`
}

// DescribeAppResourceAllocResponse is the response struct for api DescribeAppResourceAlloc
type DescribeAppResourceAllocResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeAppResourceAllocRequest creates a request to invoke DescribeAppResourceAlloc API
func CreateDescribeAppResourceAllocRequest() (request *DescribeAppResourceAllocRequest) {
	request = &DescribeAppResourceAllocRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "DescribeAppResourceAlloc", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeAppResourceAllocResponse creates a response to parse from DescribeAppResourceAlloc response
func CreateDescribeAppResourceAllocResponse() (response *DescribeAppResourceAllocResponse) {
	response = &DescribeAppResourceAllocResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
