package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddSharesToExpressSync invokes the sgw.AddSharesToExpressSync API synchronously
func (client *Client) AddSharesToExpressSync(request *AddSharesToExpressSyncRequest) (response *AddSharesToExpressSyncResponse, err error) {
	response = CreateAddSharesToExpressSyncResponse()
	err = client.DoAction(request, response)
	return
}

// AddSharesToExpressSyncWithChan invokes the sgw.AddSharesToExpressSync API asynchronously
func (client *Client) AddSharesToExpressSyncWithChan(request *AddSharesToExpressSyncRequest) (<-chan *AddSharesToExpressSyncResponse, <-chan error) {
	responseChan := make(chan *AddSharesToExpressSyncResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddSharesToExpressSync(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddSharesToExpressSyncWithCallback invokes the sgw.AddSharesToExpressSync API asynchronously
func (client *Client) AddSharesToExpressSyncWithCallback(request *AddSharesToExpressSyncRequest, callback func(response *AddSharesToExpressSyncResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddSharesToExpressSyncResponse
		var err error
		defer close(result)
		response, err = client.AddSharesToExpressSync(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddSharesToExpressSyncRequest is the request struct for api AddSharesToExpressSync
type AddSharesToExpressSyncRequest struct {
	*requests.RpcRequest
	ExpressSyncId  string `position:"Query" name:"ExpressSyncId"`
	GatewayShares  string `position:"Query" name:"GatewayShares"`
	GatewayRegions string `position:"Query" name:"GatewayRegions"`
	SecurityToken  string `position:"Query" name:"SecurityToken"`
}

// AddSharesToExpressSyncResponse is the response struct for api AddSharesToExpressSync
type AddSharesToExpressSyncResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	Success           bool   `json:"Success" xml:"Success"`
	Code              string `json:"Code" xml:"Code"`
	Message           string `json:"Message" xml:"Message"`
	TaskId            string `json:"TaskId" xml:"TaskId"`
	MnsTopic          string `json:"MnsTopic" xml:"MnsTopic"`
	MnsQueues         string `json:"MnsQueues" xml:"MnsQueues"`
	MnsFullSyncDelay  int64  `json:"MnsFullSyncDelay" xml:"MnsFullSyncDelay"`
	MnsPublicEndpoint string `json:"MnsPublicEndpoint" xml:"MnsPublicEndpoint"`
	MnsInnerEndpoint  string `json:"MnsInnerEndpoint" xml:"MnsInnerEndpoint"`
}

// CreateAddSharesToExpressSyncRequest creates a request to invoke AddSharesToExpressSync API
func CreateAddSharesToExpressSyncRequest() (request *AddSharesToExpressSyncRequest) {
	request = &AddSharesToExpressSyncRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "AddSharesToExpressSync", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddSharesToExpressSyncResponse creates a response to parse from AddSharesToExpressSync response
func CreateAddSharesToExpressSyncResponse() (response *AddSharesToExpressSyncResponse) {
	response = &AddSharesToExpressSyncResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
