// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/metadata_service.proto

#include "google/cloud/aiplatform/v1/internal/metadata_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

MetadataServiceTracingConnection::MetadataServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::MetadataServiceConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::aiplatform::v1::MetadataStore>>
MetadataServiceTracingConnection::CreateMetadataStore(
    google::cloud::aiplatform::v1::CreateMetadataStoreRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::CreateMetadataStore");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateMetadataStore(request));
}

StatusOr<google::longrunning::Operation>
MetadataServiceTracingConnection::CreateMetadataStore(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreateMetadataStoreRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::CreateMetadataStore");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateMetadataStore(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::MetadataStore>>
MetadataServiceTracingConnection::CreateMetadataStore(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::CreateMetadataStore");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateMetadataStore(operation));
}

StatusOr<google::cloud::aiplatform::v1::MetadataStore>
MetadataServiceTracingConnection::GetMetadataStore(
    google::cloud::aiplatform::v1::GetMetadataStoreRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::GetMetadataStore");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetMetadataStore(request));
}

StreamRange<google::cloud::aiplatform::v1::MetadataStore>
MetadataServiceTracingConnection::ListMetadataStores(
    google::cloud::aiplatform::v1::ListMetadataStoresRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::ListMetadataStores");
  internal::OTelScope scope(span);
  auto sr = child_->ListMetadataStores(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::MetadataStore>(std::move(span),
                                                    std::move(sr));
}

future<StatusOr<
    google::cloud::aiplatform::v1::DeleteMetadataStoreOperationMetadata>>
MetadataServiceTracingConnection::DeleteMetadataStore(
    google::cloud::aiplatform::v1::DeleteMetadataStoreRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::DeleteMetadataStore");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteMetadataStore(request));
}

StatusOr<google::longrunning::Operation>
MetadataServiceTracingConnection::DeleteMetadataStore(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteMetadataStoreRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::DeleteMetadataStore");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteMetadataStore(NoAwaitTag{}, request));
}

future<StatusOr<
    google::cloud::aiplatform::v1::DeleteMetadataStoreOperationMetadata>>
MetadataServiceTracingConnection::DeleteMetadataStore(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::DeleteMetadataStore");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteMetadataStore(operation));
}

StatusOr<google::cloud::aiplatform::v1::Artifact>
MetadataServiceTracingConnection::CreateArtifact(
    google::cloud::aiplatform::v1::CreateArtifactRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::CreateArtifact");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateArtifact(request));
}

StatusOr<google::cloud::aiplatform::v1::Artifact>
MetadataServiceTracingConnection::GetArtifact(
    google::cloud::aiplatform::v1::GetArtifactRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::GetArtifact");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetArtifact(request));
}

StreamRange<google::cloud::aiplatform::v1::Artifact>
MetadataServiceTracingConnection::ListArtifacts(
    google::cloud::aiplatform::v1::ListArtifactsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::ListArtifacts");
  internal::OTelScope scope(span);
  auto sr = child_->ListArtifacts(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::Artifact>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::aiplatform::v1::Artifact>
MetadataServiceTracingConnection::UpdateArtifact(
    google::cloud::aiplatform::v1::UpdateArtifactRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::UpdateArtifact");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateArtifact(request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
MetadataServiceTracingConnection::DeleteArtifact(
    google::cloud::aiplatform::v1::DeleteArtifactRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::DeleteArtifact");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteArtifact(request));
}

StatusOr<google::longrunning::Operation>
MetadataServiceTracingConnection::DeleteArtifact(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteArtifactRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::DeleteArtifact");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteArtifact(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
MetadataServiceTracingConnection::DeleteArtifact(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::DeleteArtifact");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteArtifact(operation));
}

future<StatusOr<google::cloud::aiplatform::v1::PurgeArtifactsResponse>>
MetadataServiceTracingConnection::PurgeArtifacts(
    google::cloud::aiplatform::v1::PurgeArtifactsRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::PurgeArtifacts");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PurgeArtifacts(request));
}

StatusOr<google::longrunning::Operation>
MetadataServiceTracingConnection::PurgeArtifacts(
    NoAwaitTag,
    google::cloud::aiplatform::v1::PurgeArtifactsRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::PurgeArtifacts");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->PurgeArtifacts(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::PurgeArtifactsResponse>>
MetadataServiceTracingConnection::PurgeArtifacts(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::PurgeArtifacts");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PurgeArtifacts(operation));
}

StatusOr<google::cloud::aiplatform::v1::Context>
MetadataServiceTracingConnection::CreateContext(
    google::cloud::aiplatform::v1::CreateContextRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::CreateContext");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateContext(request));
}

StatusOr<google::cloud::aiplatform::v1::Context>
MetadataServiceTracingConnection::GetContext(
    google::cloud::aiplatform::v1::GetContextRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::GetContext");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetContext(request));
}

StreamRange<google::cloud::aiplatform::v1::Context>
MetadataServiceTracingConnection::ListContexts(
    google::cloud::aiplatform::v1::ListContextsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::ListContexts");
  internal::OTelScope scope(span);
  auto sr = child_->ListContexts(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::Context>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::aiplatform::v1::Context>
MetadataServiceTracingConnection::UpdateContext(
    google::cloud::aiplatform::v1::UpdateContextRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::UpdateContext");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateContext(request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
MetadataServiceTracingConnection::DeleteContext(
    google::cloud::aiplatform::v1::DeleteContextRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::DeleteContext");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteContext(request));
}

StatusOr<google::longrunning::Operation>
MetadataServiceTracingConnection::DeleteContext(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteContextRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::DeleteContext");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteContext(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
MetadataServiceTracingConnection::DeleteContext(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::DeleteContext");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteContext(operation));
}

future<StatusOr<google::cloud::aiplatform::v1::PurgeContextsResponse>>
MetadataServiceTracingConnection::PurgeContexts(
    google::cloud::aiplatform::v1::PurgeContextsRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::PurgeContexts");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PurgeContexts(request));
}

StatusOr<google::longrunning::Operation>
MetadataServiceTracingConnection::PurgeContexts(
    NoAwaitTag,
    google::cloud::aiplatform::v1::PurgeContextsRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::PurgeContexts");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->PurgeContexts(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::PurgeContextsResponse>>
MetadataServiceTracingConnection::PurgeContexts(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::PurgeContexts");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PurgeContexts(operation));
}

StatusOr<
    google::cloud::aiplatform::v1::AddContextArtifactsAndExecutionsResponse>
MetadataServiceTracingConnection::AddContextArtifactsAndExecutions(
    google::cloud::aiplatform::v1::
        AddContextArtifactsAndExecutionsRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::"
      "AddContextArtifactsAndExecutions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->AddContextArtifactsAndExecutions(request));
}

StatusOr<google::cloud::aiplatform::v1::AddContextChildrenResponse>
MetadataServiceTracingConnection::AddContextChildren(
    google::cloud::aiplatform::v1::AddContextChildrenRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::AddContextChildren");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->AddContextChildren(request));
}

StatusOr<google::cloud::aiplatform::v1::RemoveContextChildrenResponse>
MetadataServiceTracingConnection::RemoveContextChildren(
    google::cloud::aiplatform::v1::RemoveContextChildrenRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::RemoveContextChildren");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->RemoveContextChildren(request));
}

StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
MetadataServiceTracingConnection::QueryContextLineageSubgraph(
    google::cloud::aiplatform::v1::QueryContextLineageSubgraphRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::QueryContextLineageSubgraph");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->QueryContextLineageSubgraph(request));
}

StatusOr<google::cloud::aiplatform::v1::Execution>
MetadataServiceTracingConnection::CreateExecution(
    google::cloud::aiplatform::v1::CreateExecutionRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::CreateExecution");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateExecution(request));
}

StatusOr<google::cloud::aiplatform::v1::Execution>
MetadataServiceTracingConnection::GetExecution(
    google::cloud::aiplatform::v1::GetExecutionRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::GetExecution");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetExecution(request));
}

StreamRange<google::cloud::aiplatform::v1::Execution>
MetadataServiceTracingConnection::ListExecutions(
    google::cloud::aiplatform::v1::ListExecutionsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::ListExecutions");
  internal::OTelScope scope(span);
  auto sr = child_->ListExecutions(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::Execution>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::aiplatform::v1::Execution>
MetadataServiceTracingConnection::UpdateExecution(
    google::cloud::aiplatform::v1::UpdateExecutionRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::UpdateExecution");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateExecution(request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
MetadataServiceTracingConnection::DeleteExecution(
    google::cloud::aiplatform::v1::DeleteExecutionRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::DeleteExecution");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteExecution(request));
}

StatusOr<google::longrunning::Operation>
MetadataServiceTracingConnection::DeleteExecution(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteExecutionRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::DeleteExecution");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteExecution(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
MetadataServiceTracingConnection::DeleteExecution(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::DeleteExecution");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteExecution(operation));
}

future<StatusOr<google::cloud::aiplatform::v1::PurgeExecutionsResponse>>
MetadataServiceTracingConnection::PurgeExecutions(
    google::cloud::aiplatform::v1::PurgeExecutionsRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::PurgeExecutions");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PurgeExecutions(request));
}

StatusOr<google::longrunning::Operation>
MetadataServiceTracingConnection::PurgeExecutions(
    NoAwaitTag,
    google::cloud::aiplatform::v1::PurgeExecutionsRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::PurgeExecutions");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->PurgeExecutions(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::PurgeExecutionsResponse>>
MetadataServiceTracingConnection::PurgeExecutions(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::PurgeExecutions");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PurgeExecutions(operation));
}

StatusOr<google::cloud::aiplatform::v1::AddExecutionEventsResponse>
MetadataServiceTracingConnection::AddExecutionEvents(
    google::cloud::aiplatform::v1::AddExecutionEventsRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::AddExecutionEvents");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->AddExecutionEvents(request));
}

StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
MetadataServiceTracingConnection::QueryExecutionInputsAndOutputs(
    google::cloud::aiplatform::v1::QueryExecutionInputsAndOutputsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::"
      "QueryExecutionInputsAndOutputs");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->QueryExecutionInputsAndOutputs(request));
}

StatusOr<google::cloud::aiplatform::v1::MetadataSchema>
MetadataServiceTracingConnection::CreateMetadataSchema(
    google::cloud::aiplatform::v1::CreateMetadataSchemaRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::CreateMetadataSchema");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateMetadataSchema(request));
}

StatusOr<google::cloud::aiplatform::v1::MetadataSchema>
MetadataServiceTracingConnection::GetMetadataSchema(
    google::cloud::aiplatform::v1::GetMetadataSchemaRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::GetMetadataSchema");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetMetadataSchema(request));
}

StreamRange<google::cloud::aiplatform::v1::MetadataSchema>
MetadataServiceTracingConnection::ListMetadataSchemas(
    google::cloud::aiplatform::v1::ListMetadataSchemasRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::ListMetadataSchemas");
  internal::OTelScope scope(span);
  auto sr = child_->ListMetadataSchemas(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::MetadataSchema>(std::move(span),
                                                     std::move(sr));
}

StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
MetadataServiceTracingConnection::QueryArtifactLineageSubgraph(
    google::cloud::aiplatform::v1::QueryArtifactLineageSubgraphRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MetadataServiceConnection::QueryArtifactLineageSubgraph");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->QueryArtifactLineageSubgraph(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<aiplatform_v1::MetadataServiceConnection>
MakeMetadataServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::MetadataServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<MetadataServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
