// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/automl/v1/service.proto

#include "google/cloud/automl/v1/internal/auto_ml_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/automl/v1/service.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace automl_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AutoMlStub::~AutoMlStub() = default;

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncCreateDataset(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::automl::v1::CreateDatasetRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::automl::v1::CreateDatasetRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::automl::v1::CreateDatasetRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateDataset(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultAutoMlStub::CreateDataset(
    grpc::ClientContext& context, Options,
    google::cloud::automl::v1::CreateDatasetRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->CreateDataset(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::automl::v1::Dataset> DefaultAutoMlStub::GetDataset(
    grpc::ClientContext& context, Options const&,
    google::cloud::automl::v1::GetDatasetRequest const& request) {
  google::cloud::automl::v1::Dataset response;
  auto status = grpc_stub_->GetDataset(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::automl::v1::ListDatasetsResponse>
DefaultAutoMlStub::ListDatasets(
    grpc::ClientContext& context, Options const&,
    google::cloud::automl::v1::ListDatasetsRequest const& request) {
  google::cloud::automl::v1::ListDatasetsResponse response;
  auto status = grpc_stub_->ListDatasets(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::automl::v1::Dataset> DefaultAutoMlStub::UpdateDataset(
    grpc::ClientContext& context, Options const&,
    google::cloud::automl::v1::UpdateDatasetRequest const& request) {
  google::cloud::automl::v1::Dataset response;
  auto status = grpc_stub_->UpdateDataset(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncDeleteDataset(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::automl::v1::DeleteDatasetRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::automl::v1::DeleteDatasetRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::automl::v1::DeleteDatasetRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteDataset(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultAutoMlStub::DeleteDataset(
    grpc::ClientContext& context, Options,
    google::cloud::automl::v1::DeleteDatasetRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->DeleteDataset(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncImportData(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::automl::v1::ImportDataRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::automl::v1::ImportDataRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::automl::v1::ImportDataRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncImportData(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultAutoMlStub::ImportData(
    grpc::ClientContext& context, Options,
    google::cloud::automl::v1::ImportDataRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->ImportData(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncExportData(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::automl::v1::ExportDataRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::automl::v1::ExportDataRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::automl::v1::ExportDataRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncExportData(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultAutoMlStub::ExportData(
    grpc::ClientContext& context, Options,
    google::cloud::automl::v1::ExportDataRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->ExportData(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::automl::v1::AnnotationSpec>
DefaultAutoMlStub::GetAnnotationSpec(
    grpc::ClientContext& context, Options const&,
    google::cloud::automl::v1::GetAnnotationSpecRequest const& request) {
  google::cloud::automl::v1::AnnotationSpec response;
  auto status = grpc_stub_->GetAnnotationSpec(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncCreateModel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::automl::v1::CreateModelRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::automl::v1::CreateModelRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::automl::v1::CreateModelRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateModel(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultAutoMlStub::CreateModel(
    grpc::ClientContext& context, Options,
    google::cloud::automl::v1::CreateModelRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->CreateModel(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::automl::v1::Model> DefaultAutoMlStub::GetModel(
    grpc::ClientContext& context, Options const&,
    google::cloud::automl::v1::GetModelRequest const& request) {
  google::cloud::automl::v1::Model response;
  auto status = grpc_stub_->GetModel(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::automl::v1::ListModelsResponse>
DefaultAutoMlStub::ListModels(
    grpc::ClientContext& context, Options const&,
    google::cloud::automl::v1::ListModelsRequest const& request) {
  google::cloud::automl::v1::ListModelsResponse response;
  auto status = grpc_stub_->ListModels(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncDeleteModel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::automl::v1::DeleteModelRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::automl::v1::DeleteModelRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::automl::v1::DeleteModelRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteModel(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultAutoMlStub::DeleteModel(
    grpc::ClientContext& context, Options,
    google::cloud::automl::v1::DeleteModelRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->DeleteModel(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::automl::v1::Model> DefaultAutoMlStub::UpdateModel(
    grpc::ClientContext& context, Options const&,
    google::cloud::automl::v1::UpdateModelRequest const& request) {
  google::cloud::automl::v1::Model response;
  auto status = grpc_stub_->UpdateModel(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncDeployModel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::automl::v1::DeployModelRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::automl::v1::DeployModelRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::automl::v1::DeployModelRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeployModel(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultAutoMlStub::DeployModel(
    grpc::ClientContext& context, Options,
    google::cloud::automl::v1::DeployModelRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->DeployModel(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncUndeployModel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::automl::v1::UndeployModelRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::automl::v1::UndeployModelRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::automl::v1::UndeployModelRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUndeployModel(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultAutoMlStub::UndeployModel(
    grpc::ClientContext& context, Options,
    google::cloud::automl::v1::UndeployModelRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->UndeployModel(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncExportModel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::automl::v1::ExportModelRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::automl::v1::ExportModelRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::automl::v1::ExportModelRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncExportModel(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultAutoMlStub::ExportModel(
    grpc::ClientContext& context, Options,
    google::cloud::automl::v1::ExportModelRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->ExportModel(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::automl::v1::ModelEvaluation>
DefaultAutoMlStub::GetModelEvaluation(
    grpc::ClientContext& context, Options const&,
    google::cloud::automl::v1::GetModelEvaluationRequest const& request) {
  google::cloud::automl::v1::ModelEvaluation response;
  auto status = grpc_stub_->GetModelEvaluation(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::automl::v1::ListModelEvaluationsResponse>
DefaultAutoMlStub::ListModelEvaluations(
    grpc::ClientContext& context, Options const&,
    google::cloud::automl::v1::ListModelEvaluationsRequest const& request) {
  google::cloud::automl::v1::ListModelEvaluationsResponse response;
  auto status = grpc_stub_->ListModelEvaluations(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::GetOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::GetOperationRequest,
                                    google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::longrunning::GetOperationRequest const& request,
             grpc::CompletionQueue* cq) {
        return operations_->AsyncGetOperation(context, request, cq);
      },
      request, std::move(context));
}

future<Status> DefaultAutoMlStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::CancelOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::CancelOperationRequest,
                                    google::protobuf::Empty>(
             cq,
             [this](grpc::ClientContext* context,
                    google::longrunning::CancelOperationRequest const& request,
                    grpc::CompletionQueue* cq) {
               return operations_->AsyncCancelOperation(context, request, cq);
             },
             request, std::move(context))
      .then([](future<StatusOr<google::protobuf::Empty>> f) {
        return f.get().status();
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace automl_v1_internal
}  // namespace cloud
}  // namespace google
