// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/batch/v1/batch.proto

#include "google/cloud/batch/v1/internal/batch_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/batch/v1/batch.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace batch_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BatchServiceStub::~BatchServiceStub() = default;

StatusOr<google::cloud::batch::v1::Job> DefaultBatchServiceStub::CreateJob(
    grpc::ClientContext& context, Options const&,
    google::cloud::batch::v1::CreateJobRequest const& request) {
  google::cloud::batch::v1::Job response;
  auto status = grpc_stub_->CreateJob(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::batch::v1::Job> DefaultBatchServiceStub::GetJob(
    grpc::ClientContext& context, Options const&,
    google::cloud::batch::v1::GetJobRequest const& request) {
  google::cloud::batch::v1::Job response;
  auto status = grpc_stub_->GetJob(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultBatchServiceStub::AsyncDeleteJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::batch::v1::DeleteJobRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::cloud::batch::v1::DeleteJobRequest,
                                    google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::batch::v1::DeleteJobRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteJob(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultBatchServiceStub::DeleteJob(
    grpc::ClientContext& context, Options,
    google::cloud::batch::v1::DeleteJobRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->DeleteJob(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::batch::v1::ListJobsResponse>
DefaultBatchServiceStub::ListJobs(
    grpc::ClientContext& context, Options const&,
    google::cloud::batch::v1::ListJobsRequest const& request) {
  google::cloud::batch::v1::ListJobsResponse response;
  auto status = grpc_stub_->ListJobs(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::batch::v1::Task> DefaultBatchServiceStub::GetTask(
    grpc::ClientContext& context, Options const&,
    google::cloud::batch::v1::GetTaskRequest const& request) {
  google::cloud::batch::v1::Task response;
  auto status = grpc_stub_->GetTask(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::batch::v1::ListTasksResponse>
DefaultBatchServiceStub::ListTasks(
    grpc::ClientContext& context, Options const&,
    google::cloud::batch::v1::ListTasksRequest const& request) {
  google::cloud::batch::v1::ListTasksResponse response;
  auto status = grpc_stub_->ListTasks(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultBatchServiceStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::GetOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::GetOperationRequest,
                                    google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::longrunning::GetOperationRequest const& request,
             grpc::CompletionQueue* cq) {
        return operations_->AsyncGetOperation(context, request, cq);
      },
      request, std::move(context));
}

future<Status> DefaultBatchServiceStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::CancelOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::CancelOperationRequest,
                                    google::protobuf::Empty>(
             cq,
             [this](grpc::ClientContext* context,
                    google::longrunning::CancelOperationRequest const& request,
                    grpc::CompletionQueue* cq) {
               return operations_->AsyncCancelOperation(context, request, cq);
             },
             request, std::move(context))
      .then([](future<StatusOr<google::protobuf::Empty>> f) {
        return f.get().status();
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace batch_v1_internal
}  // namespace cloud
}  // namespace google
