// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/dataset.proto

#include "google/cloud/bigquerycontrol/v2/internal/dataset_rest_stub.h"
#include "google/cloud/common_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/rest_stub_helpers.h"
#include "google/cloud/status_or.h"
#include <google/cloud/bigquery/v2/dataset.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DefaultDatasetServiceRestStub::DefaultDatasetServiceRestStub(Options options)
    : service_(rest_internal::MakePooledRestClient(
          options.get<EndpointOption>(), options)),
      options_(std::move(options)) {}

DefaultDatasetServiceRestStub::DefaultDatasetServiceRestStub(
    std::shared_ptr<rest_internal::RestClient> service, Options options)
    : service_(std::move(service)), options_(std::move(options)) {}

StatusOr<google::cloud::bigquery::v2::Dataset>
DefaultDatasetServiceRestStub::GetDataset(
    google::cloud::rest_internal::RestContext& rest_context,
    Options const& options,
    google::cloud::bigquery::v2::GetDatasetRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  query_params.push_back(
      {"dataset_view", std::to_string(request.dataset_view())});
  query_params =
      rest_internal::TrimEmptyQueryParameters(std::move(query_params));
  return rest_internal::Get<google::cloud::bigquery::v2::Dataset>(
      *service_, rest_context, request, false,
      absl::StrCat("/", "bigquery", "/",
                   rest_internal::DetermineApiVersion("v2", options), "/",
                   "projects", "/", request.project_id(), "/", "datasets", "/",
                   request.dataset_id()),
      std::move(query_params));
}

StatusOr<google::cloud::bigquery::v2::Dataset>
DefaultDatasetServiceRestStub::InsertDataset(
    google::cloud::rest_internal::RestContext& rest_context,
    Options const& options,
    google::cloud::bigquery::v2::InsertDatasetRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  return rest_internal::Post<google::cloud::bigquery::v2::Dataset>(
      *service_, rest_context, request.dataset(), false,
      absl::StrCat("/", "bigquery", "/",
                   rest_internal::DetermineApiVersion("v2", options), "/",
                   "projects", "/", request.project_id(), "/", "datasets"),
      std::move(query_params));
}

StatusOr<google::cloud::bigquery::v2::Dataset>
DefaultDatasetServiceRestStub::PatchDataset(
    google::cloud::rest_internal::RestContext& rest_context,
    Options const& options,
    google::cloud::bigquery::v2::UpdateOrPatchDatasetRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  return rest_internal::Patch<google::cloud::bigquery::v2::Dataset>(
      *service_, rest_context, request.dataset(), false,
      absl::StrCat("/", "bigquery", "/",
                   rest_internal::DetermineApiVersion("v2", options), "/",
                   "projects", "/", request.project_id(), "/", "datasets", "/",
                   request.dataset_id()),
      std::move(query_params));
}

StatusOr<google::cloud::bigquery::v2::Dataset>
DefaultDatasetServiceRestStub::UpdateDataset(
    google::cloud::rest_internal::RestContext& rest_context,
    Options const& options,
    google::cloud::bigquery::v2::UpdateOrPatchDatasetRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  return rest_internal::Put<google::cloud::bigquery::v2::Dataset>(
      *service_, rest_context, request.dataset(), false,
      absl::StrCat("/", "bigquery", "/",
                   rest_internal::DetermineApiVersion("v2", options), "/",
                   "projects", "/", request.project_id(), "/", "datasets", "/",
                   request.dataset_id()),
      std::move(query_params));
}

Status DefaultDatasetServiceRestStub::DeleteDataset(
    google::cloud::rest_internal::RestContext& rest_context,
    Options const& options,
    google::cloud::bigquery::v2::DeleteDatasetRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  query_params.push_back(
      {"delete_contents", (request.delete_contents() ? "1" : "0")});
  query_params =
      rest_internal::TrimEmptyQueryParameters(std::move(query_params));
  return rest_internal::Delete<google::cloud::rest_internal::EmptyResponseType>(
      *service_, rest_context, request, false,
      absl::StrCat("/", "bigquery", "/",
                   rest_internal::DetermineApiVersion("v2", options), "/",
                   "projects", "/", request.project_id(), "/", "datasets", "/",
                   request.dataset_id()),
      std::move(query_params));
}

StatusOr<google::cloud::bigquery::v2::DatasetList>
DefaultDatasetServiceRestStub::ListDatasets(
    google::cloud::rest_internal::RestContext& rest_context,
    Options const& options,
    google::cloud::bigquery::v2::ListDatasetsRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  query_params.push_back(
      {"max_results", (request.has_max_results()
                           ? std::to_string(request.max_results().value())
                           : "")});
  query_params.push_back({"page_token", request.page_token()});
  query_params.push_back({"all", (request.all() ? "1" : "0")});
  query_params.push_back({"filter", request.filter()});
  query_params =
      rest_internal::TrimEmptyQueryParameters(std::move(query_params));
  return rest_internal::Get<google::cloud::bigquery::v2::DatasetList>(
      *service_, rest_context, request, false,
      absl::StrCat("/", "bigquery", "/",
                   rest_internal::DetermineApiVersion("v2", options), "/",
                   "projects", "/", request.project_id(), "/", "datasets"),
      std::move(query_params));
}

StatusOr<google::cloud::bigquery::v2::Dataset>
DefaultDatasetServiceRestStub::UndeleteDataset(
    google::cloud::rest_internal::RestContext& rest_context,
    Options const& options,
    google::cloud::bigquery::v2::UndeleteDatasetRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  return rest_internal::Post<google::cloud::bigquery::v2::Dataset>(
      *service_, rest_context, request, false,
      absl::StrCat("/", "bigquery", "/",
                   rest_internal::DetermineApiVersion("v2", options), "/",
                   "projects", "/", request.project_id(), "/", "datasets", "/",
                   request.dataset_id(), ":undelete"),
      std::move(query_params));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2_internal
}  // namespace cloud
}  // namespace google
