// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/routine.proto

#include "google/cloud/bigquerycontrol/v2/internal/routine_option_defaults.h"
#include "google/cloud/bigquerycontrol/v2/routine_connection.h"
#include "google/cloud/bigquerycontrol/v2/routine_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options RoutineServiceDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_ROUTINE_SERVICE_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_ROUTINE_SERVICE_AUTHORITY", "bigquery.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<bigquerycontrol_v2::RoutineServiceRetryPolicyOption>()) {
    options.set<bigquerycontrol_v2::RoutineServiceRetryPolicyOption>(
        bigquerycontrol_v2::RoutineServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<bigquerycontrol_v2::RoutineServiceBackoffPolicyOption>()) {
    options.set<bigquerycontrol_v2::RoutineServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<bigquerycontrol_v2::
                       RoutineServiceConnectionIdempotencyPolicyOption>()) {
    options.set<
        bigquerycontrol_v2::RoutineServiceConnectionIdempotencyPolicyOption>(
        bigquerycontrol_v2::
            MakeDefaultRoutineServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2_internal
}  // namespace cloud
}  // namespace google
