// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/certificatemanager/v1/certificate_manager.proto

#include "google/cloud/certificatemanager/v1/certificate_manager_connection.h"
#include "google/cloud/certificatemanager/v1/certificate_manager_options.h"
#include "google/cloud/certificatemanager/v1/internal/certificate_manager_connection_impl.h"
#include "google/cloud/certificatemanager/v1/internal/certificate_manager_option_defaults.h"
#include "google/cloud/certificatemanager/v1/internal/certificate_manager_stub_factory.h"
#include "google/cloud/certificatemanager/v1/internal/certificate_manager_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace certificatemanager_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CertificateManagerConnection::~CertificateManagerConnection() = default;

StreamRange<google::cloud::certificatemanager::v1::Certificate>
CertificateManagerConnection::ListCertificates(
    google::cloud::certificatemanager::v1::
        ListCertificatesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::certificatemanager::v1::Certificate>>();
}

StatusOr<google::cloud::certificatemanager::v1::Certificate>
CertificateManagerConnection::GetCertificate(
    google::cloud::certificatemanager::v1::GetCertificateRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::certificatemanager::v1::Certificate>>
CertificateManagerConnection::CreateCertificate(
    google::cloud::certificatemanager::v1::CreateCertificateRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::Certificate>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CertificateManagerConnection::CreateCertificate(
    NoAwaitTag,
    google::cloud::certificatemanager::v1::CreateCertificateRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::Certificate>>
CertificateManagerConnection::CreateCertificate(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::Certificate>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::Certificate>>
CertificateManagerConnection::UpdateCertificate(
    google::cloud::certificatemanager::v1::UpdateCertificateRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::Certificate>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CertificateManagerConnection::UpdateCertificate(
    NoAwaitTag,
    google::cloud::certificatemanager::v1::UpdateCertificateRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::Certificate>>
CertificateManagerConnection::UpdateCertificate(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::Certificate>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
CertificateManagerConnection::DeleteCertificate(
    google::cloud::certificatemanager::v1::DeleteCertificateRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CertificateManagerConnection::DeleteCertificate(
    NoAwaitTag,
    google::cloud::certificatemanager::v1::DeleteCertificateRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
CertificateManagerConnection::DeleteCertificate(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::certificatemanager::v1::CertificateMap>
CertificateManagerConnection::ListCertificateMaps(
    google::cloud::certificatemanager::v1::
        ListCertificateMapsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::certificatemanager::v1::CertificateMap>>();
}

StatusOr<google::cloud::certificatemanager::v1::CertificateMap>
CertificateManagerConnection::GetCertificateMap(
    google::cloud::certificatemanager::v1::GetCertificateMapRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::certificatemanager::v1::CertificateMap>>
CertificateManagerConnection::CreateCertificateMap(
    google::cloud::certificatemanager::v1::CreateCertificateMapRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::CertificateMap>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CertificateManagerConnection::CreateCertificateMap(
    NoAwaitTag,
    google::cloud::certificatemanager::v1::CreateCertificateMapRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::CertificateMap>>
CertificateManagerConnection::CreateCertificateMap(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::CertificateMap>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::CertificateMap>>
CertificateManagerConnection::UpdateCertificateMap(
    google::cloud::certificatemanager::v1::UpdateCertificateMapRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::CertificateMap>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CertificateManagerConnection::UpdateCertificateMap(
    NoAwaitTag,
    google::cloud::certificatemanager::v1::UpdateCertificateMapRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::CertificateMap>>
CertificateManagerConnection::UpdateCertificateMap(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::CertificateMap>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
CertificateManagerConnection::DeleteCertificateMap(
    google::cloud::certificatemanager::v1::DeleteCertificateMapRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CertificateManagerConnection::DeleteCertificateMap(
    NoAwaitTag,
    google::cloud::certificatemanager::v1::DeleteCertificateMapRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
CertificateManagerConnection::DeleteCertificateMap(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::certificatemanager::v1::CertificateMapEntry>
CertificateManagerConnection::ListCertificateMapEntries(
    google::cloud::certificatemanager::v1::
        ListCertificateMapEntriesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<StreamRange<
      google::cloud::certificatemanager::v1::CertificateMapEntry>>();
}

StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>
CertificateManagerConnection::GetCertificateMapEntry(
    google::cloud::certificatemanager::v1::
        GetCertificateMapEntryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>>
CertificateManagerConnection::CreateCertificateMapEntry(
    google::cloud::certificatemanager::v1::
        CreateCertificateMapEntryRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CertificateManagerConnection::CreateCertificateMapEntry(
    NoAwaitTag, google::cloud::certificatemanager::v1::
                    CreateCertificateMapEntryRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>>
CertificateManagerConnection::CreateCertificateMapEntry(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>>
CertificateManagerConnection::UpdateCertificateMapEntry(
    google::cloud::certificatemanager::v1::
        UpdateCertificateMapEntryRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CertificateManagerConnection::UpdateCertificateMapEntry(
    NoAwaitTag, google::cloud::certificatemanager::v1::
                    UpdateCertificateMapEntryRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>>
CertificateManagerConnection::UpdateCertificateMapEntry(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
CertificateManagerConnection::DeleteCertificateMapEntry(
    google::cloud::certificatemanager::v1::
        DeleteCertificateMapEntryRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CertificateManagerConnection::DeleteCertificateMapEntry(
    NoAwaitTag, google::cloud::certificatemanager::v1::
                    DeleteCertificateMapEntryRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
CertificateManagerConnection::DeleteCertificateMapEntry(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::certificatemanager::v1::DnsAuthorization>
CertificateManagerConnection::ListDnsAuthorizations(
    google::cloud::certificatemanager::v1::
        ListDnsAuthorizationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::certificatemanager::v1::DnsAuthorization>>();
}

StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>
CertificateManagerConnection::GetDnsAuthorization(
    google::cloud::certificatemanager::v1::GetDnsAuthorizationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>>
CertificateManagerConnection::CreateDnsAuthorization(
    google::cloud::certificatemanager::v1::
        CreateDnsAuthorizationRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CertificateManagerConnection::CreateDnsAuthorization(
    NoAwaitTag, google::cloud::certificatemanager::v1::
                    CreateDnsAuthorizationRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>>
CertificateManagerConnection::CreateDnsAuthorization(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>>
CertificateManagerConnection::UpdateDnsAuthorization(
    google::cloud::certificatemanager::v1::
        UpdateDnsAuthorizationRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CertificateManagerConnection::UpdateDnsAuthorization(
    NoAwaitTag, google::cloud::certificatemanager::v1::
                    UpdateDnsAuthorizationRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>>
CertificateManagerConnection::UpdateDnsAuthorization(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
CertificateManagerConnection::DeleteDnsAuthorization(
    google::cloud::certificatemanager::v1::
        DeleteDnsAuthorizationRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CertificateManagerConnection::DeleteDnsAuthorization(
    NoAwaitTag, google::cloud::certificatemanager::v1::
                    DeleteDnsAuthorizationRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
CertificateManagerConnection::DeleteDnsAuthorization(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::certificatemanager::v1::CertificateIssuanceConfig>
CertificateManagerConnection::ListCertificateIssuanceConfigs(
    google::cloud::certificatemanager::v1::
        ListCertificateIssuanceConfigsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<StreamRange<
      google::cloud::certificatemanager::v1::CertificateIssuanceConfig>>();
}

StatusOr<google::cloud::certificatemanager::v1::CertificateIssuanceConfig>
CertificateManagerConnection::GetCertificateIssuanceConfig(
    google::cloud::certificatemanager::v1::
        GetCertificateIssuanceConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<
    StatusOr<google::cloud::certificatemanager::v1::CertificateIssuanceConfig>>
CertificateManagerConnection::CreateCertificateIssuanceConfig(
    google::cloud::certificatemanager::v1::
        CreateCertificateIssuanceConfigRequest const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::cloud::certificatemanager::v1::CertificateIssuanceConfig>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CertificateManagerConnection::CreateCertificateIssuanceConfig(
    NoAwaitTag, google::cloud::certificatemanager::v1::
                    CreateCertificateIssuanceConfigRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<
    StatusOr<google::cloud::certificatemanager::v1::CertificateIssuanceConfig>>
CertificateManagerConnection::CreateCertificateIssuanceConfig(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::cloud::certificatemanager::v1::CertificateIssuanceConfig>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
CertificateManagerConnection::DeleteCertificateIssuanceConfig(
    google::cloud::certificatemanager::v1::
        DeleteCertificateIssuanceConfigRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CertificateManagerConnection::DeleteCertificateIssuanceConfig(
    NoAwaitTag, google::cloud::certificatemanager::v1::
                    DeleteCertificateIssuanceConfigRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
CertificateManagerConnection::DeleteCertificateIssuanceConfig(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::certificatemanager::v1::TrustConfig>
CertificateManagerConnection::ListTrustConfigs(
    google::cloud::certificatemanager::v1::
        ListTrustConfigsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::certificatemanager::v1::TrustConfig>>();
}

StatusOr<google::cloud::certificatemanager::v1::TrustConfig>
CertificateManagerConnection::GetTrustConfig(
    google::cloud::certificatemanager::v1::GetTrustConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::certificatemanager::v1::TrustConfig>>
CertificateManagerConnection::CreateTrustConfig(
    google::cloud::certificatemanager::v1::CreateTrustConfigRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::TrustConfig>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CertificateManagerConnection::CreateTrustConfig(
    NoAwaitTag,
    google::cloud::certificatemanager::v1::CreateTrustConfigRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::TrustConfig>>
CertificateManagerConnection::CreateTrustConfig(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::TrustConfig>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::TrustConfig>>
CertificateManagerConnection::UpdateTrustConfig(
    google::cloud::certificatemanager::v1::UpdateTrustConfigRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::TrustConfig>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CertificateManagerConnection::UpdateTrustConfig(
    NoAwaitTag,
    google::cloud::certificatemanager::v1::UpdateTrustConfigRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::TrustConfig>>
CertificateManagerConnection::UpdateTrustConfig(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::TrustConfig>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
CertificateManagerConnection::DeleteTrustConfig(
    google::cloud::certificatemanager::v1::DeleteTrustConfigRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CertificateManagerConnection::DeleteTrustConfig(
    NoAwaitTag,
    google::cloud::certificatemanager::v1::DeleteTrustConfigRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
CertificateManagerConnection::DeleteTrustConfig(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<CertificateManagerConnection> MakeCertificateManagerConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 CertificateManagerPolicyOptionList>(options,
                                                                     __func__);
  options = certificatemanager_v1_internal::CertificateManagerDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub =
      certificatemanager_v1_internal::CreateDefaultCertificateManagerStub(
          std::move(auth), options);
  return certificatemanager_v1_internal::
      MakeCertificateManagerTracingConnection(
          std::make_shared<
              certificatemanager_v1_internal::CertificateManagerConnectionImpl>(
              std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace certificatemanager_v1
}  // namespace cloud
}  // namespace google
