// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/addresses/v1/addresses.proto

#include "google/cloud/compute/addresses/v1/addresses_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_addresses_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AddressesClient::AddressesClient(
    std::shared_ptr<AddressesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
AddressesClient::~AddressesClient() = default;

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::AddressesScopedList>>
AddressesClient::AggregatedListAddresses(std::string const& project,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::addresses::v1::AggregatedListAddressesRequest
      request;
  request.set_project(project);
  return connection_->AggregatedListAddresses(request);
}

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::AddressesScopedList>>
AddressesClient::AggregatedListAddresses(
    google::cloud::cpp::compute::addresses::v1::AggregatedListAddressesRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregatedListAddresses(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
AddressesClient::DeleteAddress(std::string const& project,
                               std::string const& region,
                               std::string const& address, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::addresses::v1::DeleteAddressRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_address(address);
  return connection_->DeleteAddress(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
AddressesClient::DeleteAddress(NoAwaitTag, std::string const& project,
                               std::string const& region,
                               std::string const& address, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::addresses::v1::DeleteAddressRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_address(address);
  return connection_->DeleteAddress(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
AddressesClient::DeleteAddress(
    google::cloud::cpp::compute::addresses::v1::DeleteAddressRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAddress(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
AddressesClient::DeleteAddress(
    NoAwaitTag,
    google::cloud::cpp::compute::addresses::v1::DeleteAddressRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAddress(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
AddressesClient::DeleteAddress(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAddress(operation);
}

StatusOr<google::cloud::cpp::compute::v1::Address> AddressesClient::GetAddress(
    std::string const& project, std::string const& region,
    std::string const& address, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::addresses::v1::GetAddressRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_address(address);
  return connection_->GetAddress(request);
}

StatusOr<google::cloud::cpp::compute::v1::Address> AddressesClient::GetAddress(
    google::cloud::cpp::compute::addresses::v1::GetAddressRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAddress(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
AddressesClient::InsertAddress(
    std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::Address const& address_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::addresses::v1::InsertAddressRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_address_resource() = address_resource;
  return connection_->InsertAddress(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
AddressesClient::InsertAddress(
    NoAwaitTag, std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::Address const& address_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::addresses::v1::InsertAddressRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_address_resource() = address_resource;
  return connection_->InsertAddress(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
AddressesClient::InsertAddress(
    google::cloud::cpp::compute::addresses::v1::InsertAddressRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertAddress(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
AddressesClient::InsertAddress(
    NoAwaitTag,
    google::cloud::cpp::compute::addresses::v1::InsertAddressRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertAddress(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
AddressesClient::InsertAddress(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertAddress(operation);
}

StreamRange<google::cloud::cpp::compute::v1::Address>
AddressesClient::ListAddresses(std::string const& project,
                               std::string const& region, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::addresses::v1::ListAddressesRequest request;
  request.set_project(project);
  request.set_region(region);
  return connection_->ListAddresses(request);
}

StreamRange<google::cloud::cpp::compute::v1::Address>
AddressesClient::ListAddresses(
    google::cloud::cpp::compute::addresses::v1::ListAddressesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListAddresses(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
AddressesClient::Move(
    std::string const& project, std::string const& region,
    std::string const& address,
    google::cloud::cpp::compute::v1::RegionAddressesMoveRequest const&
        region_addresses_move_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::addresses::v1::MoveRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_address(address);
  *request.mutable_region_addresses_move_request_resource() =
      region_addresses_move_request_resource;
  return connection_->Move(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation> AddressesClient::Move(
    NoAwaitTag, std::string const& project, std::string const& region,
    std::string const& address,
    google::cloud::cpp::compute::v1::RegionAddressesMoveRequest const&
        region_addresses_move_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::addresses::v1::MoveRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_address(address);
  *request.mutable_region_addresses_move_request_resource() =
      region_addresses_move_request_resource;
  return connection_->Move(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
AddressesClient::Move(
    google::cloud::cpp::compute::addresses::v1::MoveRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Move(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation> AddressesClient::Move(
    NoAwaitTag,
    google::cloud::cpp::compute::addresses::v1::MoveRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Move(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
AddressesClient::Move(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Move(operation);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
AddressesClient::SetLabels(
    std::string const& project, std::string const& region,
    std::string const& resource,
    google::cloud::cpp::compute::v1::RegionSetLabelsRequest const&
        region_set_labels_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::addresses::v1::SetLabelsRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  *request.mutable_region_set_labels_request_resource() =
      region_set_labels_request_resource;
  return connection_->SetLabels(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation> AddressesClient::SetLabels(
    NoAwaitTag, std::string const& project, std::string const& region,
    std::string const& resource,
    google::cloud::cpp::compute::v1::RegionSetLabelsRequest const&
        region_set_labels_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::addresses::v1::SetLabelsRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  *request.mutable_region_set_labels_request_resource() =
      region_set_labels_request_resource;
  return connection_->SetLabels(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
AddressesClient::SetLabels(
    google::cloud::cpp::compute::addresses::v1::SetLabelsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetLabels(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation> AddressesClient::SetLabels(
    NoAwaitTag,
    google::cloud::cpp::compute::addresses::v1::SetLabelsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetLabels(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
AddressesClient::SetLabels(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetLabels(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_addresses_v1
}  // namespace cloud
}  // namespace google
