// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/region_instances/v1/region_instances.proto

#include "google/cloud/compute/region_instances/v1/internal/region_instances_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_region_instances_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

RegionInstancesTracingConnection::RegionInstancesTracingConnection(
    std::shared_ptr<compute_region_instances_v1::RegionInstancesConnection>
        child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstancesTracingConnection::BulkInsert(
    google::cloud::cpp::compute::region_instances::v1::BulkInsertRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_region_instances_v1::RegionInstancesConnection::BulkInsert");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->BulkInsert(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionInstancesTracingConnection::BulkInsert(
    NoAwaitTag,
    google::cloud::cpp::compute::region_instances::v1::BulkInsertRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_region_instances_v1::RegionInstancesConnection::BulkInsert");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->BulkInsert(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstancesTracingConnection::BulkInsert(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_region_instances_v1::RegionInstancesConnection::BulkInsert");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->BulkInsert(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_region_instances_v1::RegionInstancesConnection>
MakeRegionInstancesTracingConnection(
    std::shared_ptr<compute_region_instances_v1::RegionInstancesConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<RegionInstancesTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_instances_v1_internal
}  // namespace cloud
}  // namespace google
