// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/catalog.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_MOCKS_MOCK_CATALOG_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_MOCKS_MOCK_CATALOG_CONNECTION_H

#include "google/cloud/dataplex/v1/catalog_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace dataplex_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `CatalogServiceConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `CatalogServiceClient`. To do so,
 * construct an object of type `CatalogServiceClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockCatalogServiceConnection
    : public dataplex_v1::CatalogServiceConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateEntryType(Matcher<google::cloud::dataplex::v1::CreateEntryTypeRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::dataplex::v1::EntryType>>, CreateEntryType,
      (google::cloud::dataplex::v1::CreateEntryTypeRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateEntryType(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateEntryType,
      (NoAwaitTag,
       google::cloud::dataplex::v1::CreateEntryTypeRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateEntryType(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::dataplex::v1::EntryType>>,
              CreateEntryType,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateEntryType(Matcher<google::cloud::dataplex::v1::UpdateEntryTypeRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::dataplex::v1::EntryType>>, UpdateEntryType,
      (google::cloud::dataplex::v1::UpdateEntryTypeRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateEntryType(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateEntryType,
      (NoAwaitTag,
       google::cloud::dataplex::v1::UpdateEntryTypeRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateEntryType(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::dataplex::v1::EntryType>>,
              UpdateEntryType,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteEntryType(Matcher<google::cloud::dataplex::v1::DeleteEntryTypeRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>,
      DeleteEntryType,
      (google::cloud::dataplex::v1::DeleteEntryTypeRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteEntryType(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteEntryType,
      (NoAwaitTag,
       google::cloud::dataplex::v1::DeleteEntryTypeRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteEntryType(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>,
              DeleteEntryType,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD((StreamRange<google::cloud::dataplex::v1::EntryType>),
              ListEntryTypes,
              (google::cloud::dataplex::v1::ListEntryTypesRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::dataplex::v1::EntryType>, GetEntryType,
              (google::cloud::dataplex::v1::GetEntryTypeRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateAspectType(Matcher<google::cloud::dataplex::v1::CreateAspectTypeRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::dataplex::v1::AspectType>>,
      CreateAspectType,
      (google::cloud::dataplex::v1::CreateAspectTypeRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateAspectType(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateAspectType,
      (NoAwaitTag,
       google::cloud::dataplex::v1::CreateAspectTypeRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateAspectType(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::dataplex::v1::AspectType>>,
              CreateAspectType,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateAspectType(Matcher<google::cloud::dataplex::v1::UpdateAspectTypeRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::dataplex::v1::AspectType>>,
      UpdateAspectType,
      (google::cloud::dataplex::v1::UpdateAspectTypeRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateAspectType(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateAspectType,
      (NoAwaitTag,
       google::cloud::dataplex::v1::UpdateAspectTypeRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateAspectType(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::dataplex::v1::AspectType>>,
              UpdateAspectType,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteAspectType(Matcher<google::cloud::dataplex::v1::DeleteAspectTypeRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>,
      DeleteAspectType,
      (google::cloud::dataplex::v1::DeleteAspectTypeRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteAspectType(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteAspectType,
      (NoAwaitTag,
       google::cloud::dataplex::v1::DeleteAspectTypeRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteAspectType(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>,
              DeleteAspectType,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD((StreamRange<google::cloud::dataplex::v1::AspectType>),
              ListAspectTypes,
              (google::cloud::dataplex::v1::ListAspectTypesRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::dataplex::v1::AspectType>, GetAspectType,
      (google::cloud::dataplex::v1::GetAspectTypeRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateEntryGroup(Matcher<google::cloud::dataplex::v1::CreateEntryGroupRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>,
      CreateEntryGroup,
      (google::cloud::dataplex::v1::CreateEntryGroupRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateEntryGroup(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateEntryGroup,
      (NoAwaitTag,
       google::cloud::dataplex::v1::CreateEntryGroupRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateEntryGroup(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>,
              CreateEntryGroup,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateEntryGroup(Matcher<google::cloud::dataplex::v1::UpdateEntryGroupRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>,
      UpdateEntryGroup,
      (google::cloud::dataplex::v1::UpdateEntryGroupRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateEntryGroup(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateEntryGroup,
      (NoAwaitTag,
       google::cloud::dataplex::v1::UpdateEntryGroupRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateEntryGroup(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>,
              UpdateEntryGroup,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteEntryGroup(Matcher<google::cloud::dataplex::v1::DeleteEntryGroupRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>,
      DeleteEntryGroup,
      (google::cloud::dataplex::v1::DeleteEntryGroupRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteEntryGroup(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteEntryGroup,
      (NoAwaitTag,
       google::cloud::dataplex::v1::DeleteEntryGroupRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteEntryGroup(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>,
              DeleteEntryGroup,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD((StreamRange<google::cloud::dataplex::v1::EntryGroup>),
              ListEntryGroups,
              (google::cloud::dataplex::v1::ListEntryGroupsRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::dataplex::v1::EntryGroup>, GetEntryGroup,
      (google::cloud::dataplex::v1::GetEntryGroupRequest const& request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::dataplex::v1::Entry>, CreateEntry,
              (google::cloud::dataplex::v1::CreateEntryRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::dataplex::v1::Entry>, UpdateEntry,
              (google::cloud::dataplex::v1::UpdateEntryRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::dataplex::v1::Entry>, DeleteEntry,
              (google::cloud::dataplex::v1::DeleteEntryRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::dataplex::v1::Entry>), ListEntries,
              (google::cloud::dataplex::v1::ListEntriesRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::dataplex::v1::Entry>, GetEntry,
              (google::cloud::dataplex::v1::GetEntryRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::dataplex::v1::Entry>, LookupEntry,
              (google::cloud::dataplex::v1::LookupEntryRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::dataplex::v1::SearchEntriesResult>),
              SearchEntries,
              (google::cloud::dataplex::v1::SearchEntriesRequest request),
              (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_MOCKS_MOCK_CATALOG_CONNECTION_H
