// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/autoscaling_policies.proto

#include "google/cloud/dataproc/v1/internal/autoscaling_policy_connection_impl.h"
#include "google/cloud/dataproc/v1/internal/autoscaling_policy_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataproc_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<dataproc_v1::AutoscalingPolicyServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<dataproc_v1::AutoscalingPolicyServiceRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<dataproc_v1::AutoscalingPolicyServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<
    dataproc_v1::AutoscalingPolicyServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<dataproc_v1::
               AutoscalingPolicyServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

AutoscalingPolicyServiceConnectionImpl::AutoscalingPolicyServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<dataproc_v1_internal::AutoscalingPolicyServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), AutoscalingPolicyServiceConnection::options())) {}

StatusOr<google::cloud::dataproc::v1::AutoscalingPolicy>
AutoscalingPolicyServiceConnectionImpl::CreateAutoscalingPolicy(
    google::cloud::dataproc::v1::CreateAutoscalingPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateAutoscalingPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataproc::v1::CreateAutoscalingPolicyRequest const&
                 request) {
        return stub_->CreateAutoscalingPolicy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::dataproc::v1::AutoscalingPolicy>
AutoscalingPolicyServiceConnectionImpl::UpdateAutoscalingPolicy(
    google::cloud::dataproc::v1::UpdateAutoscalingPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateAutoscalingPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataproc::v1::UpdateAutoscalingPolicyRequest const&
                 request) {
        return stub_->UpdateAutoscalingPolicy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::dataproc::v1::AutoscalingPolicy>
AutoscalingPolicyServiceConnectionImpl::GetAutoscalingPolicy(
    google::cloud::dataproc::v1::GetAutoscalingPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetAutoscalingPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataproc::v1::GetAutoscalingPolicyRequest const&
                 request) {
        return stub_->GetAutoscalingPolicy(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::dataproc::v1::AutoscalingPolicy>
AutoscalingPolicyServiceConnectionImpl::ListAutoscalingPolicies(
    google::cloud::dataproc::v1::ListAutoscalingPoliciesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListAutoscalingPolicies(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataproc::v1::AutoscalingPolicy>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<dataproc_v1::AutoscalingPolicyServiceRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::dataproc::v1::ListAutoscalingPoliciesRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::dataproc::v1::
                       ListAutoscalingPoliciesRequest const& request) {
              return stub->ListAutoscalingPolicies(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::dataproc::v1::ListAutoscalingPoliciesResponse r) {
        std::vector<google::cloud::dataproc::v1::AutoscalingPolicy> result(
            r.policies().size());
        auto& messages = *r.mutable_policies();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status AutoscalingPolicyServiceConnectionImpl::DeleteAutoscalingPolicy(
    google::cloud::dataproc::v1::DeleteAutoscalingPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteAutoscalingPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataproc::v1::DeleteAutoscalingPolicyRequest const&
                 request) {
        return stub_->DeleteAutoscalingPolicy(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1_internal
}  // namespace cloud
}  // namespace google
