// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/session_templates.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPROC_V1_INTERNAL_SESSION_TEMPLATE_CONTROLLER_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPROC_V1_INTERNAL_SESSION_TEMPLATE_CONTROLLER_TRACING_CONNECTION_H

#include "google/cloud/dataproc/v1/session_template_controller_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataproc_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class SessionTemplateControllerTracingConnection
    : public dataproc_v1::SessionTemplateControllerConnection {
 public:
  ~SessionTemplateControllerTracingConnection() override = default;

  explicit SessionTemplateControllerTracingConnection(
      std::shared_ptr<dataproc_v1::SessionTemplateControllerConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::dataproc::v1::SessionTemplate> CreateSessionTemplate(
      google::cloud::dataproc::v1::CreateSessionTemplateRequest const& request)
      override;

  StatusOr<google::cloud::dataproc::v1::SessionTemplate> UpdateSessionTemplate(
      google::cloud::dataproc::v1::UpdateSessionTemplateRequest const& request)
      override;

  StatusOr<google::cloud::dataproc::v1::SessionTemplate> GetSessionTemplate(
      google::cloud::dataproc::v1::GetSessionTemplateRequest const& request)
      override;

  StreamRange<google::cloud::dataproc::v1::SessionTemplate>
  ListSessionTemplates(google::cloud::dataproc::v1::ListSessionTemplatesRequest
                           request) override;

  Status DeleteSessionTemplate(
      google::cloud::dataproc::v1::DeleteSessionTemplateRequest const& request)
      override;

 private:
  std::shared_ptr<dataproc_v1::SessionTemplateControllerConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<dataproc_v1::SessionTemplateControllerConnection>
MakeSessionTemplateControllerTracingConnection(
    std::shared_ptr<dataproc_v1::SessionTemplateControllerConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPROC_V1_INTERNAL_SESSION_TEMPLATE_CONTROLLER_TRACING_CONNECTION_H
