// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/sessions.proto

#include "google/cloud/dataproc/v1/session_controller_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataproc_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SessionControllerClient::SessionControllerClient(
    std::shared_ptr<SessionControllerConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
SessionControllerClient::~SessionControllerClient() = default;

future<StatusOr<google::cloud::dataproc::v1::Session>>
SessionControllerClient::CreateSession(
    std::string const& parent,
    google::cloud::dataproc::v1::Session const& session,
    std::string const& session_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataproc::v1::CreateSessionRequest request;
  request.set_parent(parent);
  *request.mutable_session() = session;
  request.set_session_id(session_id);
  return connection_->CreateSession(request);
}

StatusOr<google::longrunning::Operation> SessionControllerClient::CreateSession(
    NoAwaitTag, std::string const& parent,
    google::cloud::dataproc::v1::Session const& session,
    std::string const& session_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataproc::v1::CreateSessionRequest request;
  request.set_parent(parent);
  *request.mutable_session() = session;
  request.set_session_id(session_id);
  return connection_->CreateSession(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataproc::v1::Session>>
SessionControllerClient::CreateSession(
    google::cloud::dataproc::v1::CreateSessionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSession(request);
}

StatusOr<google::longrunning::Operation> SessionControllerClient::CreateSession(
    NoAwaitTag,
    google::cloud::dataproc::v1::CreateSessionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSession(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataproc::v1::Session>>
SessionControllerClient::CreateSession(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSession(operation);
}

StatusOr<google::cloud::dataproc::v1::Session>
SessionControllerClient::GetSession(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataproc::v1::GetSessionRequest request;
  request.set_name(name);
  return connection_->GetSession(request);
}

StatusOr<google::cloud::dataproc::v1::Session>
SessionControllerClient::GetSession(
    google::cloud::dataproc::v1::GetSessionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSession(request);
}

StreamRange<google::cloud::dataproc::v1::Session>
SessionControllerClient::ListSessions(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataproc::v1::ListSessionsRequest request;
  request.set_parent(parent);
  return connection_->ListSessions(request);
}

StreamRange<google::cloud::dataproc::v1::Session>
SessionControllerClient::ListSessions(
    google::cloud::dataproc::v1::ListSessionsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSessions(std::move(request));
}

future<StatusOr<google::cloud::dataproc::v1::Session>>
SessionControllerClient::TerminateSession(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataproc::v1::TerminateSessionRequest request;
  request.set_name(name);
  return connection_->TerminateSession(request);
}

StatusOr<google::longrunning::Operation>
SessionControllerClient::TerminateSession(NoAwaitTag, std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataproc::v1::TerminateSessionRequest request;
  request.set_name(name);
  return connection_->TerminateSession(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataproc::v1::Session>>
SessionControllerClient::TerminateSession(
    google::cloud::dataproc::v1::TerminateSessionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TerminateSession(request);
}

StatusOr<google::longrunning::Operation>
SessionControllerClient::TerminateSession(
    NoAwaitTag,
    google::cloud::dataproc::v1::TerminateSessionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TerminateSession(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataproc::v1::Session>>
SessionControllerClient::TerminateSession(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TerminateSession(operation);
}

future<StatusOr<google::cloud::dataproc::v1::Session>>
SessionControllerClient::DeleteSession(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataproc::v1::DeleteSessionRequest request;
  request.set_name(name);
  return connection_->DeleteSession(request);
}

StatusOr<google::longrunning::Operation> SessionControllerClient::DeleteSession(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataproc::v1::DeleteSessionRequest request;
  request.set_name(name);
  return connection_->DeleteSession(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataproc::v1::Session>>
SessionControllerClient::DeleteSession(
    google::cloud::dataproc::v1::DeleteSessionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSession(request);
}

StatusOr<google::longrunning::Operation> SessionControllerClient::DeleteSession(
    NoAwaitTag,
    google::cloud::dataproc::v1::DeleteSessionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSession(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataproc::v1::Session>>
SessionControllerClient::DeleteSession(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSession(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1
}  // namespace cloud
}  // namespace google
