// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/control_service.proto

#include "google/cloud/discoveryengine/v1/control_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ControlServiceConnectionIdempotencyPolicy::
    ~ControlServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<ControlServiceConnectionIdempotencyPolicy>
ControlServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<ControlServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency ControlServiceConnectionIdempotencyPolicy::CreateControl(
    google::cloud::discoveryengine::v1::CreateControlRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ControlServiceConnectionIdempotencyPolicy::DeleteControl(
    google::cloud::discoveryengine::v1::DeleteControlRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ControlServiceConnectionIdempotencyPolicy::UpdateControl(
    google::cloud::discoveryengine::v1::UpdateControlRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ControlServiceConnectionIdempotencyPolicy::GetControl(
    google::cloud::discoveryengine::v1::GetControlRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ControlServiceConnectionIdempotencyPolicy::ListControls(
    google::cloud::discoveryengine::v1::ListControlsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

std::unique_ptr<ControlServiceConnectionIdempotencyPolicy>
MakeDefaultControlServiceConnectionIdempotencyPolicy() {
  return std::make_unique<ControlServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google
