// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/site_search_engine_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_SITE_SEARCH_ENGINE_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_SITE_SEARCH_ENGINE_CLIENT_H

#include "google/cloud/discoveryengine/v1/site_search_engine_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service for managing site search related resources.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class SiteSearchEngineServiceClient {
 public:
  explicit SiteSearchEngineServiceClient(
      std::shared_ptr<SiteSearchEngineServiceConnection> connection,
      Options opts = {});
  ~SiteSearchEngineServiceClient();

  ///@{
  /// @name Copy and move support
  SiteSearchEngineServiceClient(SiteSearchEngineServiceClient const&) = default;
  SiteSearchEngineServiceClient& operator=(
      SiteSearchEngineServiceClient const&) = default;
  SiteSearchEngineServiceClient(SiteSearchEngineServiceClient&&) = default;
  SiteSearchEngineServiceClient& operator=(SiteSearchEngineServiceClient&&) =
      default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(SiteSearchEngineServiceClient const& a,
                         SiteSearchEngineServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(SiteSearchEngineServiceClient const& a,
                         SiteSearchEngineServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Gets the
  /// [SiteSearchEngine][google.cloud.discoveryengine.v1.SiteSearchEngine].
  ///
  /// @param name  Required. Resource name of
  ///  [SiteSearchEngine][google.cloud.discoveryengine.v1.SiteSearchEngine], such
  ///  as
  ///  `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`.
  ///  @n
  ///  If the caller does not have permission to access the [SiteSearchEngine],
  ///  regardless of whether or not it exists, a PERMISSION_DENIED error is
  ///  returned.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.discoveryengine.v1.SiteSearchEngine])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.GetSiteSearchEngineRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L228}
  /// [google.cloud.discoveryengine.v1.SiteSearchEngine]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine.proto#L34}
  ///
  // clang-format on
  StatusOr<google::cloud::discoveryengine::v1::SiteSearchEngine>
  GetSiteSearchEngine(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the
  /// [SiteSearchEngine][google.cloud.discoveryengine.v1.SiteSearchEngine].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.GetSiteSearchEngineRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.discoveryengine.v1.SiteSearchEngine])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.GetSiteSearchEngineRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L228}
  /// [google.cloud.discoveryengine.v1.SiteSearchEngine]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine.proto#L34}
  ///
  // clang-format on
  StatusOr<google::cloud::discoveryengine::v1::SiteSearchEngine>
  GetSiteSearchEngine(
      google::cloud::discoveryengine::v1::GetSiteSearchEngineRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a [TargetSite][google.cloud.discoveryengine.v1.TargetSite].
  ///
  /// @param parent  Required. Parent resource name of
  ///  [TargetSite][google.cloud.discoveryengine.v1.TargetSite], such as
  ///  `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`.
  /// @param target_site  Required. The [TargetSite][google.cloud.discoveryengine.v1.TargetSite] to
  ///  create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.discoveryengine.v1.TargetSite] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.CreateTargetSiteRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L248}
  /// [google.cloud.discoveryengine.v1.TargetSite]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine.proto#L47}
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
  CreateTargetSite(
      std::string const& parent,
      google::cloud::discoveryengine::v1::TargetSite const& target_site,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateTargetSite
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateTargetSite(
      NoAwaitTag, std::string const& parent,
      google::cloud::discoveryengine::v1::TargetSite const& target_site,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a [TargetSite][google.cloud.discoveryengine.v1.TargetSite].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.CreateTargetSiteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.discoveryengine.v1.TargetSite] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.CreateTargetSiteRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L248}
  /// [google.cloud.discoveryengine.v1.TargetSite]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine.proto#L47}
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
  CreateTargetSite(
      google::cloud::discoveryengine::v1::CreateTargetSiteRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateTargetSite
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateTargetSite(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::CreateTargetSiteRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateTargetSite
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
  CreateTargetSite(google::longrunning::Operation const& operation,
                   Options opts = {});

  // clang-format off
  ///
  /// Creates [TargetSite][google.cloud.discoveryengine.v1.TargetSite] in a
  /// batch.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.BatchCreateTargetSitesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.discoveryengine.v1.BatchCreateTargetSitesResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.BatchCreateTargetSitesRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L280}
  /// [google.cloud.discoveryengine.v1.BatchCreateTargetSitesResponse]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L447}
  /// [google.cloud.discoveryengine.v1.TargetSite]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine.proto#L47}
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::discoveryengine::v1::BatchCreateTargetSitesResponse>>
  BatchCreateTargetSites(
      google::cloud::discoveryengine::v1::BatchCreateTargetSitesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchCreateTargetSites
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> BatchCreateTargetSites(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::BatchCreateTargetSitesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchCreateTargetSites
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::discoveryengine::v1::BatchCreateTargetSitesResponse>>
  BatchCreateTargetSites(google::longrunning::Operation const& operation,
                         Options opts = {});

  // clang-format off
  ///
  /// Gets a [TargetSite][google.cloud.discoveryengine.v1.TargetSite].
  ///
  /// @param name  Required. Full resource name of
  ///  [TargetSite][google.cloud.discoveryengine.v1.TargetSite], such as
  ///  `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}`.
  ///  @n
  ///  If the caller does not have permission to access the
  ///  [TargetSite][google.cloud.discoveryengine.v1.TargetSite], regardless of
  ///  whether or not it exists, a PERMISSION_DENIED error is returned.
  ///  @n
  ///  If the requested [TargetSite][google.cloud.discoveryengine.v1.TargetSite]
  ///  does not exist, a NOT_FOUND error is returned.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.discoveryengine.v1.TargetSite])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.GetTargetSiteRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L301}
  /// [google.cloud.discoveryengine.v1.TargetSite]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine.proto#L47}
  ///
  // clang-format on
  StatusOr<google::cloud::discoveryengine::v1::TargetSite> GetTargetSite(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a [TargetSite][google.cloud.discoveryengine.v1.TargetSite].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.GetTargetSiteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.discoveryengine.v1.TargetSite])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.GetTargetSiteRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L301}
  /// [google.cloud.discoveryengine.v1.TargetSite]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine.proto#L47}
  ///
  // clang-format on
  StatusOr<google::cloud::discoveryengine::v1::TargetSite> GetTargetSite(
      google::cloud::discoveryengine::v1::GetTargetSiteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a [TargetSite][google.cloud.discoveryengine.v1.TargetSite].
  ///
  /// @param target_site  Required. The target site to update.
  ///  If the caller does not have permission to update the
  ///  [TargetSite][google.cloud.discoveryengine.v1.TargetSite], regardless of
  ///  whether or not it exists, a PERMISSION_DENIED error is returned.
  ///  @n
  ///  If the [TargetSite][google.cloud.discoveryengine.v1.TargetSite] to update
  ///  does not exist, a NOT_FOUND error is returned.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.discoveryengine.v1.TargetSite] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.TargetSite]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine.proto#L47}
  /// [google.cloud.discoveryengine.v1.UpdateTargetSiteRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L323}
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
  UpdateTargetSite(
      google::cloud::discoveryengine::v1::TargetSite const& target_site,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateTargetSite
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateTargetSite(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::TargetSite const& target_site,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a [TargetSite][google.cloud.discoveryengine.v1.TargetSite].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.UpdateTargetSiteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.discoveryengine.v1.TargetSite] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.TargetSite]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine.proto#L47}
  /// [google.cloud.discoveryengine.v1.UpdateTargetSiteRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L323}
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
  UpdateTargetSite(
      google::cloud::discoveryengine::v1::UpdateTargetSiteRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateTargetSite
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateTargetSite(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::UpdateTargetSiteRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateTargetSite
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
  UpdateTargetSite(google::longrunning::Operation const& operation,
                   Options opts = {});

  // clang-format off
  ///
  /// Deletes a [TargetSite][google.cloud.discoveryengine.v1.TargetSite].
  ///
  /// @param name  Required. Full resource name of
  ///  [TargetSite][google.cloud.discoveryengine.v1.TargetSite], such as
  ///  `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}`.
  ///  @n
  ///  If the caller does not have permission to access the
  ///  [TargetSite][google.cloud.discoveryengine.v1.TargetSite], regardless of
  ///  whether or not it exists, a PERMISSION_DENIED error is returned.
  ///  @n
  ///  If the requested [TargetSite][google.cloud.discoveryengine.v1.TargetSite]
  ///  does not exist, a NOT_FOUND error is returned.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.discoveryengine.v1.DeleteTargetSiteMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.DeleteTargetSiteMetadata]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L373}
  /// [google.cloud.discoveryengine.v1.DeleteTargetSiteRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L350}
  /// [google.cloud.discoveryengine.v1.TargetSite]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine.proto#L47}
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::DeleteTargetSiteMetadata>>
  DeleteTargetSite(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTargetSite
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteTargetSite(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a [TargetSite][google.cloud.discoveryengine.v1.TargetSite].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.DeleteTargetSiteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.discoveryengine.v1.DeleteTargetSiteMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.DeleteTargetSiteMetadata]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L373}
  /// [google.cloud.discoveryengine.v1.DeleteTargetSiteRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L350}
  /// [google.cloud.discoveryengine.v1.TargetSite]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine.proto#L47}
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::DeleteTargetSiteMetadata>>
  DeleteTargetSite(
      google::cloud::discoveryengine::v1::DeleteTargetSiteRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTargetSite
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteTargetSite(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::DeleteTargetSiteRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTargetSite
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::DeleteTargetSiteMetadata>>
  DeleteTargetSite(google::longrunning::Operation const& operation,
                   Options opts = {});

  // clang-format off
  ///
  /// Gets a list of [TargetSite][google.cloud.discoveryengine.v1.TargetSite]s.
  ///
  /// @param parent  Required. The parent site search engine resource name, such as
  ///  `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`.
  ///  @n
  ///  If the caller does not have permission to list
  ///  [TargetSite][google.cloud.discoveryengine.v1.TargetSite]s under this site
  ///  search engine, regardless of whether or not this branch exists, a
  ///  PERMISSION_DENIED error is returned.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.discoveryengine.v1.TargetSite], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.ListTargetSitesRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L385}
  /// [google.cloud.discoveryengine.v1.TargetSite]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine.proto#L47}
  ///
  // clang-format on
  StreamRange<google::cloud::discoveryengine::v1::TargetSite> ListTargetSites(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Gets a list of [TargetSite][google.cloud.discoveryengine.v1.TargetSite]s.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.ListTargetSitesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.discoveryengine.v1.TargetSite], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.ListTargetSitesRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L385}
  /// [google.cloud.discoveryengine.v1.TargetSite]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine.proto#L47}
  ///
  // clang-format on
  StreamRange<google::cloud::discoveryengine::v1::TargetSite> ListTargetSites(
      google::cloud::discoveryengine::v1::ListTargetSitesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Upgrade from basic site search to advanced site search.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.EnableAdvancedSiteSearchRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.discoveryengine.v1.EnableAdvancedSiteSearchResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.EnableAdvancedSiteSearchRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L455}
  /// [google.cloud.discoveryengine.v1.EnableAdvancedSiteSearchResponse]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L471}
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchResponse>>
  EnableAdvancedSiteSearch(
      google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief EnableAdvancedSiteSearch
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> EnableAdvancedSiteSearch(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief EnableAdvancedSiteSearch
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchResponse>>
  EnableAdvancedSiteSearch(google::longrunning::Operation const& operation,
                           Options opts = {});

  // clang-format off
  ///
  /// Downgrade from advanced site search to basic site search.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.DisableAdvancedSiteSearchRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.discoveryengine.v1.DisableAdvancedSiteSearchResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.DisableAdvancedSiteSearchRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L489}
  /// [google.cloud.discoveryengine.v1.DisableAdvancedSiteSearchResponse]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L505}
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchResponse>>
  DisableAdvancedSiteSearch(google::cloud::discoveryengine::v1::
                                DisableAdvancedSiteSearchRequest const& request,
                            Options opts = {});

  // clang-format off
  ///
  /// @copybrief DisableAdvancedSiteSearch
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DisableAdvancedSiteSearch(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::
          DisableAdvancedSiteSearchRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DisableAdvancedSiteSearch
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchResponse>>
  DisableAdvancedSiteSearch(google::longrunning::Operation const& operation,
                            Options opts = {});

  // clang-format off
  ///
  /// Request on-demand recrawl for a list of URIs.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.RecrawlUrisRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.discoveryengine.v1.RecrawlUrisResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.RecrawlUrisRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L523}
  /// [google.cloud.discoveryengine.v1.RecrawlUrisResponse]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L544}
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::RecrawlUrisResponse>>
  RecrawlUris(
      google::cloud::discoveryengine::v1::RecrawlUrisRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RecrawlUris
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RecrawlUris(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::RecrawlUrisRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RecrawlUris
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::discoveryengine::v1::RecrawlUrisResponse>>
  RecrawlUris(google::longrunning::Operation const& operation,
              Options opts = {});

  // clang-format off
  ///
  /// Verify target sites' ownership and validity.
  /// This API sends all the target sites under site search engine for
  /// verification.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.BatchVerifyTargetSitesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.discoveryengine.v1.BatchVerifyTargetSitesResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.BatchVerifyTargetSitesRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L618}
  /// [google.cloud.discoveryengine.v1.BatchVerifyTargetSitesResponse]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L632}
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::discoveryengine::v1::BatchVerifyTargetSitesResponse>>
  BatchVerifyTargetSites(
      google::cloud::discoveryengine::v1::BatchVerifyTargetSitesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchVerifyTargetSites
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> BatchVerifyTargetSites(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::BatchVerifyTargetSitesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchVerifyTargetSites
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::discoveryengine::v1::BatchVerifyTargetSitesResponse>>
  BatchVerifyTargetSites(google::longrunning::Operation const& operation,
                         Options opts = {});

  // clang-format off
  ///
  /// Returns list of target sites with its domain verification status.
  /// This method can only be called under data store with BASIC_SITE_SEARCH
  /// state at the moment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.FetchDomainVerificationStatusRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.discoveryengine.v1.TargetSite], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.FetchDomainVerificationStatusRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine_service.proto#L650}
  /// [google.cloud.discoveryengine.v1.TargetSite]: @googleapis_reference_link{google/cloud/discoveryengine/v1/site_search_engine.proto#L47}
  ///
  // clang-format on
  StreamRange<google::cloud::discoveryengine::v1::TargetSite>
  FetchDomainVerificationStatus(
      google::cloud::discoveryengine::v1::FetchDomainVerificationStatusRequest
          request,
      Options opts = {});

 private:
  std::shared_ptr<SiteSearchEngineServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_SITE_SEARCH_ENGINE_CLIENT_H
