// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/iam/admin/v1/iam.proto

#include "google/cloud/iam/admin/v1/internal/iam_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/iam/admin/v1/iam.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace iam_admin_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

IAMMetadata::IAMMetadata(std::shared_ptr<IAMStub> child,
                         std::multimap<std::string, std::string> fixed_metadata,
                         std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::iam::admin::v1::ListServiceAccountsResponse>
IAMMetadata::ListServiceAccounts(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::ListServiceAccountsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ListServiceAccounts(context, options, request);
}

StatusOr<google::iam::admin::v1::ServiceAccount> IAMMetadata::GetServiceAccount(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::GetServiceAccountRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetServiceAccount(context, options, request);
}

StatusOr<google::iam::admin::v1::ServiceAccount>
IAMMetadata::CreateServiceAccount(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::CreateServiceAccountRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->CreateServiceAccount(context, options, request);
}

StatusOr<google::iam::admin::v1::ServiceAccount>
IAMMetadata::PatchServiceAccount(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::PatchServiceAccountRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("service_account.name=",
                   internal::UrlEncode(request.service_account().name())));
  return child_->PatchServiceAccount(context, options, request);
}

Status IAMMetadata::DeleteServiceAccount(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::DeleteServiceAccountRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteServiceAccount(context, options, request);
}

StatusOr<google::iam::admin::v1::UndeleteServiceAccountResponse>
IAMMetadata::UndeleteServiceAccount(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::UndeleteServiceAccountRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->UndeleteServiceAccount(context, options, request);
}

Status IAMMetadata::EnableServiceAccount(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::EnableServiceAccountRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->EnableServiceAccount(context, options, request);
}

Status IAMMetadata::DisableServiceAccount(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::DisableServiceAccountRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DisableServiceAccount(context, options, request);
}

StatusOr<google::iam::admin::v1::ListServiceAccountKeysResponse>
IAMMetadata::ListServiceAccountKeys(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::ListServiceAccountKeysRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ListServiceAccountKeys(context, options, request);
}

StatusOr<google::iam::admin::v1::ServiceAccountKey>
IAMMetadata::GetServiceAccountKey(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::GetServiceAccountKeyRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetServiceAccountKey(context, options, request);
}

StatusOr<google::iam::admin::v1::ServiceAccountKey>
IAMMetadata::CreateServiceAccountKey(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::CreateServiceAccountKeyRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->CreateServiceAccountKey(context, options, request);
}

StatusOr<google::iam::admin::v1::ServiceAccountKey>
IAMMetadata::UploadServiceAccountKey(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::UploadServiceAccountKeyRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->UploadServiceAccountKey(context, options, request);
}

Status IAMMetadata::DeleteServiceAccountKey(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::DeleteServiceAccountKeyRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteServiceAccountKey(context, options, request);
}

Status IAMMetadata::DisableServiceAccountKey(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::DisableServiceAccountKeyRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DisableServiceAccountKey(context, options, request);
}

Status IAMMetadata::EnableServiceAccountKey(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::EnableServiceAccountKeyRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->EnableServiceAccountKey(context, options, request);
}

StatusOr<google::iam::v1::Policy> IAMMetadata::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->GetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::Policy> IAMMetadata::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->SetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
IAMMetadata::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->TestIamPermissions(context, options, request);
}

StatusOr<google::iam::admin::v1::QueryGrantableRolesResponse>
IAMMetadata::QueryGrantableRoles(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::QueryGrantableRolesRequest const& request) {
  SetMetadata(context, options);
  return child_->QueryGrantableRoles(context, options, request);
}

StatusOr<google::iam::admin::v1::ListRolesResponse> IAMMetadata::ListRoles(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::ListRolesRequest const& request) {
  SetMetadata(context, options);
  return child_->ListRoles(context, options, request);
}

StatusOr<google::iam::admin::v1::Role> IAMMetadata::GetRole(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::GetRoleRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetRole(context, options, request);
}

StatusOr<google::iam::admin::v1::Role> IAMMetadata::CreateRole(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::CreateRoleRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateRole(context, options, request);
}

StatusOr<google::iam::admin::v1::Role> IAMMetadata::UpdateRole(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::UpdateRoleRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->UpdateRole(context, options, request);
}

StatusOr<google::iam::admin::v1::Role> IAMMetadata::DeleteRole(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::DeleteRoleRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteRole(context, options, request);
}

StatusOr<google::iam::admin::v1::Role> IAMMetadata::UndeleteRole(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::UndeleteRoleRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->UndeleteRole(context, options, request);
}

StatusOr<google::iam::admin::v1::QueryTestablePermissionsResponse>
IAMMetadata::QueryTestablePermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::QueryTestablePermissionsRequest const& request) {
  SetMetadata(context, options);
  return child_->QueryTestablePermissions(context, options, request);
}

StatusOr<google::iam::admin::v1::QueryAuditableServicesResponse>
IAMMetadata::QueryAuditableServices(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::QueryAuditableServicesRequest const& request) {
  SetMetadata(context, options);
  return child_->QueryAuditableServices(context, options, request);
}

StatusOr<google::iam::admin::v1::LintPolicyResponse> IAMMetadata::LintPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::admin::v1::LintPolicyRequest const& request) {
  SetMetadata(context, options);
  return child_->LintPolicy(context, options, request);
}

void IAMMetadata::SetMetadata(grpc::ClientContext& context,
                              Options const& options,
                              std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void IAMMetadata::SetMetadata(grpc::ClientContext& context,
                              Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iam_admin_v1_internal
}  // namespace cloud
}  // namespace google
