// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/kms/v1/ekm_service.proto

#include "google/cloud/kms/v1/ekm_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace kms_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EkmServiceClient::EkmServiceClient(
    std::shared_ptr<EkmServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
EkmServiceClient::~EkmServiceClient() = default;

StreamRange<google::cloud::kms::v1::EkmConnection>
EkmServiceClient::ListEkmConnections(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::kms::v1::ListEkmConnectionsRequest request;
  request.set_parent(parent);
  return connection_->ListEkmConnections(request);
}

StreamRange<google::cloud::kms::v1::EkmConnection>
EkmServiceClient::ListEkmConnections(
    google::cloud::kms::v1::ListEkmConnectionsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListEkmConnections(std::move(request));
}

StatusOr<google::cloud::kms::v1::EkmConnection>
EkmServiceClient::GetEkmConnection(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::kms::v1::GetEkmConnectionRequest request;
  request.set_name(name);
  return connection_->GetEkmConnection(request);
}

StatusOr<google::cloud::kms::v1::EkmConnection>
EkmServiceClient::GetEkmConnection(
    google::cloud::kms::v1::GetEkmConnectionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEkmConnection(request);
}

StatusOr<google::cloud::kms::v1::EkmConnection>
EkmServiceClient::CreateEkmConnection(
    std::string const& parent, std::string const& ekm_connection_id,
    google::cloud::kms::v1::EkmConnection const& ekm_connection, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::kms::v1::CreateEkmConnectionRequest request;
  request.set_parent(parent);
  request.set_ekm_connection_id(ekm_connection_id);
  *request.mutable_ekm_connection() = ekm_connection;
  return connection_->CreateEkmConnection(request);
}

StatusOr<google::cloud::kms::v1::EkmConnection>
EkmServiceClient::CreateEkmConnection(
    google::cloud::kms::v1::CreateEkmConnectionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateEkmConnection(request);
}

StatusOr<google::cloud::kms::v1::EkmConnection>
EkmServiceClient::UpdateEkmConnection(
    google::cloud::kms::v1::EkmConnection const& ekm_connection,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::kms::v1::UpdateEkmConnectionRequest request;
  *request.mutable_ekm_connection() = ekm_connection;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateEkmConnection(request);
}

StatusOr<google::cloud::kms::v1::EkmConnection>
EkmServiceClient::UpdateEkmConnection(
    google::cloud::kms::v1::UpdateEkmConnectionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateEkmConnection(request);
}

StatusOr<google::cloud::kms::v1::EkmConfig> EkmServiceClient::GetEkmConfig(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::kms::v1::GetEkmConfigRequest request;
  request.set_name(name);
  return connection_->GetEkmConfig(request);
}

StatusOr<google::cloud::kms::v1::EkmConfig> EkmServiceClient::GetEkmConfig(
    google::cloud::kms::v1::GetEkmConfigRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEkmConfig(request);
}

StatusOr<google::cloud::kms::v1::EkmConfig> EkmServiceClient::UpdateEkmConfig(
    google::cloud::kms::v1::EkmConfig const& ekm_config,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::kms::v1::UpdateEkmConfigRequest request;
  *request.mutable_ekm_config() = ekm_config;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateEkmConfig(request);
}

StatusOr<google::cloud::kms::v1::EkmConfig> EkmServiceClient::UpdateEkmConfig(
    google::cloud::kms::v1::UpdateEkmConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateEkmConfig(request);
}

StatusOr<google::cloud::kms::v1::VerifyConnectivityResponse>
EkmServiceClient::VerifyConnectivity(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::kms::v1::VerifyConnectivityRequest request;
  request.set_name(name);
  return connection_->VerifyConnectivity(request);
}

StatusOr<google::cloud::kms::v1::VerifyConnectivityResponse>
EkmServiceClient::VerifyConnectivity(
    google::cloud::kms::v1::VerifyConnectivityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->VerifyConnectivity(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace kms_v1
}  // namespace cloud
}  // namespace google
