// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/kms/v1/autokey.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_KMS_V1_INTERNAL_AUTOKEY_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_KMS_V1_INTERNAL_AUTOKEY_TRACING_CONNECTION_H

#include "google/cloud/kms/v1/autokey_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace kms_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class AutokeyTracingConnection : public kms_v1::AutokeyConnection {
 public:
  ~AutokeyTracingConnection() override = default;

  explicit AutokeyTracingConnection(
      std::shared_ptr<kms_v1::AutokeyConnection> child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::kms::v1::KeyHandle>> CreateKeyHandle(
      google::cloud::kms::v1::CreateKeyHandleRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreateKeyHandle(
      NoAwaitTag,
      google::cloud::kms::v1::CreateKeyHandleRequest const& request) override;

  future<StatusOr<google::cloud::kms::v1::KeyHandle>> CreateKeyHandle(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::kms::v1::KeyHandle> GetKeyHandle(
      google::cloud::kms::v1::GetKeyHandleRequest const& request) override;

  StreamRange<google::cloud::kms::v1::KeyHandle> ListKeyHandles(
      google::cloud::kms::v1::ListKeyHandlesRequest request) override;

 private:
  std::shared_ptr<kms_v1::AutokeyConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<kms_v1::AutokeyConnection> MakeAutokeyTracingConnection(
    std::shared_ptr<kms_v1::AutokeyConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace kms_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_KMS_V1_INTERNAL_AUTOKEY_TRACING_CONNECTION_H
