// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/metricsscope/v1/metrics_scopes.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_METRICSSCOPE_V1_INTERNAL_METRICS_SCOPES_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_METRICSSCOPE_V1_INTERNAL_METRICS_SCOPES_TRACING_CONNECTION_H

#include "google/cloud/monitoring/metricsscope/v1/metrics_scopes_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_metricsscope_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class MetricsScopesTracingConnection
    : public monitoring_metricsscope_v1::MetricsScopesConnection {
 public:
  ~MetricsScopesTracingConnection() override = default;

  explicit MetricsScopesTracingConnection(
      std::shared_ptr<monitoring_metricsscope_v1::MetricsScopesConnection>
          child);

  Options options() override { return child_->options(); }

  StatusOr<google::monitoring::metricsscope::v1::MetricsScope> GetMetricsScope(
      google::monitoring::metricsscope::v1::GetMetricsScopeRequest const&
          request) override;

  StatusOr<google::monitoring::metricsscope::v1::
               ListMetricsScopesByMonitoredProjectResponse>
  ListMetricsScopesByMonitoredProject(
      google::monitoring::metricsscope::v1::
          ListMetricsScopesByMonitoredProjectRequest const& request) override;

  future<StatusOr<google::monitoring::metricsscope::v1::MonitoredProject>>
  CreateMonitoredProject(
      google::monitoring::metricsscope::v1::CreateMonitoredProjectRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateMonitoredProject(
      NoAwaitTag,
      google::monitoring::metricsscope::v1::CreateMonitoredProjectRequest const&
          request) override;

  future<StatusOr<google::monitoring::metricsscope::v1::MonitoredProject>>
  CreateMonitoredProject(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::monitoring::metricsscope::v1::OperationMetadata>>
  DeleteMonitoredProject(
      google::monitoring::metricsscope::v1::DeleteMonitoredProjectRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteMonitoredProject(
      NoAwaitTag,
      google::monitoring::metricsscope::v1::DeleteMonitoredProjectRequest const&
          request) override;

  future<StatusOr<google::monitoring::metricsscope::v1::OperationMetadata>>
  DeleteMonitoredProject(
      google::longrunning::Operation const& operation) override;

 private:
  std::shared_ptr<monitoring_metricsscope_v1::MetricsScopesConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<monitoring_metricsscope_v1::MetricsScopesConnection>
MakeMetricsScopesTracingConnection(
    std::shared_ptr<monitoring_metricsscope_v1::MetricsScopesConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_metricsscope_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_METRICSSCOPE_V1_INTERNAL_METRICS_SCOPES_TRACING_CONNECTION_H
