// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/video/livestream/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VIDEO_LIVESTREAM_V1_MOCKS_MOCK_LIVESTREAM_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VIDEO_LIVESTREAM_V1_MOCKS_MOCK_LIVESTREAM_CONNECTION_H

#include "google/cloud/video/livestream/v1/livestream_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace video_livestream_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `LivestreamServiceConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `LivestreamServiceClient`. To do so,
 * construct an object of type `LivestreamServiceClient` with an instance of
 * this class. Then use the Google Test framework functions to program the
 * behavior of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockLivestreamServiceConnection
    : public video_livestream_v1::LivestreamServiceConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateChannel(Matcher<google::cloud::video::livestream::v1::CreateChannelRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::video::livestream::v1::Channel>>,
              CreateChannel,
              (google::cloud::video::livestream::v1::CreateChannelRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateChannel(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, CreateChannel,
              (NoAwaitTag,
               google::cloud::video::livestream::v1::CreateChannelRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateChannel(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::video::livestream::v1::Channel>>,
              CreateChannel, (google::longrunning::Operation const& operation),
              (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::video::livestream::v1::Channel>),
      ListChannels,
      (google::cloud::video::livestream::v1::ListChannelsRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::video::livestream::v1::Channel>, GetChannel,
      (google::cloud::video::livestream::v1::GetChannelRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteChannel(Matcher<google::cloud::video::livestream::v1::DeleteChannelRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>,
      DeleteChannel,
      (google::cloud::video::livestream::v1::DeleteChannelRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteChannel(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, DeleteChannel,
              (NoAwaitTag,
               google::cloud::video::livestream::v1::DeleteChannelRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteChannel(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>,
      DeleteChannel, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateChannel(Matcher<google::cloud::video::livestream::v1::UpdateChannelRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::video::livestream::v1::Channel>>,
              UpdateChannel,
              (google::cloud::video::livestream::v1::UpdateChannelRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateChannel(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, UpdateChannel,
              (NoAwaitTag,
               google::cloud::video::livestream::v1::UpdateChannelRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateChannel(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::video::livestream::v1::Channel>>,
              UpdateChannel, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// StartChannel(Matcher<google::cloud::video::livestream::v1::StartChannelRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<
          google::cloud::video::livestream::v1::ChannelOperationResponse>>,
      StartChannel,
      (google::cloud::video::livestream::v1::StartChannelRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, StartChannel(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, StartChannel,
              (NoAwaitTag,
               google::cloud::video::livestream::v1::StartChannelRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, StartChannel(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<
          google::cloud::video::livestream::v1::ChannelOperationResponse>>,
      StartChannel, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// StopChannel(Matcher<google::cloud::video::livestream::v1::StopChannelRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<
          google::cloud::video::livestream::v1::ChannelOperationResponse>>,
      StopChannel,
      (google::cloud::video::livestream::v1::StopChannelRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, StopChannel(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, StopChannel,
      (NoAwaitTag,
       google::cloud::video::livestream::v1::StopChannelRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, StopChannel(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<
          google::cloud::video::livestream::v1::ChannelOperationResponse>>,
      StopChannel, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateInput(Matcher<google::cloud::video::livestream::v1::CreateInputRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::video::livestream::v1::Input>>,
      CreateInput,
      (google::cloud::video::livestream::v1::CreateInputRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateInput(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateInput,
      (NoAwaitTag,
       google::cloud::video::livestream::v1::CreateInputRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateInput(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::video::livestream::v1::Input>>,
              CreateInput, (google::longrunning::Operation const& operation),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::video::livestream::v1::Input>),
              ListInputs,
              (google::cloud::video::livestream::v1::ListInputsRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::video::livestream::v1::Input>, GetInput,
      (google::cloud::video::livestream::v1::GetInputRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteInput(Matcher<google::cloud::video::livestream::v1::DeleteInputRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>,
      DeleteInput,
      (google::cloud::video::livestream::v1::DeleteInputRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteInput(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteInput,
      (NoAwaitTag,
       google::cloud::video::livestream::v1::DeleteInputRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteInput(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>,
      DeleteInput, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateInput(Matcher<google::cloud::video::livestream::v1::UpdateInputRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::video::livestream::v1::Input>>,
      UpdateInput,
      (google::cloud::video::livestream::v1::UpdateInputRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateInput(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateInput,
      (NoAwaitTag,
       google::cloud::video::livestream::v1::UpdateInputRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateInput(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::video::livestream::v1::Input>>,
              UpdateInput, (google::longrunning::Operation const& operation),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::video::livestream::v1::Event>, CreateEvent,
      (google::cloud::video::livestream::v1::CreateEventRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::video::livestream::v1::Event>),
              ListEvents,
              (google::cloud::video::livestream::v1::ListEventsRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::video::livestream::v1::Event>, GetEvent,
      (google::cloud::video::livestream::v1::GetEventRequest const& request),
      (override));

  MOCK_METHOD(
      Status, DeleteEvent,
      (google::cloud::video::livestream::v1::DeleteEventRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::video::livestream::v1::Clip>),
              ListClips,
              (google::cloud::video::livestream::v1::ListClipsRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::video::livestream::v1::Clip>, GetClip,
      (google::cloud::video::livestream::v1::GetClipRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateClip(Matcher<google::cloud::video::livestream::v1::CreateClipRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::video::livestream::v1::Clip>>, CreateClip,
      (google::cloud::video::livestream::v1::CreateClipRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateClip(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateClip,
      (NoAwaitTag,
       google::cloud::video::livestream::v1::CreateClipRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateClip(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::video::livestream::v1::Clip>>,
              CreateClip, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteClip(Matcher<google::cloud::video::livestream::v1::DeleteClipRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>,
      DeleteClip,
      (google::cloud::video::livestream::v1::DeleteClipRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteClip(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteClip,
      (NoAwaitTag,
       google::cloud::video::livestream::v1::DeleteClipRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteClip(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>,
      DeleteClip, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateAsset(Matcher<google::cloud::video::livestream::v1::CreateAssetRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::video::livestream::v1::Asset>>,
      CreateAsset,
      (google::cloud::video::livestream::v1::CreateAssetRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateAsset(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateAsset,
      (NoAwaitTag,
       google::cloud::video::livestream::v1::CreateAssetRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateAsset(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::video::livestream::v1::Asset>>,
              CreateAsset, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteAsset(Matcher<google::cloud::video::livestream::v1::DeleteAssetRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>,
      DeleteAsset,
      (google::cloud::video::livestream::v1::DeleteAssetRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteAsset(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteAsset,
      (NoAwaitTag,
       google::cloud::video::livestream::v1::DeleteAssetRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteAsset(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>,
      DeleteAsset, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::video::livestream::v1::Asset>, GetAsset,
      (google::cloud::video::livestream::v1::GetAssetRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::video::livestream::v1::Asset>),
              ListAssets,
              (google::cloud::video::livestream::v1::ListAssetsRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::video::livestream::v1::Pool>, GetPool,
      (google::cloud::video::livestream::v1::GetPoolRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdatePool(Matcher<google::cloud::video::livestream::v1::UpdatePoolRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::video::livestream::v1::Pool>>, UpdatePool,
      (google::cloud::video::livestream::v1::UpdatePoolRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdatePool(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdatePool,
      (NoAwaitTag,
       google::cloud::video::livestream::v1::UpdatePoolRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdatePool(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::video::livestream::v1::Pool>>,
              UpdatePool, (google::longrunning::Operation const& operation),
              (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace video_livestream_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VIDEO_LIVESTREAM_V1_MOCKS_MOCK_LIVESTREAM_CONNECTION_H
