------------------------------------------------------------------------------
--                    GNAT Documentation Generation Tool                    --
--                                                                          --
--                     Copyright (C) 2023-2024, AdaCore                     --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General  Public  License  distributed  with  this  software;   see  file --
-- COPYING3.  If not, go to http://www.gnu.org/licenses for a complete copy --
-- of the license.                                                          --
------------------------------------------------------------------------------

--  Pass-through variant of the RST backend.

package GNATdoc.Backend.RST.PT is

   type PT_RST_Backend is new Abstract_Backend with private;

private

   type PT_RST_Backend is new RST_Backend_Base (True) with null record;

   overriding function Name
     (Self : in out PT_RST_Backend) return VSS.Strings.Virtual_String;

   overriding procedure Initialize (Self : in out PT_RST_Backend);

   overriding procedure Add_Command_Line_Options
     (Self   : PT_RST_Backend;
      Parser : in out VSS.Command_Line.Parsers.Command_Line_Parser'Class)
        is null;
   --  Don't register any options, non-OOP style is not supported in the
   --  pass-through mode.

end GNATdoc.Backend.RST.PT;
