/*
 * nvidia-settings: A tool for configuring the NVIDIA X driver on Unix
 * and Linux systems.
 *
 * Copyright (C) 2004 NVIDIA Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses>.
 */

#ifndef __CTK_GPU_H__
#define __CTK_GPU_H__

#include <gtk/gtk.h>
#include <query-assign.h>

#include "ctkevent.h"
#include "ctkconfig.h"

G_BEGIN_DECLS

#define CTK_TYPE_GPU (ctk_gpu_get_type())

#define CTK_GPU(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST ((obj), CTK_TYPE_GPU, CtkGpu))

#define CTK_GPU_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST ((klass), CTK_TYPE_GPU, CtkGpuClass))

#define CTK_IS_GPU(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CTK_TYPE_GPU))

#define CTK_IS_GPU_CLASS(class) \
    (G_TYPE_CHECK_CLASS_TYPE ((klass), CTK_TYPE_GPU))

#define CTK_GPU_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), CTK_TYPE_GPU, CtkGpuClass))


typedef struct _CtkGpu       CtkGpu;
typedef struct _CtkGpuClass  CtkGpuClass;

struct _CtkGpu
{
    GtkVBox parent;

    CtrlTarget *ctrl_target;
    CtkConfig *ctk_config;
    CtkEvent *ctk_event;

    GtkWidget *displays;
    GtkWidget *gpu_memory_used_label;
    GtkWidget *gpu_utilization_label;
    GtkWidget *video_utilization_label;
    GtkWidget *pcie_utilization_label;
    gint gpu_memory;
    gint gpu_utilization;
    gint gpu_cores;
    gint gpu_uuid;
    gint memory_interface;
    gboolean resizable_bar;
    gboolean pcie_gen_queriable;

    gboolean video_ram_available;
    gboolean link_speed_available;
    gboolean graphics_util_available;
    gboolean video_util_available;
    gboolean pcie_util_available;

    gboolean bus_type_available;
    gboolean bus_id_available;
    gboolean pci_device_id_available;
    gboolean pci_vendor_id_available;
    gboolean irq_available;
};

struct _CtkGpuClass
{
    GtkVBoxClass parent_class;
};

GType       ctk_gpu_get_type (void) G_GNUC_CONST;
GtkWidget*  ctk_gpu_new      (CtrlTarget *ctrl_target,
                              CtkEvent *ctk_event,
                              CtkConfig *ctk_config);

void get_bus_type_str(CtrlTarget *ctrl_target, gchar **bus);
gchar *get_bus_id_str(CtrlTarget *ctrl_target);

GtkTextBuffer *ctk_gpu_create_help(GtkTextTagTable *,
                                   CtkGpu *);

void ctk_gpu_page_select(GtkWidget *);
void ctk_gpu_page_unselect(GtkWidget *);

G_END_DECLS

#endif /* __CTK_GPU_H__ */

