/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.AbstractAddWindowsRightsAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.io.File;

public class AddWindowsFileRightsAction
extends AbstractAddWindowsRightsAction {
    private File[] files;

    public File[] getFiles() {
        return AddWindowsFileRightsAction.replaceVariables(this.files);
    }

    public void setFiles(File[] fileArray) {
        this.files = fileArray;
    }

    public boolean execute(Context context) throws UserCanceledException {
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        File[] fileArray = this.getFiles();
        if (fileArray == null) {
            return true;
        }
        boolean bl = true;
        for (int i = 0; i < fileArray.length; ++i) {
            bl &= this.executeForSingleFile(context, fileArray[i]);
        }
        return bl;
    }

    protected boolean executeForSingleFile(Context context, File file) throws UserCanceledException {
        File file2 = context.getDestinationFile(file);
        if (file2 == null || !file2.exists()) {
            return false;
        }
        return ContextImpl.getContextInt(context).runBooleanActivityWithFallback(new AbstractAddWindowsRightsAction.ACERemoteCallable(file2.getAbsolutePath(), false, this.isRead(), this.isWrite(), this.isExecute(), this.isAll(), this.getGroup().getIntValue(), this.getUsedSidOrAccountName()));
    }

    public boolean isRollbackSupported() {
        return false;
    }
}

