/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.AbstractRecursiveFileAction;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CreateZipFileAction
extends AbstractRecursiveFileAction {
    private File zipFile;
    private boolean addTopLevelDirectoriesToRelativePath;
    private transient ZipOutputStream zipOutputStream;

    public File getZipFile() {
        return CreateZipFileAction.replaceVariables(this.zipFile);
    }

    public void setZipFile(File file) {
        this.zipFile = file;
    }

    public boolean isAddTopLevelDirectoriesToRelativePath() {
        return this.addTopLevelDirectoriesToRelativePath;
    }

    public void setAddTopLevelDirectoriesToRelativePath(boolean bl) {
        this.addTopLevelDirectoriesToRelativePath = bl;
    }

    public boolean execute(Context context) throws UserCanceledException {
        try {
            this.zipOutputStream = new ZipOutputStream(new FileOutputStream(this.getZipFile()));
        }
        catch (IOException iOException) {
            Logger.getInstance().log(iOException);
            return false;
        }
        boolean bl = super.execute(context);
        if (bl) {
            try {
                this.zipOutputStream.close();
            }
            catch (IOException iOException) {
                Logger.getInstance().log(iOException);
                return false;
            }
        }
        return bl;
    }

    public boolean isRecursive() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeForSingleRecursiveFile(Context context, File file, File file2, ProgressAdapter progressAdapter) throws UserCanceledException, IOException {
        String string = file2.getPath().replace('\\', '/');
        if (string.startsWith("./")) {
            string = string.substring(2);
        }
        if (file.isDirectory()) {
            string = string + "/";
        }
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(file.lastModified());
        this.zipOutputStream.putNextEntry(zipEntry);
        if (file.isFile()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                FileUtil.pumpStream(fileInputStream, this.zipOutputStream, progressAdapter);
            }
            finally {
                fileInputStream.close();
            }
        }
        this.zipOutputStream.closeEntry();
        return true;
    }
}

