/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.registry.PreferencesAction;
import com.install4j.runtime.beans.actions.registry.PreferencesDeleteAction;
import com.install4j.runtime.installer.helper.Logger;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class DeletePreferenceItemAction
extends PreferencesDeleteAction {
    private String key = "";
    private boolean onlyIfEmpty = true;

    public String getKey() {
        return DeletePreferenceItemAction.replaceVariables(this.key);
    }

    public void setKey(String string) {
        this.key = string;
    }

    public boolean isOnlyIfEmpty() {
        return this.onlyIfEmpty;
    }

    public void setOnlyIfEmpty(boolean bl) {
        this.onlyIfEmpty = bl;
    }

    public boolean execute(Context context) throws UserCanceledException {
        if (this.getKey().trim().length() == 0 && this.getPackageName().trim().length() == 0) {
            return false;
        }
        return this.executePreferencesDeleter(new DeleteItemPreferencesDeleter(this.getKey(), this.isOnlyIfEmpty()), context);
    }

    private static class DeleteItemPreferencesDeleter
    implements PreferencesDeleteAction.PreferencesDeleter {
        private String key;
        private boolean onlyIfEmpty;

        public DeleteItemPreferencesDeleter(String string, boolean bl) {
            this.key = string.trim();
            this.onlyIfEmpty = bl;
        }

        public boolean deleteFromPreferences(PreferencesAction.PackageNodeProvider packageNodeProvider, Context context, List list) throws BackingStoreException {
            Preferences preferences = packageNodeProvider.getPackageNode();
            if (this.key.length() == 0) {
                if (this.onlyIfEmpty && (preferences.childrenNames().length > 0 || preferences.keys().length > 0)) {
                    Logger.getInstance().log(this, "Node is not empty", false);
                    return false;
                }
                PreferencesDeleteAction.deleteNode(packageNodeProvider, list);
                return true;
            }
            return PreferencesDeleteAction.deleteKey(packageNodeProvider, this.key, list);
        }
    }
}

