/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import [Ljava.lang.String;;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.windows.WinUser;
import com.install4j.runtime.beans.formcomponents.CreateUserDialog;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.beans.formcomponents.TextfieldComponent;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.win32.ObjectPicker;
import com.install4j.runtime.util.TextAndButtonPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class UserSelectorComponent
extends LeadingLabelComponent {
    private boolean showUsers = true;
    private boolean showGroups = false;
    private boolean showWellKnownPrincipals = false;
    private boolean multipleSelection = false;
    private boolean onlyLocal = false;
    private boolean showCreateButton = false;
    private String variableName = "";
    private String userCreatedVariableName = "";
    private String localGroupVariableName = "";
    private String groupCreatedVariableName = "";
    private String passwordFormComponentId = "";
    private JTextField txtUsers;
    private JButton btnBrowse;
    private JButton btnCreate;
    private String[] selectedSids;
    private List createdUserResults = new ArrayList();

    public boolean isShowUsers() {
        return this.showUsers;
    }

    public void setShowUsers(boolean bl) {
        this.showUsers = bl;
    }

    public boolean isShowGroups() {
        return this.showGroups;
    }

    public void setShowGroups(boolean bl) {
        this.showGroups = bl;
    }

    public boolean isShowWellKnownPrincipals() {
        return this.showWellKnownPrincipals;
    }

    public void setShowWellKnownPrincipals(boolean bl) {
        this.showWellKnownPrincipals = bl;
    }

    public boolean isMultipleSelection() {
        return this.multipleSelection;
    }

    public void setMultipleSelection(boolean bl) {
        this.multipleSelection = bl;
    }

    public boolean isOnlyLocal() {
        return this.onlyLocal;
    }

    public void setOnlyLocal(boolean bl) {
        this.onlyLocal = bl;
    }

    public boolean isShowCreateButton() {
        return this.showCreateButton;
    }

    public void setShowCreateButton(boolean bl) {
        this.showCreateButton = bl;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public String getUserCreatedVariableName() {
        return this.userCreatedVariableName;
    }

    public void setUserCreatedVariableName(String string) {
        this.userCreatedVariableName = string;
    }

    public String getLocalGroupVariableName() {
        return this.localGroupVariableName;
    }

    public void setLocalGroupVariableName(String string) {
        this.localGroupVariableName = string;
    }

    public String getGroupCreatedVariableName() {
        return this.groupCreatedVariableName;
    }

    public void setGroupCreatedVariableName(String string) {
        this.groupCreatedVariableName = string;
    }

    public String getPasswordFormComponentId() {
        return this.passwordFormComponentId;
    }

    public void setPasswordFormComponentId(String string) {
        this.passwordFormComponentId = string;
    }

    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.txtUsers != null && formEnvironment != null) {
            this.txtUsers.setName(formEnvironment.getId(this));
        }
    }

    public JComponent createCenterComponent() {
        this.txtUsers = new JTextField();
        this.txtUsers.setEditable(false);
        this.btnBrowse = new JButton(Messages.getMessages().getString("ButtonBrowse"));
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserSelectorComponent.this.doBrowse();
            }
        });
        TextAndButtonPanel textAndButtonPanel = new TextAndButtonPanel(this.txtUsers, this.btnBrowse);
        if (this.showUsers && this.showCreateButton) {
            this.btnCreate = new JButton(Messages.getMessages().getString("ButtonCreateUser"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets.left = 5;
            textAndButtonPanel.add((Component)this.btnCreate, gridBagConstraints);
            this.btnCreate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UserSelectorComponent.this.doCreate();
                }
            });
            this.multipleSelection = false;
        }
        return textAndButtonPanel;
    }

    public void initialize() {
        super.initialize();
        if (this.multipleSelection) {
            this.selectedSids = (String[])this.getInitValue(null, this.getVariableName(), String;.class);
        } else {
            String string = (String)this.getInitValue(null, this.getVariableName(), String.class);
            if (string != null) {
                this.selectedSids = new String[]{string};
            }
        }
        this.updateTextField();
    }

    public boolean checkCompleted() {
        String string = this.getVariableName();
        Object object = this.getVariableValue();
        Context context = this.getContext();
        context.setVariable(string, object);
        context.registerResponseFileVariable(string);
        if (this.showUsers && this.showCreateButton) {
            if (this.userCreatedVariableName.length() > 0) {
                context.setVariable(this.userCreatedVariableName, Boolean.FALSE);
            }
            if (this.localGroupVariableName.length() > 0) {
                context.setVariable(this.localGroupVariableName, "");
            }
            if (this.groupCreatedVariableName.length() > 0) {
                context.setVariable(this.groupCreatedVariableName, Boolean.FALSE);
            }
            String string2 = (String)object;
            Iterator iterator = this.createdUserResults.iterator();
            while (iterator.hasNext()) {
                WinUser.AddUserResult addUserResult = (WinUser.AddUserResult)iterator.next();
                if (addUserResult.getUserSid().equals(string2)) {
                    if (this.userCreatedVariableName.length() > 0) {
                        context.setVariable(this.userCreatedVariableName, Boolean.TRUE);
                        context.registerResponseFileVariable(this.userCreatedVariableName);
                    }
                    if (this.localGroupVariableName.length() > 0 && addUserResult.getGroupSid() != null) {
                        context.setVariable(this.localGroupVariableName, addUserResult.getGroupSid());
                        context.registerResponseFileVariable(this.localGroupVariableName);
                    }
                    if (this.groupCreatedVariableName.length() <= 0) continue;
                    context.setVariable(this.groupCreatedVariableName, addUserResult.isGroupCreated());
                    context.registerResponseFileVariable(this.groupCreatedVariableName);
                    continue;
                }
                WinUser.deleteUser(addUserResult.getUserSid());
                if (addUserResult.isGroupCreated() && addUserResult.getGroupSid() != null) {
                    WinUser.deleteLocalGroup(addUserResult.getGroupSid());
                }
                iterator.remove();
            }
        }
        return true;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.btnBrowse.setEnabled(bl);
        if (this.btnCreate != null) {
            this.btnCreate.setEnabled(bl);
        }
    }

    private Object getVariableValue() {
        if (this.multipleSelection) {
            if (this.selectedSids == null) {
                return new String[0];
            }
            return this.selectedSids;
        }
        if (this.selectedSids == null || this.selectedSids.length != 1) {
            return "";
        }
        return this.selectedSids[0];
    }

    private void doBrowse() {
        if (this.getFormEnvironment().isDesignTime()) {
            return;
        }
        ObjectPicker.Result[] resultArray = ObjectPicker.show(this.multipleSelection, this.showGroups, this.showUsers, this.showWellKnownPrincipals, this.onlyLocal);
        if (resultArray != null) {
            this.selectedSids = new String[resultArray.length];
            for (int i = 0; i < resultArray.length; ++i) {
                ObjectPicker.Result result = resultArray[i];
                this.selectedSids[i] = result.getSid();
            }
            this.updateTextField();
        }
    }

    private void updateTextField() {
        if (this.selectedSids != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.selectedSids.length; ++i) {
                String string;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("; ");
                }
                if ((string = WinUser.getAccountName(this.selectedSids[i])) == null) continue;
                stringBuffer.append(string);
            }
            this.txtUsers.setText(stringBuffer.toString());
        }
    }

    private void doCreate() {
        if (this.getFormEnvironment().isDesignTime()) {
            return;
        }
        CreateUserDialog createUserDialog = CreateUserDialog.create(Util.getParentWindow());
        createUserDialog.setVisible(true);
        createUserDialog.dispose();
        if (!createUserDialog.isCanceled()) {
            String string = createUserDialog.getResult().getUserSid();
            this.selectedSids = new String[]{string};
            this.txtUsers.setText(WinUser.getAccountName(string));
            this.createdUserResults.add(createUserDialog.getResult());
            if (this.passwordFormComponentId.length() > 0) {
                FormComponent formComponent = this.getFormEnvironment().getFormComponentById(this.passwordFormComponentId);
                if (formComponent instanceof TextfieldComponent) {
                    ((JTextField)((TextfieldComponent)formComponent).getConfigurationObject()).setText(createUserDialog.getPassword());
                } else {
                    Logger.getInstance().log(this, "The password form component with ID " + this.passwordFormComponentId + " is not a text field form component.", false);
                }
            }
        }
    }

    public boolean isFillCenterHorizontal() {
        return true;
    }
}

