/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.dirchooser;

import com.install4j.api.Util;
import com.install4j.runtime.dirchooser.DirectoryChooserDialog;
import com.install4j.runtime.dirchooser.DirectoryChooserUI;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;

public class DirectoryChooser
extends JFileChooser {
    static final String PROPERTY_MANUAL_DIRECTORY_CHOOSER = "manualDirectoryChooser";
    private String title;
    private DirectoryChooserDialog dialog;
    private int returnValue = -1;
    private boolean activated;
    private boolean allowFolderCreation;
    private String cancelButtonText;

    public DirectoryChooser() {
    }

    public DirectoryChooser(File file) {
        super(file);
    }

    public DirectoryChooser(File file, FileSystemView fileSystemView) {
        super(file, fileSystemView);
    }

    public DirectoryChooser(FileSystemView fileSystemView) {
        super(fileSystemView);
    }

    public DirectoryChooser(String string) {
        super(string);
    }

    public DirectoryChooser(String string, FileSystemView fileSystemView) {
        super(string, fileSystemView);
    }

    public boolean isAllowFolderCreation() {
        return this.allowFolderCreation;
    }

    public void setAllowFolderCreation(boolean bl) {
        this.allowFolderCreation = bl;
        this.updateUI();
    }

    public boolean isDialogVisible() {
        return this.dialog != null && this.dialog.isVisible();
    }

    public void setUI(ComponentUI componentUI) {
        if (!(componentUI instanceof DirectoryChooserUI)) {
            this.setUI(new DirectoryChooserUI(this));
        } else {
            super.setUI(componentUI);
        }
    }

    public void setCurrentDirectory(File file) {
        if (file != null && this.getSelectedFile() != null && !file.equals(this.getSelectedFile())) {
            this.setSelectedFile(null);
        }
        super.setCurrentDirectory(file);
    }

    public void setSelectedFiles(File[] fileArray) {
        super.setSelectedFiles(fileArray);
        this.setSelectedFile(fileArray[0]);
    }

    public int showDialog(Component component, String string) {
        return this.showDialog(component, string, null);
    }

    public int showDialog(Component component, String string, String string2) {
        this.cancelButtonText = string2;
        if (string != null) {
            this.setApproveButtonText(string);
        }
        if (this.dialog == null) {
            this.dialog = DirectoryChooserDialog.create(this, Util.getParentWindow());
            this.dialog.setTitle(this.title);
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowActivated(WindowEvent windowEvent) {
                    if (!DirectoryChooser.this.activated) {
                        ((DirectoryChooserUI)DirectoryChooser.this.getUI()).scrollToSelection();
                    }
                    DirectoryChooser.this.activated = true;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    DirectoryChooser.this.returnValue = 1;
                }
            });
        }
        this.returnValue = -1;
        this.rescanCurrentDirectory();
        this.dialog.setVisible(true);
        return this.returnValue;
    }

    protected void fireActionPerformed(String string) {
        if (string.equals("ApproveSelection")) {
            this.returnValue = 0;
            this.dialog.setVisible(false);
        } else if (string.equals("CancelSelection")) {
            this.returnValue = 1;
            this.dialog.setVisible(false);
        }
        super.fireActionPerformed(string);
    }

    public static void main(String[] stringArray) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        System.setProperty(PROPERTY_MANUAL_DIRECTORY_CHOOSER, "true");
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setMultiSelectionEnabled(false);
        directoryChooser.setAllowFolderCreation(true);
        directoryChooser.setTitle("Select directory");
        directoryChooser.setCurrentDirectory(new File("c:\\Program Files (x86)"));
        int n = directoryChooser.showOpenDialog(null);
        if (n == 1) {
            System.out.println("User Canceled");
        } else {
            System.out.println("Dialog Selection: " + directoryChooser.getSelectedFile().getAbsolutePath());
        }
        System.exit(0);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void focusTree() {
        ((DirectoryChooserUI)this.getUI()).focusTree();
    }

    public String getCancelButtonText() {
        return this.cancelButtonText;
    }
}

