/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content.apache.archivers.tar;

import com.install4j.runtime.installer.helper.content.apache.archivers.ArchiveEntry;
import com.install4j.runtime.installer.helper.content.apache.archivers.ArchiveInputStream;
import com.install4j.runtime.installer.helper.content.apache.archivers.tar.TarArchiveEntry;
import com.install4j.runtime.installer.helper.content.apache.archivers.tar.TarArchiveSparseEntry;
import com.install4j.runtime.installer.helper.content.apache.archivers.tar.TarBuffer;
import com.install4j.runtime.installer.helper.content.apache.archivers.tar.TarUtils;
import com.install4j.runtime.installer.helper.content.apache.utils.ArchiveUtils;
import com.install4j.runtime.installer.helper.content.apache.utils.ZipEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TarArchiveInputStream
extends ArchiveInputStream {
    private static final int SMALL_BUFFER_SIZE = 256;
    private static final int BUFFER_SIZE = 8192;
    private boolean hasHitEOF;
    private long entrySize;
    private long entryOffset;
    private byte[] readBuf;
    protected final TarBuffer buffer;
    private TarArchiveEntry currEntry;
    private final ZipEncoding encoding = TarUtils.DEFAULT_ENCODING;

    public TarArchiveInputStream(InputStream inputStream) {
        this(inputStream, 10240, 512);
    }

    public TarArchiveInputStream(InputStream inputStream, int n) {
        this(inputStream, n, 512);
    }

    public TarArchiveInputStream(InputStream inputStream, int n, int n2) {
        this.buffer = new TarBuffer(inputStream, n, n2);
        this.readBuf = null;
        this.hasHitEOF = false;
    }

    public void close() throws IOException {
        this.buffer.close();
    }

    public int getRecordSize() {
        return this.buffer.getRecordSize();
    }

    public int available() throws IOException {
        if (this.entrySize - this.entryOffset > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)(this.entrySize - this.entryOffset);
    }

    public long skip(long l) throws IOException {
        int n;
        long l2;
        int n2;
        byte[] byArray = new byte[8192];
        for (l2 = l; l2 > 0L && (n2 = this.read(byArray, 0, n = (int)(l2 > (long)byArray.length ? (long)byArray.length : l2))) != -1; l2 -= (long)n2) {
        }
        return l - l2;
    }

    public synchronized void reset() {
    }

    public TarArchiveEntry getNextTarEntry() throws IOException {
        if (this.hasHitEOF) {
            return null;
        }
        if (this.currEntry != null) {
            long l;
            for (long i = this.entrySize - this.entryOffset; i > 0L; i -= l) {
                l = this.skip(i);
                if (l > 0L) continue;
                throw new RuntimeException("failed to skip current tar entry");
            }
            this.readBuf = null;
        }
        byte[] byArray = this.getRecord();
        if (this.hasHitEOF) {
            this.currEntry = null;
            return null;
        }
        try {
            this.currEntry = new TarArchiveEntry(byArray, this.encoding);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IOException iOException = new IOException("Error detected parsing the header");
            iOException.initCause(illegalArgumentException);
            throw iOException;
        }
        this.entryOffset = 0L;
        this.entrySize = this.currEntry.getSize();
        if (this.currEntry.isGNULongNameEntry()) {
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray2 = new byte[256];
            int n = 0;
            while ((n = this.read(byArray2)) >= 0) {
                stringBuffer.append(new String(byArray2, 0, n));
            }
            this.getNextEntry();
            if (this.currEntry == null) {
                return null;
            }
            if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '\u0000') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            this.currEntry.setName(stringBuffer.toString());
        }
        if (this.currEntry.isPaxHeader()) {
            this.paxHeaders();
        }
        if (this.currEntry.isGNUSparse()) {
            this.readGNUSparse();
        }
        this.entrySize = this.currEntry.getSize();
        return this.currEntry;
    }

    private byte[] getRecord() throws IOException {
        if (this.hasHitEOF) {
            return null;
        }
        byte[] byArray = this.buffer.readRecord();
        if (byArray == null) {
            this.hasHitEOF = true;
        } else if (this.buffer.isEOFRecord(byArray)) {
            this.hasHitEOF = true;
        }
        return this.hasHitEOF ? null : byArray;
    }

    private void paxHeaders() throws IOException {
        Map map = this.parsePaxHeaders(this);
        this.getNextEntry();
        this.applyPaxHeadersToCurrentEntry(map);
    }

    Map parsePaxHeaders(InputStream inputStream) throws IOException {
        int n;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        block0: do {
            int n2 = 0;
            int n3 = 0;
            while ((n = inputStream.read()) != -1) {
                ++n3;
                if (n == 32) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    while ((n = inputStream.read()) != -1) {
                        ++n3;
                        if (n == 61) {
                            String string = byteArrayOutputStream.toString("UTF-8");
                            byte[] byArray = new byte[n2 - n3];
                            int n4 = inputStream.read(byArray);
                            if (n4 != n2 - n3) {
                                throw new IOException("Failed to read Paxheader. Expected " + (n2 - n3) + " bytes, read " + n4);
                            }
                            String string2 = new String(byArray, 0, n2 - n3 - 1, "UTF-8");
                            hashMap.put(string, string2);
                            continue block0;
                        }
                        byteArrayOutputStream.write((byte)n);
                    }
                    continue block0;
                }
                n2 *= 10;
                n2 += n - 48;
            }
        } while (n != -1);
        return hashMap;
    }

    private void applyPaxHeadersToCurrentEntry(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if ("path".equals(string)) {
                this.currEntry.setName(string2);
                continue;
            }
            if ("linkpath".equals(string)) {
                this.currEntry.setLinkName(string2);
                continue;
            }
            if ("gid".equals(string)) {
                this.currEntry.setGroupId(Integer.parseInt(string2));
                continue;
            }
            if ("gname".equals(string)) {
                this.currEntry.setGroupName(string2);
                continue;
            }
            if ("uid".equals(string)) {
                this.currEntry.setUserId(Integer.parseInt(string2));
                continue;
            }
            if ("uname".equals(string)) {
                this.currEntry.setUserName(string2);
                continue;
            }
            if ("size".equals(string)) {
                this.currEntry.setSize(Long.parseLong(string2));
                continue;
            }
            if ("mtime".equals(string)) {
                this.currEntry.setModTime((long)(Double.parseDouble(string2) * 1000.0));
                continue;
            }
            if ("SCHILY.devminor".equals(string)) {
                this.currEntry.setDevMinor(Integer.parseInt(string2));
                continue;
            }
            if (!"SCHILY.devmajor".equals(string)) continue;
            this.currEntry.setDevMajor(Integer.parseInt(string2));
        }
    }

    private void readGNUSparse() throws IOException {
        if (this.currEntry.isExtended()) {
            byte[] byArray;
            TarArchiveSparseEntry tarArchiveSparseEntry;
            do {
                byArray = this.getRecord();
                if (!this.hasHitEOF) continue;
                this.currEntry = null;
                break;
            } while ((tarArchiveSparseEntry = new TarArchiveSparseEntry(byArray)).isExtended());
        }
    }

    public ArchiveEntry getNextEntry() throws IOException {
        return this.getNextTarEntry();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        if (this.entryOffset >= this.entrySize) {
            return -1;
        }
        if ((long)n2 + this.entryOffset > this.entrySize) {
            n2 = (int)(this.entrySize - this.entryOffset);
        }
        if (this.readBuf != null) {
            int n5 = n2 > this.readBuf.length ? this.readBuf.length : n2;
            System.arraycopy(this.readBuf, 0, byArray, n, n5);
            if (n5 >= this.readBuf.length) {
                this.readBuf = null;
            } else {
                n3 = this.readBuf.length - n5;
                byte[] byArray2 = new byte[n3];
                System.arraycopy(this.readBuf, n5, byArray2, 0, n3);
                this.readBuf = byArray2;
            }
            n4 += n5;
            n2 -= n5;
            n += n5;
        }
        while (n2 > 0) {
            byte[] byArray3 = this.buffer.readRecord();
            if (byArray3 == null) {
                throw new IOException("unexpected EOF with " + n2 + " bytes unread. Occured at byte: " + this.getBytesRead());
            }
            this.count(byArray3.length);
            n3 = n2;
            int n6 = byArray3.length;
            if (n6 > n3) {
                System.arraycopy(byArray3, 0, byArray, n, n3);
                this.readBuf = new byte[n6 - n3];
                System.arraycopy(byArray3, n3, this.readBuf, 0, n6 - n3);
            } else {
                n3 = n6;
                System.arraycopy(byArray3, 0, byArray, n, n6);
            }
            n4 += n3;
            n2 -= n3;
            n += n3;
        }
        this.entryOffset += (long)n4;
        return n4;
    }

    public boolean canReadEntryData(ArchiveEntry archiveEntry) {
        if (archiveEntry instanceof TarArchiveEntry) {
            TarArchiveEntry tarArchiveEntry = (TarArchiveEntry)archiveEntry;
            return !tarArchiveEntry.isGNUSparse();
        }
        return false;
    }

    protected final TarArchiveEntry getCurrentEntry() {
        return this.currEntry;
    }

    protected final void setCurrentEntry(TarArchiveEntry tarArchiveEntry) {
        this.currEntry = tarArchiveEntry;
    }

    protected final boolean isAtEOF() {
        return this.hasHitEOF;
    }

    protected final void setAtEOF(boolean bl) {
        this.hasHitEOF = bl;
    }

    public static boolean matches(byte[] byArray, int n) {
        if (n < 265) {
            return false;
        }
        if (ArchiveUtils.matchAsciiBuffer("ustar\u0000", byArray, 257, 6) && ArchiveUtils.matchAsciiBuffer("00", byArray, 263, 2)) {
            return true;
        }
        if (ArchiveUtils.matchAsciiBuffer("ustar ", byArray, 257, 6) && (ArchiveUtils.matchAsciiBuffer(" \u0000", byArray, 263, 2) || ArchiveUtils.matchAsciiBuffer("0\u0000", byArray, 263, 2))) {
            return true;
        }
        return ArchiveUtils.matchAsciiBuffer("ustar\u0000", byArray, 257, 6) && ArchiveUtils.matchAsciiBuffer("\u0000\u0000", byArray, 263, 2);
    }
}

