/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos;

import com.install4j.runtime.installer.platform.JVMLocator;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class MacosJVMLocator {
    private static final String OLD_APPLE_ROOT_LOCATION = "/System/Library/Frameworks/JavaVM.framework/Versions";
    public static final String OLD_APPLE_HOME_DIR = "Home";
    private static final String[] OLD_APPLE_JDK_FILES = new String[]{"Commands/javac", "Home/src.jar"};
    private static final String OLD_APPLE_JAVA_EXECUTABLE = "Commands/java";
    private static final String NEW_APPLE_ROOT_LOCATIONS = "/System/Library/Java/JavaVirtualMachines";
    private static final String NEW_HOME_DIR = "Contents/Home";
    private static final String[] NEW_JDK_FILES = new String[]{"Contents/Home/bin/javac"};
    private static final String NEW_JAVA_EXECUTABLE = "Contents/Home/bin/java";
    private static final String ORACLE_ROOT_LOCATIONS = "/Library/Java/JavaVirtualMachines";
    private static final String JRE_PLUGIN = "/Library/Internet Plug-Ins/JavaAppletPlugin.plugin";

    public static Collection getJVMLocations() {
        HashSet hashSet = new HashSet();
        MacosJVMLocator.addJVMs(hashSet, NEW_APPLE_ROOT_LOCATIONS, NEW_JAVA_EXECUTABLE, NEW_JDK_FILES, NEW_HOME_DIR);
        if (hashSet.size() == 0) {
            MacosJVMLocator.addJVMs(hashSet, OLD_APPLE_ROOT_LOCATION, OLD_APPLE_JAVA_EXECUTABLE, OLD_APPLE_JDK_FILES, OLD_APPLE_HOME_DIR);
        }
        MacosJVMLocator.addJVMs(hashSet, ORACLE_ROOT_LOCATIONS, NEW_JAVA_EXECUTABLE, NEW_JDK_FILES, NEW_HOME_DIR);
        MacosJVMLocator.checkBundle(hashSet, new File(JRE_PLUGIN), NEW_JAVA_EXECUTABLE, NEW_JDK_FILES, NEW_HOME_DIR);
        return hashSet;
    }

    private static void addJVMs(Set set, String string, String string2, String[] stringArray, String string3) {
        File[] fileArray = new File(string).listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                MacosJVMLocator.checkBundle(set, fileArray[i], string2, stringArray, string3);
            }
        }
    }

    private static void checkBundle(Set set, File file, String string, String[] stringArray, String string2) {
        if (file.isDirectory()) {
            try {
                JVMLocator.JVMLocation jVMLocation = JVMLocator.checkJVMLocation(file, string, stringArray);
                if (jVMLocation != null && jVMLocation.getJavaHome() != null) {
                    jVMLocation.setJavaHome(new File(jVMLocation.getJavaHome(), string2));
                    set.add(jVMLocation);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static JVMLocator.JVMLocation getJVMLocation(File file) throws IOException {
        JVMLocator.JVMLocation jVMLocation = JVMLocator.checkJVMLocation(file = MacosJVMLocator.stripContentsHome(file), NEW_JAVA_EXECUTABLE, NEW_JDK_FILES);
        if (jVMLocation != null) {
            jVMLocation.setJavaHome(new File(jVMLocation.getJavaHome(), NEW_HOME_DIR));
        } else {
            jVMLocation = JVMLocator.checkJVMLocation(file, OLD_APPLE_JAVA_EXECUTABLE, OLD_APPLE_JDK_FILES);
            if (jVMLocation != null) {
                jVMLocation.setJavaHome(new File(jVMLocation.getJavaHome(), OLD_APPLE_HOME_DIR));
            }
        }
        return jVMLocation;
    }

    private static File stripContentsHome(File file) {
        File file2;
        if (file != null && file.getName().equals(OLD_APPLE_HOME_DIR) && (file2 = file.getParentFile()) != null && file2.getName().equals("Contents") && file2.getParentFile() != null) {
            file = file2.getParentFile();
        }
        return file;
    }
}

