/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.wizard;

import com.install4j.api.beans.Anchor;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.util.ButtonUtil;
import com.install4j.runtime.util.DisplayTextArea;
import com.install4j.runtime.util.KeyboardUtil;
import com.install4j.runtime.util.MaximizedLayeredPane;
import com.install4j.runtime.util.PartialLineBorder;
import com.install4j.runtime.wizard.WizardBase;
import com.install4j.runtime.wizard.WizardScreen;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public abstract class StandardScreen
extends WizardScreen
implements ActionListener {
    private static final int HORIZONTAL_BUTTON_SPACER = 10;
    private static final Color DEFAULT_BANNER_BACKGROUND = new Color(34, 79, 153);
    private JButton btnPrevious;
    private JButton btnForward;
    private JButton btnCancel;
    private List revalidationComponents;
    private DisplayTextArea titleLabel;
    private DisplayTextArea subtitleLabel;

    public StandardScreen(WizardBase wizardBase) {
        super(wizardBase);
    }

    protected abstract void addScreenContent(JPanel var1, GridBagConstraints var2);

    protected abstract String getTitle();

    protected abstract String getSubTitle();

    protected abstract Icon getBannerIcon();

    protected abstract Anchor getBannerImageAnchor();

    protected abstract Color getHeaderBackgroundColor();

    protected abstract Color getHeaderForegroundColor();

    protected abstract Icon getHeaderIcon();

    protected abstract boolean isHeaderIconOverlap();

    protected abstract Anchor getHeaderIconAnchor();

    protected abstract JButton createCancelButton();

    protected abstract JButton createForwardButton();

    protected abstract JButton createPreviousButton();

    protected void initScreen() {
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    protected JButton getPreviousButton() {
        return this.btnPrevious;
    }

    protected JButton getForwardButton() {
        return this.btnForward;
    }

    protected JButton getCancelButton() {
        return this.btnCancel;
    }

    protected void setupControls() {
        this.revalidationComponents = new ArrayList();
        this.btnPrevious = this.createPreviousButton();
        this.btnForward = this.createForwardButton();
        this.btnCancel = this.createCancelButton();
    }

    protected void setupComponent() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createMainPanel(), "Center");
    }

    private JPanel createMainPanel() {
        JComponent jComponent;
        Object object;
        Serializable serializable;
        JPanel jPanel = new JPanel(new BorderLayout());
        if (this.isBannerPainted()) {
            serializable = this.getBannerImageAnchor();
            object = this.getBannerIcon();
            jComponent = new JLabel((Icon)object);
            JPanel jPanel2 = new JPanel();
            if (serializable == Anchor.NORTH || serializable == Anchor.SOUTH) {
                jPanel2.setLayout(new BorderLayout());
                jPanel2.add((Component)jComponent, serializable == Anchor.NORTH ? "North" : "South");
            } else {
                jPanel2.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.anchor = this.getBannerImageAnchor().getValue();
                jPanel2.add((Component)jComponent, gridBagConstraints);
            }
            jPanel2.setOpaque(true);
            jPanel2.setBackground(this.getBannerBackground());
            jPanel2.setPreferredSize(new Dimension(object.getIconWidth(), 0));
            jPanel.add((Component)jPanel2, "West");
        } else if (this.hasTitlePanel()) {
            jPanel.add((Component)this.createTitlePanel(), "North");
        }
        serializable = new JPanel(new GridBagLayout());
        ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 5));
        object = new GridBagConstraints();
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        jPanel.add((Component)serializable, "Center");
        ((GridBagConstraints)object).gridwidth = this.getMaxGridWidth();
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).anchor = 18;
        if (this.isBannerPainted()) {
            ((GridBagConstraints)object).insets = new Insets(5, 0, 0, 5);
            ((JComponent)serializable).setBackground(Color.white);
            ((JComponent)serializable).setOpaque(true);
        } else {
            ((GridBagConstraints)object).insets = new Insets(5, 15, 0, 20);
        }
        if (this.isBannerPainted()) {
            this.titleLabel = this.createTitleLabel(4, true, this.getTitle());
            ((Container)serializable).add(this.titleLabel, object);
            ++((GridBagConstraints)object).gridy;
            ((Container)serializable).add(this.createSeparator(false), object);
            ++((GridBagConstraints)object).gridy;
        }
        this.addScreenContent((JPanel)serializable, (GridBagConstraints)object);
        if (this.needsSpacer()) {
            ((GridBagConstraints)object).weighty = 1.0;
            ((GridBagConstraints)object).fill = 1;
            jComponent = new JPanel();
            jComponent.setBackground(((Component)serializable).getBackground());
            jComponent.setOpaque(false);
            ((Container)serializable).add(jComponent, object);
            ++((GridBagConstraints)object).gridy;
        }
        if (this.hasNavigationPanel()) {
            jComponent = this.createNavigationPanel(this.createButtonBox(), true);
            jPanel.add((Component)jComponent, "South");
        }
        return jPanel;
    }

    protected boolean hasTitlePanel() {
        return true;
    }

    protected Color getBannerBackground() {
        return DEFAULT_BANNER_BACKGROUND;
    }

    protected void setupEventHandlers() {
        this.btnPrevious.addActionListener(this);
        this.btnForward.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Iterator iterator = StandardScreen.this.revalidationComponents.iterator();
                while (iterator.hasNext()) {
                    ((Component)iterator.next()).invalidate();
                }
                StandardScreen.this.validate();
            }
        });
        KeyboardUtil.addAccelerator(1, this.btnCancel, this, this, 27, 0);
        KeyboardUtil.addAccelerator(1, this.btnForward, this, this, 39, 8);
        KeyboardUtil.addAccelerator(1, this.btnPrevious, this, this, 37, 8);
    }

    protected boolean isBannerPainted() {
        return false;
    }

    protected int getMaxGridWidth() {
        return 1;
    }

    protected boolean needsSpacer() {
        return true;
    }

    protected boolean hasNavigationPanel() {
        return true;
    }

    protected Box createButtonBox() {
        Box box = ButtonUtil.createHorizontalButtonBox(new Component[]{this.btnPrevious, this.btnForward}, 0);
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalGlue());
        box2.add(box);
        box2.add(Box.createHorizontalStrut(10));
        box2.add(this.btnCancel);
        return box2;
    }

    protected boolean checkCompleted() {
        return true;
    }

    protected void addDisplayTextArea(String string, JPanel jPanel, GridBagConstraints gridBagConstraints) {
        int n = gridBagConstraints.fill;
        double d = gridBagConstraints.weightx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DisplayTextArea displayTextArea = new DisplayTextArea();
        displayTextArea.setText(string);
        jPanel.add((Component)displayTextArea, gridBagConstraints);
        this.revalidationComponents.add(displayTextArea);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = n;
        gridBagConstraints.weightx = d;
    }

    protected JPanel createBorderPanel(String string, LayoutManager layoutManager) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string));
        if (layoutManager != null) {
            jPanel.setLayout(layoutManager);
        }
        return jPanel;
    }

    protected void cancel() {
        this.getWizardBase().cancel();
    }

    protected void updateTitleAndSubtitle() {
        if (this.titleLabel != null) {
            this.titleLabel.setText(this.getTitle());
        }
        if (this.subtitleLabel != null) {
            this.subtitleLabel.setText(this.getSubTitle());
        }
    }

    private JComponent createTitlePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        MaximizedLayeredPane maximizedLayeredPane = new MaximizedLayeredPane();
        JPanel jPanel2 = this.createTitleFrontPanel(!this.isHeaderIconOverlap());
        maximizedLayeredPane.add((Component)jPanel2, JLayeredPane.PALETTE_LAYER);
        if (this.isHeaderIconOverlap()) {
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            jPanel3.setBackground(this.getHeaderBackgroundColor());
            jPanel3.setOpaque(true);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = this.getHeaderIconAnchor().getValue();
            jPanel3.add((Component)new JLabel(this.getHeaderIcon()), gridBagConstraints);
            maximizedLayeredPane.add((Component)jPanel3, JLayeredPane.DEFAULT_LAYER);
        }
        jPanel.add((Component)maximizedLayeredPane, "Center");
        jPanel.setBorder(new PartialLineBorder(GUIHelper.getSeparatorColor(), 1, 2));
        return jPanel;
    }

    private JPanel createTitleFrontPanel(boolean bl) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        if (bl) {
            jPanel.setBackground(this.getHeaderBackgroundColor());
            jPanel.setOpaque(true);
        } else {
            jPanel.setOpaque(false);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 15, 0, 5);
        this.titleLabel = this.applyHeaderForeground(this.createTitleLabel(0, true, this.getTitle()));
        jPanel.add((Component)this.titleLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 25, 5, 5);
        this.subtitleLabel = this.applyHeaderForeground(this.createTitleLabel(0, false, this.getSubTitle()));
        jPanel.add((Component)this.subtitleLabel, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 13, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        if (bl) {
            jPanel.add((Component)new JLabel(this.getHeaderIcon()), gridBagConstraints);
        }
        return jPanel;
    }

    private DisplayTextArea applyHeaderForeground(DisplayTextArea displayTextArea) {
        Color color = this.getHeaderForegroundColor();
        if (color != null) {
            displayTextArea.setForeground(color);
        }
        return displayTextArea;
    }

    private DisplayTextArea createTitleLabel(int n, boolean bl, String string) {
        DisplayTextArea displayTextArea = new DisplayTextArea();
        displayTextArea.setText(string);
        Font font = displayTextArea.getFont();
        if (bl) {
            Font font2 = new Font("Dialog", 1, font.getSize() + n);
            displayTextArea.setFont(font2);
        }
        this.revalidationComponents.add(displayTextArea);
        return displayTextArea;
    }
}

