#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <string.h>
#include "vars.h"

/*****************************************
 ********* Load urls to memory ***********/
int load_urls(int section,char *file_name)
{
 struct p_url *url;
 char tmp[ML_CFG+ML_2LD+ML_SUBDOMEN+ML_PROTOKOL+ML_PORT+ML_DIRS],etmp[ML_ETMP];
 int z;
 #ifdef DEBUG_URLS_LOAD
 int i,l;
 #endif
 FILE *fp;

 /*** Init some vars ***/
  url=malloc(sizeof(struct p_url));
  if (url==NULL)
   {
     sprintf(etmp,"MAKE-CACHE: ERROR: Can't allocate memory\n");
     err_mes(etmp);
     exit(-1);
   }
    // Init pointers
    redir[section]->ban_urls=NULL;
    redir[section]->ban_urls_count=0;


  #ifdef DEBUG_URLS_LOAD
  fprintf(stderr,"\n* Load urls to section %s from file %s\n",redir[section]->name,file_name);
  #endif

    // Open file
    if ((fp=fopen(file_name,"r"))==NULL)
	{ // Open error
          sprintf(etmp,"MAKE-CACHE: WARNING: Can't open file %s: %s",file_name,strerror(errno));
          err_mes(etmp);
	  exit(-1);
        }

    // Parse file
    while(!feof(fp))
    {
     // Get line
     if (fgets(tmp,ML_CFG,fp)==NULL)
      {
        if (feof(fp)) continue;
	sprintf(etmp,"MAKE-CACHE: ERROR: Can't read from file %s: %s",file_name,strerror(errno));
	err_mes(etmp);
	exit(-1);
      }

     //Chomp
     if (tmp[strlen(tmp)-1]=='\n' || tmp[strlen(tmp)-1]=='\r') tmp[strlen(tmp)-1]=0;
     if (tmp[strlen(tmp)-1]=='\n' || tmp[strlen(tmp)-1]=='\r') tmp[strlen(tmp)-1]=0;
     if (strlen(tmp)<=0) continue;

     #ifdef CASE_INDEPENDENT
      for (z=0;z<strlen(tmp);z++)
      tmp[z]=tolower((int)tmp[z]);
     #endif

     #ifdef DEBUG_URLS_LOAD
      fprintf(stderr,"   read url: %s\n",tmp);
     #endif

     // Parse url and convert to struct url 
     z=parse_urls(url,tmp);
     if (z<0)
        {
	  sprintf(etmp, "MAKE-CACHE: WARNING: Can't parse rule: %s. Skipping.",tmp);
          err_mes(etmp);
	  #ifdef DEBUG_URLS_LOAD
           fprintf(stderr,"%s\n",etmp);
          #endif
	  continue;
        }

 // Make string to add
    if (url->twoleveldomen[0] && !url->port[0] && !url->subdomen[0] && !url->dirs[0])
     { 
      // 2 level domen only
      z=strlen(url->twoleveldomen);
      memcpy(tmp,url->twoleveldomen,z);
      tmp[z]=0;
     }
    else
     {   // combined string

      // 2 level domen
      z=strlen(url->twoleveldomen);
      memcpy(tmp,url->twoleveldomen,z);
      tmp[z++]=1;

      // subdomen
      if (url->subdomen[0])
         {
	  memcpy(&tmp[z],url->subdomen,strlen(url->subdomen)); 
	  z+=strlen(url->subdomen);
	 }
      tmp[z++]=1;

      // port
      if (url->port[0])
         {
	  memcpy(&tmp[z],url->port,strlen(url->port)); 
	  z+=strlen(url->port);
	 }
      tmp[z++]=1;

      // dirs
      if (url->dirs[0])
         {
	  memcpy(&tmp[z],url->dirs,strlen(url->dirs)); 
	  z+=strlen(url->dirs);
	 }
      tmp[z++]=1;

      // end symbol
      tmp[z]=0;
     }

     //Add memory line
     redir[section]->ban_urls=(char **)realloc(redir[section]->ban_urls,(1+redir[section]->ban_urls_count)*sizeof(char *));
     if (redir[section]->ban_urls==NULL)
         {
          err_mes("MAKE-CACHE: ERROR: Can't allocate memory for urls\n");
          return(-1);
         }


     redir[section]->ban_urls[redir[section]->ban_urls_count]=(char*)strdup(tmp);
     if (redir[section]->ban_urls[redir[section]->ban_urls_count]==NULL)
         {
          err_mes("MAKE-CACHE: ERROR: Can't allocate memory for urls\n");
          return(-1);
         }

      redir[section]->ban_urls_count++;

    #ifdef DEBUG_URLS_LOAD
     fprintf(stderr," add string: ");
     for (z=0;z<strlen(tmp);z++)
      if (tmp[z]==1)  fprintf(stderr,"!");
      else fprintf(stderr,"%c",tmp[z]);
       fprintf(stderr,"\n");
    #endif

   } //while

  #ifdef DEBUG_URLS_LOAD
  fprintf(stderr,"\n=== Added urls to section %s ===\n",redir[section]->name);
  for (i=0;i<redir[section]->ban_urls_count;i++)
    {
     if (!redir[section]->ban_urls[i]) {fprintf(stderr,"NULL\n"); continue;}

     for (l=0;l<strlen(redir[section]->ban_urls[i]);l++)
      if ((redir[section]->ban_urls[i])[l]==1)  fprintf(stderr,"!");
      else fprintf(stderr,"%c",(redir[section]->ban_urls[i])[l]);
       fprintf(stderr,"\n");
    }
  #endif

    sprintf(etmp,"MAKE-CACHE: Load %i rules from %s",redir[section]->ban_urls_count,file_name);
    err_mes(etmp);

    // Close file
    fclose(fp);

    return(0); // Load OK
}
