/* $Id: pktrecord.h,v 1.2 2004/09/22 15:15:52 iscjonm Exp $
 *
 * Copyright (C) 2004 The Trustees of the University of Pennsylvania
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _PKTRECORD_H
#define _PKTRECORD_H

struct pktrecord {
  unsigned int orig_len;       /* original length of the captured packet */
  unsigned int included_len;   /* how much of it we actually have here */
  unsigned int ts_secs;	       /* timestamp, seconds component */
  unsigned int ts_usecs;       /* timestamp, microseconds component */
  unsigned char *pkt_data;     /* pointer to the actual packet data */
};

struct prec_handle;

/* prec_init is called to acquire a prec_handle on stdin */
extern int prec_init(struct prec_handle **hout);

/* prec_is_eth determines whether the packet stream consists of
   Ethernet frames or not */
extern int prec_is_eth(struct prec_handle *ph);

/* prec_next_packet fills in the next packet from the stream in the
   pktrecord pointed to by p. returns 1 if a packet was available, 0
   if not (either due to error or due to EOF) */
extern int prec_next_packet(struct prec_handle *ph, struct pktrecord *p);

/* dispose of a prec_handle */
extern int prec_close(struct prec_handle *ph);

#endif
