//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfstringencoding?language=objc)
pub type CFStringEncoding = u32;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfstringbuiltinencodings?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFStringBuiltInEncodings(pub CFStringEncoding);
impl CFStringBuiltInEncodings {
    #[doc(alias = "kCFStringEncodingMacRoman")]
    pub const EncodingMacRoman: Self = Self(0);
    #[doc(alias = "kCFStringEncodingWindowsLatin1")]
    pub const EncodingWindowsLatin1: Self = Self(0x0500);
    #[doc(alias = "kCFStringEncodingISOLatin1")]
    pub const EncodingISOLatin1: Self = Self(0x0201);
    #[doc(alias = "kCFStringEncodingNextStepLatin")]
    pub const EncodingNextStepLatin: Self = Self(0x0B01);
    #[doc(alias = "kCFStringEncodingASCII")]
    pub const EncodingASCII: Self = Self(0x0600);
    #[doc(alias = "kCFStringEncodingUnicode")]
    pub const EncodingUnicode: Self = Self(0x0100);
    #[doc(alias = "kCFStringEncodingUTF8")]
    pub const EncodingUTF8: Self = Self(0x08000100);
    #[doc(alias = "kCFStringEncodingNonLossyASCII")]
    pub const EncodingNonLossyASCII: Self = Self(0x0BFF);
    #[doc(alias = "kCFStringEncodingUTF16")]
    pub const EncodingUTF16: Self = Self(0x0100);
    #[doc(alias = "kCFStringEncodingUTF16BE")]
    pub const EncodingUTF16BE: Self = Self(0x10000100);
    #[doc(alias = "kCFStringEncodingUTF16LE")]
    pub const EncodingUTF16LE: Self = Self(0x14000100);
    #[doc(alias = "kCFStringEncodingUTF32")]
    pub const EncodingUTF32: Self = Self(0x0c000100);
    #[doc(alias = "kCFStringEncodingUTF32BE")]
    pub const EncodingUTF32BE: Self = Self(0x18000100);
    #[doc(alias = "kCFStringEncodingUTF32LE")]
    pub const EncodingUTF32LE: Self = Self(0x1c000100);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFStringBuiltInEncodings {
    const ENCODING: Encoding = CFStringEncoding::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFStringBuiltInEncodings {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFString {
    #[doc(alias = "CFStringGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFStringGetTypeID() -> CFTypeID;
        }
        unsafe { CFStringGetTypeID() }
    }
}

/// * Immutable string creation functions **
#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringCreateWithPascalString(
    alloc: Option<&CFAllocator>,
    p_str: ConstStr255Param,
    encoding: CFStringEncoding,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFStringCreateWithPascalString(
            alloc: Option<&CFAllocator>,
            p_str: ConstStr255Param,
            encoding: CFStringEncoding,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFStringCreateWithPascalString(alloc, p_str, encoding) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringCreateWithCString(
    alloc: Option<&CFAllocator>,
    c_str: *const c_char,
    encoding: CFStringEncoding,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFStringCreateWithCString(
            alloc: Option<&CFAllocator>,
            c_str: *const c_char,
            encoding: CFStringEncoding,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFStringCreateWithCString(alloc, c_str, encoding) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringCreateWithBytes(
    alloc: Option<&CFAllocator>,
    bytes: *const u8,
    num_bytes: CFIndex,
    encoding: CFStringEncoding,
    is_external_representation: bool,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFStringCreateWithBytes(
            alloc: Option<&CFAllocator>,
            bytes: *const u8,
            num_bytes: CFIndex,
            encoding: CFStringEncoding,
            is_external_representation: Boolean,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe {
        CFStringCreateWithBytes(
            alloc,
            bytes,
            num_bytes,
            encoding,
            is_external_representation as _,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringCreateWithCharacters(
    alloc: Option<&CFAllocator>,
    chars: *const UniChar,
    num_chars: CFIndex,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFStringCreateWithCharacters(
            alloc: Option<&CFAllocator>,
            chars: *const UniChar,
            num_chars: CFIndex,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFStringCreateWithCharacters(alloc, chars, num_chars) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringCreateWithPascalStringNoCopy(
    alloc: Option<&CFAllocator>,
    p_str: ConstStr255Param,
    encoding: CFStringEncoding,
    contents_deallocator: Option<&CFAllocator>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFStringCreateWithPascalStringNoCopy(
            alloc: Option<&CFAllocator>,
            p_str: ConstStr255Param,
            encoding: CFStringEncoding,
            contents_deallocator: Option<&CFAllocator>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe {
        CFStringCreateWithPascalStringNoCopy(alloc, p_str, encoding, contents_deallocator)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringCreateWithCStringNoCopy(
    alloc: Option<&CFAllocator>,
    c_str: *const c_char,
    encoding: CFStringEncoding,
    contents_deallocator: Option<&CFAllocator>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFStringCreateWithCStringNoCopy(
            alloc: Option<&CFAllocator>,
            c_str: *const c_char,
            encoding: CFStringEncoding,
            contents_deallocator: Option<&CFAllocator>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret =
        unsafe { CFStringCreateWithCStringNoCopy(alloc, c_str, encoding, contents_deallocator) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringCreateWithBytesNoCopy(
    alloc: Option<&CFAllocator>,
    bytes: *const u8,
    num_bytes: CFIndex,
    encoding: CFStringEncoding,
    is_external_representation: bool,
    contents_deallocator: Option<&CFAllocator>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFStringCreateWithBytesNoCopy(
            alloc: Option<&CFAllocator>,
            bytes: *const u8,
            num_bytes: CFIndex,
            encoding: CFStringEncoding,
            is_external_representation: Boolean,
            contents_deallocator: Option<&CFAllocator>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe {
        CFStringCreateWithBytesNoCopy(
            alloc,
            bytes,
            num_bytes,
            encoding,
            is_external_representation as _,
            contents_deallocator,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringCreateWithCharactersNoCopy(
    alloc: Option<&CFAllocator>,
    chars: *const UniChar,
    num_chars: CFIndex,
    contents_deallocator: Option<&CFAllocator>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFStringCreateWithCharactersNoCopy(
            alloc: Option<&CFAllocator>,
            chars: *const UniChar,
            num_chars: CFIndex,
            contents_deallocator: Option<&CFAllocator>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe {
        CFStringCreateWithCharactersNoCopy(alloc, chars, num_chars, contents_deallocator)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringCreateWithSubstring(
    alloc: Option<&CFAllocator>,
    str: Option<&CFString>,
    range: CFRange,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFStringCreateWithSubstring(
            alloc: Option<&CFAllocator>,
            str: Option<&CFString>,
            range: CFRange,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFStringCreateWithSubstring(alloc, str, range) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringCreateCopy(
    alloc: Option<&CFAllocator>,
    the_string: Option<&CFString>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFStringCreateCopy(
            alloc: Option<&CFAllocator>,
            the_string: Option<&CFString>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFStringCreateCopy(alloc, the_string) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringCreateMutable(
    alloc: Option<&CFAllocator>,
    max_length: CFIndex,
) -> Option<CFRetained<CFMutableString>> {
    extern "C-unwind" {
        fn CFStringCreateMutable(
            alloc: Option<&CFAllocator>,
            max_length: CFIndex,
        ) -> Option<NonNull<CFMutableString>>;
    }
    let ret = unsafe { CFStringCreateMutable(alloc, max_length) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringCreateMutableCopy(
    alloc: Option<&CFAllocator>,
    max_length: CFIndex,
    the_string: Option<&CFString>,
) -> Option<CFRetained<CFMutableString>> {
    extern "C-unwind" {
        fn CFStringCreateMutableCopy(
            alloc: Option<&CFAllocator>,
            max_length: CFIndex,
            the_string: Option<&CFString>,
        ) -> Option<NonNull<CFMutableString>>;
    }
    let ret = unsafe { CFStringCreateMutableCopy(alloc, max_length, the_string) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringCreateMutableWithExternalCharactersNoCopy(
    alloc: Option<&CFAllocator>,
    chars: *mut UniChar,
    num_chars: CFIndex,
    capacity: CFIndex,
    external_characters_allocator: Option<&CFAllocator>,
) -> Option<CFRetained<CFMutableString>> {
    extern "C-unwind" {
        fn CFStringCreateMutableWithExternalCharactersNoCopy(
            alloc: Option<&CFAllocator>,
            chars: *mut UniChar,
            num_chars: CFIndex,
            capacity: CFIndex,
            external_characters_allocator: Option<&CFAllocator>,
        ) -> Option<NonNull<CFMutableString>>;
    }
    let ret = unsafe {
        CFStringCreateMutableWithExternalCharactersNoCopy(
            alloc,
            chars,
            num_chars,
            capacity,
            external_characters_allocator,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    /// * Basic accessors for the contents **
    #[cfg(feature = "CFBase")]
    pub fn CFStringGetLength(the_string: &CFString) -> CFIndex;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringGetCharacterAtIndex(the_string: &CFString, idx: CFIndex) -> UniChar;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringGetCharacters(the_string: &CFString, range: CFRange, buffer: *mut UniChar);
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringGetPascalString(
    the_string: &CFString,
    buffer: StringPtr,
    buffer_size: CFIndex,
    encoding: CFStringEncoding,
) -> bool {
    extern "C-unwind" {
        fn CFStringGetPascalString(
            the_string: &CFString,
            buffer: StringPtr,
            buffer_size: CFIndex,
            encoding: CFStringEncoding,
        ) -> Boolean;
    }
    let ret = unsafe { CFStringGetPascalString(the_string, buffer, buffer_size, encoding) };
    ret != 0
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringGetCString(
    the_string: &CFString,
    buffer: *mut c_char,
    buffer_size: CFIndex,
    encoding: CFStringEncoding,
) -> bool {
    extern "C-unwind" {
        fn CFStringGetCString(
            the_string: &CFString,
            buffer: *mut c_char,
            buffer_size: CFIndex,
            encoding: CFStringEncoding,
        ) -> Boolean;
    }
    let ret = unsafe { CFStringGetCString(the_string, buffer, buffer_size, encoding) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringGetPascalStringPtr(
        the_string: &CFString,
        encoding: CFStringEncoding,
    ) -> ConstStringPtr;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringGetCStringPtr(
        the_string: &CFString,
        encoding: CFStringEncoding,
    ) -> *const c_char;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringGetCharactersPtr(the_string: &CFString) -> *const UniChar;
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringGetBytes(
    the_string: &CFString,
    range: CFRange,
    encoding: CFStringEncoding,
    loss_byte: u8,
    is_external_representation: bool,
    buffer: *mut u8,
    max_buf_len: CFIndex,
    used_buf_len: *mut CFIndex,
) -> CFIndex {
    extern "C-unwind" {
        fn CFStringGetBytes(
            the_string: &CFString,
            range: CFRange,
            encoding: CFStringEncoding,
            loss_byte: u8,
            is_external_representation: Boolean,
            buffer: *mut u8,
            max_buf_len: CFIndex,
            used_buf_len: *mut CFIndex,
        ) -> CFIndex;
    }
    unsafe {
        CFStringGetBytes(
            the_string,
            range,
            encoding,
            loss_byte,
            is_external_representation as _,
            buffer,
            max_buf_len,
            used_buf_len,
        )
    }
}

#[cfg(all(feature = "CFBase", feature = "CFData"))]
#[inline]
pub unsafe extern "C-unwind" fn CFStringCreateFromExternalRepresentation(
    alloc: Option<&CFAllocator>,
    data: Option<&CFData>,
    encoding: CFStringEncoding,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFStringCreateFromExternalRepresentation(
            alloc: Option<&CFAllocator>,
            data: Option<&CFData>,
            encoding: CFStringEncoding,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFStringCreateFromExternalRepresentation(alloc, data, encoding) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "CFData"))]
#[inline]
pub unsafe extern "C-unwind" fn CFStringCreateExternalRepresentation(
    alloc: Option<&CFAllocator>,
    the_string: Option<&CFString>,
    encoding: CFStringEncoding,
    loss_byte: u8,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFStringCreateExternalRepresentation(
            alloc: Option<&CFAllocator>,
            the_string: Option<&CFString>,
            encoding: CFStringEncoding,
            loss_byte: u8,
        ) -> Option<NonNull<CFData>>;
    }
    let ret =
        unsafe { CFStringCreateExternalRepresentation(alloc, the_string, encoding, loss_byte) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringGetSmallestEncoding(the_string: &CFString) -> CFStringEncoding;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringGetFastestEncoding(the_string: &CFString) -> CFStringEncoding;
}

extern "C-unwind" {
    pub fn CFStringGetSystemEncoding() -> CFStringEncoding;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringGetMaximumSizeForEncoding(
        length: CFIndex,
        encoding: CFStringEncoding,
    ) -> CFIndex;
}

/// * FileSystem path conversion functions **
#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringGetFileSystemRepresentation(
    string: &CFString,
    buffer: *mut c_char,
    max_buf_len: CFIndex,
) -> bool {
    extern "C-unwind" {
        fn CFStringGetFileSystemRepresentation(
            string: &CFString,
            buffer: *mut c_char,
            max_buf_len: CFIndex,
        ) -> Boolean;
    }
    let ret = unsafe { CFStringGetFileSystemRepresentation(string, buffer, max_buf_len) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringGetMaximumSizeOfFileSystemRepresentation(string: &CFString) -> CFIndex;
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringCreateWithFileSystemRepresentation(
    alloc: Option<&CFAllocator>,
    buffer: *const c_char,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFStringCreateWithFileSystemRepresentation(
            alloc: Option<&CFAllocator>,
            buffer: *const c_char,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFStringCreateWithFileSystemRepresentation(alloc, buffer) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfstringcompareflags?language=objc)
// NS_OPTIONS
#[cfg(feature = "CFBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFStringCompareFlags(pub CFOptionFlags);
#[cfg(feature = "CFBase")]
bitflags::bitflags! {
    impl CFStringCompareFlags: CFOptionFlags {
        #[doc(alias = "kCFCompareCaseInsensitive")]
        const CompareCaseInsensitive = 1;
        #[doc(alias = "kCFCompareBackwards")]
        const CompareBackwards = 4;
        #[doc(alias = "kCFCompareAnchored")]
        const CompareAnchored = 8;
        #[doc(alias = "kCFCompareNonliteral")]
        const CompareNonliteral = 16;
        #[doc(alias = "kCFCompareLocalized")]
        const CompareLocalized = 32;
        #[doc(alias = "kCFCompareNumerically")]
        const CompareNumerically = 64;
        #[doc(alias = "kCFCompareDiacriticInsensitive")]
        const CompareDiacriticInsensitive = 128;
        #[doc(alias = "kCFCompareWidthInsensitive")]
        const CompareWidthInsensitive = 256;
        #[doc(alias = "kCFCompareForcedOrdering")]
        const CompareForcedOrdering = 512;
    }
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFStringCompareFlags {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFStringCompareFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "CFLocale"))]
    pub fn CFStringCompareWithOptionsAndLocale(
        the_string1: &CFString,
        the_string2: Option<&CFString>,
        range_to_compare: CFRange,
        compare_options: CFStringCompareFlags,
        locale: Option<&CFLocale>,
    ) -> CFComparisonResult;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringCompareWithOptions(
        the_string1: &CFString,
        the_string2: Option<&CFString>,
        range_to_compare: CFRange,
        compare_options: CFStringCompareFlags,
    ) -> CFComparisonResult;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringCompare(
        the_string1: &CFString,
        the_string2: Option<&CFString>,
        compare_options: CFStringCompareFlags,
    ) -> CFComparisonResult;
}

#[cfg(all(feature = "CFBase", feature = "CFLocale"))]
#[inline]
pub unsafe extern "C-unwind" fn CFStringFindWithOptionsAndLocale(
    the_string: &CFString,
    string_to_find: Option<&CFString>,
    range_to_search: CFRange,
    search_options: CFStringCompareFlags,
    locale: Option<&CFLocale>,
    result: *mut CFRange,
) -> bool {
    extern "C-unwind" {
        fn CFStringFindWithOptionsAndLocale(
            the_string: &CFString,
            string_to_find: Option<&CFString>,
            range_to_search: CFRange,
            search_options: CFStringCompareFlags,
            locale: Option<&CFLocale>,
            result: *mut CFRange,
        ) -> Boolean;
    }
    let ret = unsafe {
        CFStringFindWithOptionsAndLocale(
            the_string,
            string_to_find,
            range_to_search,
            search_options,
            locale,
            result,
        )
    };
    ret != 0
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringFindWithOptions(
    the_string: &CFString,
    string_to_find: Option<&CFString>,
    range_to_search: CFRange,
    search_options: CFStringCompareFlags,
    result: *mut CFRange,
) -> bool {
    extern "C-unwind" {
        fn CFStringFindWithOptions(
            the_string: &CFString,
            string_to_find: Option<&CFString>,
            range_to_search: CFRange,
            search_options: CFStringCompareFlags,
            result: *mut CFRange,
        ) -> Boolean;
    }
    let ret = unsafe {
        CFStringFindWithOptions(
            the_string,
            string_to_find,
            range_to_search,
            search_options,
            result,
        )
    };
    ret != 0
}

#[cfg(all(feature = "CFArray", feature = "CFBase"))]
#[inline]
pub unsafe extern "C-unwind" fn CFStringCreateArrayWithFindResults(
    alloc: Option<&CFAllocator>,
    the_string: Option<&CFString>,
    string_to_find: Option<&CFString>,
    range_to_search: CFRange,
    compare_options: CFStringCompareFlags,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFStringCreateArrayWithFindResults(
            alloc: Option<&CFAllocator>,
            the_string: Option<&CFString>,
            string_to_find: Option<&CFString>,
            range_to_search: CFRange,
            compare_options: CFStringCompareFlags,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe {
        CFStringCreateArrayWithFindResults(
            alloc,
            the_string,
            string_to_find,
            range_to_search,
            compare_options,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringFind(
        the_string: &CFString,
        string_to_find: Option<&CFString>,
        compare_options: CFStringCompareFlags,
    ) -> CFRange;
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringHasPrefix(
    the_string: &CFString,
    prefix: Option<&CFString>,
) -> bool {
    extern "C-unwind" {
        fn CFStringHasPrefix(the_string: &CFString, prefix: Option<&CFString>) -> Boolean;
    }
    let ret = unsafe { CFStringHasPrefix(the_string, prefix) };
    ret != 0
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringHasSuffix(
    the_string: &CFString,
    suffix: Option<&CFString>,
) -> bool {
    extern "C-unwind" {
        fn CFStringHasSuffix(the_string: &CFString, suffix: Option<&CFString>) -> Boolean;
    }
    let ret = unsafe { CFStringHasSuffix(the_string, suffix) };
    ret != 0
}

extern "C-unwind" {
    /// Returns the range of the composed character sequence at the specified index.
    ///
    /// Parameter `theString`: The CFString which is to be searched.  If this
    /// parameter is not a valid CFString, the behavior is
    /// undefined.
    ///
    /// Parameter `theIndex`: The index of the character contained in the
    /// composed character sequence.  If the index is
    /// outside the index space of the string (0 to N-1 inclusive,
    /// where N is the length of the string), the behavior is
    /// undefined.
    ///
    /// Returns: The range of the composed character sequence.
    #[cfg(feature = "CFBase")]
    pub fn CFStringGetRangeOfComposedCharactersAtIndex(
        the_string: &CFString,
        the_index: CFIndex,
    ) -> CFRange;
}

/// Query the range of the first character contained in the specified character set.
///
/// Parameter `theString`: The CFString which is to be searched.  If this
/// parameter is not a valid CFString, the behavior is
/// undefined.
///
/// Parameter `theSet`: The CFCharacterSet against which the membership
/// of characters is checked.  If this parameter is not a valid
/// CFCharacterSet, the behavior is undefined.
///
/// Parameter `rangeToSearch`: The range of characters within the string to search. If
/// the range location or end point (defined by the location
/// plus length minus 1) are outside the index space of the
/// string (0 to N-1 inclusive, where N is the length of the
/// string), the behavior is undefined. If the range length is
/// negative, the behavior is undefined. The range may be empty
/// (length 0), in which case no search is performed.
///
/// Parameter `searchOptions`: The bitwise-or'ed option flags to control
/// the search behavior.  The supported options are
/// kCFCompareBackwards andkCFCompareAnchored.
/// If other option flags are specified, the behavior
/// is undefined.
///
/// Parameter `result`: The pointer to a CFRange supplied by the caller in
/// which the search result is stored.  Note that the length
/// of this range can be more than 1, if for instance the
/// result is a composed character. If a pointer to an invalid
/// memory is specified, the behavior is undefined.
///
/// Returns: true, if at least a character which is a member of the character
/// set is found and result is filled, otherwise, false.
#[cfg(all(feature = "CFBase", feature = "CFCharacterSet"))]
#[inline]
pub unsafe extern "C-unwind" fn CFStringFindCharacterFromSet(
    the_string: &CFString,
    the_set: Option<&CFCharacterSet>,
    range_to_search: CFRange,
    search_options: CFStringCompareFlags,
    result: *mut CFRange,
) -> bool {
    extern "C-unwind" {
        fn CFStringFindCharacterFromSet(
            the_string: &CFString,
            the_set: Option<&CFCharacterSet>,
            range_to_search: CFRange,
            search_options: CFStringCompareFlags,
            result: *mut CFRange,
        ) -> Boolean;
    }
    let ret = unsafe {
        CFStringFindCharacterFromSet(the_string, the_set, range_to_search, search_options, result)
    };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringGetLineBounds(
        the_string: &CFString,
        range: CFRange,
        line_begin_index: *mut CFIndex,
        line_end_index: *mut CFIndex,
        contents_end_index: *mut CFIndex,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringGetParagraphBounds(
        string: &CFString,
        range: CFRange,
        par_begin_index: *mut CFIndex,
        par_end_index: *mut CFIndex,
        contents_end_index: *mut CFIndex,
    );
}

extern "C-unwind" {
    /// Retrieve the first potential hyphenation location found before the specified location.
    ///
    /// Parameter `string`: The CFString which is to be hyphenated.  If this
    /// parameter is not a valid CFString, the behavior is
    /// undefined.
    ///
    /// Parameter `location`: An index in the string.  If a valid hyphen index is returned, it
    /// will be before this index.
    ///
    /// Parameter `limitRange`: The range of characters within the string to search. If
    /// the range location or end point (defined by the location
    /// plus length minus 1) are outside the index space of the
    /// string (0 to N-1 inclusive, where N is the length of the
    /// string), the behavior is undefined. If the range length is
    /// negative, the behavior is undefined. The range may be empty
    /// (length 0), in which case no hyphen location is generated.
    ///
    /// Parameter `options`: Reserved for future use.
    ///
    /// Parameter `locale`: Specifies which language's hyphenation conventions to use.
    /// This must be a valid locale.  Hyphenation data is not available
    /// for all locales.  You can use CFStringIsHyphenationAvailableForLocale
    /// to test for availability of hyphenation data.
    ///
    /// Parameter `character`: The suggested hyphen character to insert.  Pass NULL if you
    /// do not need this information.
    ///
    /// Returns: an index in the string where it is appropriate to insert a hyphen, if
    /// one exists; else kCFNotFound
    #[cfg(all(feature = "CFBase", feature = "CFLocale"))]
    pub fn CFStringGetHyphenationLocationBeforeIndex(
        string: &CFString,
        location: CFIndex,
        limit_range: CFRange,
        options: CFOptionFlags,
        locale: Option<&CFLocale>,
        character: *mut UTF32Char,
    ) -> CFIndex;
}

#[cfg(feature = "CFLocale")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringIsHyphenationAvailableForLocale(
    locale: Option<&CFLocale>,
) -> bool {
    extern "C-unwind" {
        fn CFStringIsHyphenationAvailableForLocale(locale: Option<&CFLocale>) -> Boolean;
    }
    let ret = unsafe { CFStringIsHyphenationAvailableForLocale(locale) };
    ret != 0
}

/// * Exploding and joining strings with a separator string **
#[cfg(all(feature = "CFArray", feature = "CFBase"))]
#[inline]
pub unsafe extern "C-unwind" fn CFStringCreateByCombiningStrings(
    alloc: Option<&CFAllocator>,
    the_array: Option<&CFArray>,
    separator_string: Option<&CFString>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFStringCreateByCombiningStrings(
            alloc: Option<&CFAllocator>,
            the_array: Option<&CFArray>,
            separator_string: Option<&CFString>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFStringCreateByCombiningStrings(alloc, the_array, separator_string) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFArray", feature = "CFBase"))]
#[inline]
pub unsafe extern "C-unwind" fn CFStringCreateArrayBySeparatingStrings(
    alloc: Option<&CFAllocator>,
    the_string: Option<&CFString>,
    separator_string: Option<&CFString>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFStringCreateArrayBySeparatingStrings(
            alloc: Option<&CFAllocator>,
            the_string: Option<&CFString>,
            separator_string: Option<&CFString>,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret =
        unsafe { CFStringCreateArrayBySeparatingStrings(alloc, the_string, separator_string) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    /// * Parsing non-localized numbers from strings **
    #[cfg(feature = "CFBase")]
    pub fn CFStringGetIntValue(str: &CFString) -> i32;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringGetDoubleValue(str: &CFString) -> c_double;
}

extern "C-unwind" {
    /// * MutableString functions **
    #[cfg(feature = "CFBase")]
    pub fn CFStringAppend(the_string: Option<&CFMutableString>, appended_string: Option<&CFString>);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringAppendCharacters(
        the_string: Option<&CFMutableString>,
        chars: *const UniChar,
        num_chars: CFIndex,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringAppendPascalString(
        the_string: Option<&CFMutableString>,
        p_str: ConstStr255Param,
        encoding: CFStringEncoding,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringAppendCString(
        the_string: Option<&CFMutableString>,
        c_str: *const c_char,
        encoding: CFStringEncoding,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringInsert(
        str: Option<&CFMutableString>,
        idx: CFIndex,
        inserted_str: Option<&CFString>,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringDelete(the_string: Option<&CFMutableString>, range: CFRange);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringReplace(
        the_string: Option<&CFMutableString>,
        range: CFRange,
        replacement: Option<&CFString>,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringReplaceAll(the_string: Option<&CFMutableString>, replacement: Option<&CFString>);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringFindAndReplace(
        the_string: Option<&CFMutableString>,
        string_to_find: Option<&CFString>,
        replacement_string: Option<&CFString>,
        range_to_search: CFRange,
        compare_options: CFStringCompareFlags,
    ) -> CFIndex;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringSetExternalCharactersNoCopy(
        the_string: Option<&CFMutableString>,
        chars: *mut UniChar,
        length: CFIndex,
        capacity: CFIndex,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringPad(
        the_string: Option<&CFMutableString>,
        pad_string: Option<&CFString>,
        length: CFIndex,
        index_into_pad: CFIndex,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringTrim(the_string: Option<&CFMutableString>, trim_string: Option<&CFString>);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringTrimWhitespace(the_string: Option<&CFMutableString>);
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "CFLocale"))]
    pub fn CFStringLowercase(the_string: Option<&CFMutableString>, locale: Option<&CFLocale>);
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "CFLocale"))]
    pub fn CFStringUppercase(the_string: Option<&CFMutableString>, locale: Option<&CFLocale>);
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "CFLocale"))]
    pub fn CFStringCapitalize(the_string: Option<&CFMutableString>, locale: Option<&CFLocale>);
}

/// This is the type of Unicode normalization forms as described in
/// Unicode Technical Report #15. To normalize for use with file
/// system calls, use CFStringGetFileSystemRepresentation().
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfstringnormalizationform?language=objc)
// NS_ENUM
#[cfg(feature = "CFBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFStringNormalizationForm(pub CFIndex);
#[cfg(feature = "CFBase")]
impl CFStringNormalizationForm {
    #[doc(alias = "kCFStringNormalizationFormD")]
    pub const D: Self = Self(0);
    #[doc(alias = "kCFStringNormalizationFormKD")]
    pub const KD: Self = Self(1);
    #[doc(alias = "kCFStringNormalizationFormC")]
    pub const C: Self = Self(2);
    #[doc(alias = "kCFStringNormalizationFormKC")]
    pub const KC: Self = Self(3);
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFStringNormalizationForm {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFStringNormalizationForm {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C-unwind" {
    /// Normalizes the string into the specified form as described in
    /// Unicode Technical Report #15.
    ///
    /// Parameter `theString`: The string which is to be normalized.  If this
    /// parameter is not a valid mutable CFString, the behavior is
    /// undefined.
    ///
    /// Parameter `theForm`: The form into which the string is to be normalized.
    /// If this parameter is not a valid CFStringNormalizationForm value,
    /// the behavior is undefined.
    #[cfg(feature = "CFBase")]
    pub fn CFStringNormalize(
        the_string: Option<&CFMutableString>,
        the_form: CFStringNormalizationForm,
    );
}

extern "C-unwind" {
    /// Folds the string into the form specified by the flags.
    /// Character foldings are operations that convert any of a set of characters
    /// sharing similar semantics into a single representative from that set.
    /// This function can be used to preprocess strings that are to be compared,
    /// searched, or indexed.
    /// Note that folding does not include normalization, so it is necessary
    /// to use CFStringNormalize in addition to CFStringFold in order to obtain
    /// the effect of kCFCompareNonliteral.
    ///
    /// Parameter `theString`: The string which is to be folded.  If this parameter is not
    /// a valid mutable CFString, the behavior is undefined.
    ///
    /// Parameter `theFlags`: The equivalency flags which describes the character folding form.
    /// Only those flags containing the word "insensitive" are recognized here; other flags are ignored.
    /// Folding with kCFCompareCaseInsensitive removes case distinctions in accordance with the mapping
    /// specified by ftp://ftp.unicode.org/Public/UNIDATA/CaseFolding.txt.  Folding with
    /// kCFCompareDiacriticInsensitive removes distinctions of accents and other diacritics.  Folding
    /// with kCFCompareWidthInsensitive removes character width distinctions by mapping characters in
    /// the range U+FF00-U+FFEF to their ordinary equivalents.
    ///
    /// Parameter `theLocale`: The locale tailoring the character folding behavior. If NULL,
    /// it's considered to be the system locale returned from CFLocaleGetSystem().
    /// If non-NULL and not a valid CFLocale object, the behavior is undefined.
    #[cfg(all(feature = "CFBase", feature = "CFLocale"))]
    pub fn CFStringFold(
        the_string: Option<&CFMutableString>,
        the_flags: CFStringCompareFlags,
        the_locale: Option<&CFLocale>,
    );
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringTransform(
    string: Option<&CFMutableString>,
    range: *mut CFRange,
    transform: Option<&CFString>,
    reverse: bool,
) -> bool {
    extern "C-unwind" {
        fn CFStringTransform(
            string: Option<&CFMutableString>,
            range: *mut CFRange,
            transform: Option<&CFString>,
            reverse: Boolean,
        ) -> Boolean;
    }
    let ret = unsafe { CFStringTransform(string, range, transform, reverse as _) };
    ret != 0
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstringtransformstripcombiningmarks?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStringTransformStripCombiningMarks: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstringtransformtolatin?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStringTransformToLatin: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstringtransformfullwidthhalfwidth?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStringTransformFullwidthHalfwidth: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstringtransformlatinkatakana?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStringTransformLatinKatakana: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstringtransformlatinhiragana?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStringTransformLatinHiragana: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstringtransformhiraganakatakana?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStringTransformHiraganaKatakana: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstringtransformmandarinlatin?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStringTransformMandarinLatin: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstringtransformlatinhangul?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStringTransformLatinHangul: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstringtransformlatinarabic?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStringTransformLatinArabic: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstringtransformlatinhebrew?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStringTransformLatinHebrew: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstringtransformlatinthai?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStringTransformLatinThai: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstringtransformlatincyrillic?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStringTransformLatinCyrillic: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstringtransformlatingreek?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStringTransformLatinGreek: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstringtransformtoxmlhex?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStringTransformToXMLHex: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstringtransformtounicodename?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStringTransformToUnicodeName: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstringtransformstripdiacritics?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStringTransformStripDiacritics: Option<&'static CFString>;
}

/// * General encoding related functionality **
#[inline]
pub unsafe extern "C-unwind" fn CFStringIsEncodingAvailable(encoding: CFStringEncoding) -> bool {
    extern "C-unwind" {
        fn CFStringIsEncodingAvailable(encoding: CFStringEncoding) -> Boolean;
    }
    let ret = unsafe { CFStringIsEncodingAvailable(encoding) };
    ret != 0
}

extern "C-unwind" {
    pub fn CFStringGetListOfAvailableEncodings() -> *const CFStringEncoding;
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringGetNameOfEncoding(
    encoding: CFStringEncoding,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFStringGetNameOfEncoding(encoding: CFStringEncoding) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFStringGetNameOfEncoding(encoding) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    pub fn CFStringConvertEncodingToNSStringEncoding(encoding: CFStringEncoding) -> c_ulong;
}

extern "C-unwind" {
    pub fn CFStringConvertNSStringEncodingToEncoding(encoding: c_ulong) -> CFStringEncoding;
}

extern "C-unwind" {
    pub fn CFStringConvertEncodingToWindowsCodepage(encoding: CFStringEncoding) -> u32;
}

extern "C-unwind" {
    pub fn CFStringConvertWindowsCodepageToEncoding(codepage: u32) -> CFStringEncoding;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFStringConvertIANACharSetNameToEncoding(the_string: &CFString) -> CFStringEncoding;
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFStringConvertEncodingToIANACharSetName(
    encoding: CFStringEncoding,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFStringConvertEncodingToIANACharSetName(
            encoding: CFStringEncoding,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFStringConvertEncodingToIANACharSetName(encoding) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    pub fn CFStringGetMostCompatibleMacStringEncoding(
        encoding: CFStringEncoding,
    ) -> CFStringEncoding;
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfstringinlinebuffer?language=objc)
#[cfg(feature = "CFBase")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFStringInlineBuffer {
    pub buffer: [UniChar; 64],
    pub theString: *const CFString,
    pub directUniCharBuffer: *const UniChar,
    pub directCStringBuffer: *const c_char,
    pub rangeToBuffer: CFRange,
    pub bufferedRangeStart: CFIndex,
    pub bufferedRangeEnd: CFIndex,
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFStringInlineBuffer {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <[UniChar; 64]>::ENCODING,
            <*const CFString>::ENCODING,
            <*const UniChar>::ENCODING,
            <*const c_char>::ENCODING,
            <CFRange>::ENCODING,
            <CFIndex>::ENCODING,
            <CFIndex>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFStringInlineBuffer {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// TODO: pub fn CFStringInitInlineBuffer(str: &CFString,buf: *mut CFStringInlineBuffer,range: CFRange,);

// TODO: pub fn CFStringGetCharacterFromInlineBuffer(buf: *mut CFStringInlineBuffer,idx: CFIndex,) -> UniChar;

// TODO: pub fn CFStringIsSurrogateHighCharacter(character: UniChar,) -> Boolean;

// TODO: pub fn CFStringIsSurrogateLowCharacter(character: UniChar,) -> Boolean;

// TODO: pub fn CFStringGetLongCharacterForSurrogatePair(surrogate_high: UniChar,surrogate_low: UniChar,) -> UTF32Char;

// TODO: pub fn CFStringGetSurrogatePairForLongCharacter(character: UTF32Char,surrogates: *mut UniChar,) -> Boolean;

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFShow(obj: Option<&CFType>);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFShowStr(str: Option<&CFString>);
}
