/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.AbstractIterator;
import scala.collection.AbstractView;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.View$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;

public interface View<A>
extends Serializable,
Iterable<A> {
    public static /* synthetic */ View view$(View $this) {
        return $this.view();
    }

    @Override
    default public View<A> view() {
        return this;
    }

    public static /* synthetic */ IterableFactory iterableFactory$(View $this) {
        return $this.iterableFactory();
    }

    @Override
    default public IterableFactory<View> iterableFactory() {
        return View$.MODULE$;
    }

    public static /* synthetic */ View empty$(View $this) {
        return $this.empty();
    }

    @Override
    default public View<A> empty() {
        return this.iterableFactory().empty();
    }

    public static /* synthetic */ String toString$(View $this) {
        return $this.toString();
    }

    @Override
    default public String toString() {
        return new StringBuilder(16).append(this.className()).append("(<not computed>)").toString();
    }

    public static /* synthetic */ String stringPrefix$(View $this) {
        return $this.stringPrefix();
    }

    @Override
    default public String stringPrefix() {
        return "View";
    }

    public static class Appended<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final A elem;

        @Override
        public Iterator<A> iterator() {
            return new Concat<A>(this.underlying, new Single<A>(this.elem)).iterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                void var1_1;
                return (int)(var1_1 + true);
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public Appended(IterableOps<A, ?, Object> underlying, A elem) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.elem = var2_2;
        }
    }

    public static class Collect<A, B>
    extends AbstractView<B> {
        private final IterableOps<A, ?, Object> underlying;
        private final PartialFunction<A, B> pf;

        @Override
        public Iterator<B> iterator() {
            return this.underlying.iterator().collect(this.pf);
        }

        /*
         * WARNING - void declaration
         */
        public Collect(IterableOps<A, ?, Object> underlying, PartialFunction<A, B> pf) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.pf = var2_2;
        }
    }

    public static class Concat<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> prefix;
        private final IterableOps<A, ?, Object> suffix;

        @Override
        public Iterator<A> iterator() {
            Iterator iterator = this.prefix.iterator();
            Function0<Iterator> & Serializable intersect = (Function0<Iterator> & Serializable)() -> $this.suffix.iterator();
            if (iterator == null) {
                throw null;
            }
            return iterator.concat(intersect);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int knownSize() {
            int prefixSize = this.prefix.knownSize();
            if (prefixSize >= 0) {
                int suffixSize = this.suffix.knownSize();
                if (suffixSize >= 0) {
                    void var2_2;
                    void var1_1;
                    return (int)(var1_1 + var2_2);
                }
                return -1;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.prefix.isEmpty() && this.suffix.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public Concat(IterableOps<A, ?, Object> prefix, IterableOps<A, ?, Object> suffix) {
            void var2_2;
            void var1_1;
            this.prefix = var1_1;
            this.suffix = var2_2;
        }
    }

    public static class DistinctBy<A, B>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final Function1<A, B> f;

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().distinctBy(this.f);
        }

        @Override
        public int knownSize() {
            if (this.underlying.knownSize() == 0) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public DistinctBy(IterableOps<A, ?, Object> underlying, Function1<A, B> f) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.f = var2_2;
        }
    }

    public static class Drop<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final int n;
        private final int normN;

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().drop(this.n);
        }

        public int normN() {
            return this.normN;
        }

        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                return Math.max((int)(var1_1 -= this.normN()), 0);
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public Drop(IterableOps<A, ?, Object> underlying, int n) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.n = n;
            this.normN = Math.max((int)var2_2, 0);
        }
    }

    public static class DropWhile<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final Function1<A, Object> p;

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().dropWhile(this.p);
        }

        @Override
        public int knownSize() {
            if (this.underlying.knownSize() == 0) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public DropWhile(IterableOps<A, ?, Object> underlying, Function1<A, Object> p) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.p = var2_2;
        }
    }

    public static class Elems<A>
    extends AbstractView<A> {
        private final Seq<A> xs;

        @Override
        public Iterator<A> iterator() {
            return this.xs.iterator();
        }

        @Override
        public int knownSize() {
            return this.xs.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.xs.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public Elems(Seq<A> xs) {
            void var1_1;
            this.xs = var1_1;
        }
    }

    public static class Fill<A>
    extends AbstractView<A> {
        private final int n;
        private final Function0<A> elem;

        /*
         * WARNING - void declaration
         */
        @Override
        public Iterator<A> iterator() {
            void var2_1;
            void var1_2;
            Function0<A> fill_elem = this.elem;
            int fill_len = this.n;
            return new AbstractIterator<A>((int)var1_2, (Function0)var2_1){
                private int i;
                private final int len$3;
                private final Function0 elem$4;

                public final int knownSize() {
                    int n = this.len$3 - this.i;
                    return Math.max(n, 0);
                }

                public final boolean hasNext() {
                    return this.i < this.len$3;
                }

                public final A next() {
                    if (this.hasNext()) {
                        ++this.i;
                        return (A)this.elem$4.apply();
                    }
                    return (A)Iterator$.scala$collection$Iterator$$_empty.next();
                }
                {
                    void var2_2;
                    void var1_1;
                    this.len$3 = var1_1;
                    this.elem$4 = var2_2;
                    this.i = 0;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int knownSize() {
            void var1_1;
            int max$extension_that = this.n;
            return Math.max(0, (int)var1_1);
        }

        @Override
        public boolean isEmpty() {
            return this.n <= 0;
        }

        /*
         * WARNING - void declaration
         */
        public Fill(int n, Function0<A> elem) {
            void var2_2;
            void var1_1;
            this.n = var1_1;
            this.elem = var2_2;
        }
    }

    public static class Filter<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final Function1<A, Object> p;
        private final boolean isFlipped;

        public IterableOps<A, ?, Object> underlying() {
            return this.underlying;
        }

        public Function1<A, Object> p() {
            return this.p;
        }

        public boolean isFlipped() {
            return this.isFlipped;
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying().iterator().filterImpl(this.p(), this.isFlipped());
        }

        @Override
        public int knownSize() {
            if (this.underlying().knownSize() == 0) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public Filter(IterableOps<A, ?, Object> underlying, Function1<A, Object> p, boolean isFlipped) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.p = var2_2;
            this.isFlipped = var3_3;
        }
    }

    public static class FlatMap<A, B>
    extends AbstractView<B> {
        private final IterableOps<A, ?, Object> underlying;
        private final Function1<A, IterableOnce<B>> f;

        @Override
        public Iterator<B> iterator() {
            return this.underlying.iterator().flatMap(this.f);
        }

        @Override
        public int knownSize() {
            if (this.underlying.knownSize() == 0) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public FlatMap(IterableOps<A, ?, Object> underlying, Function1<A, IterableOnce<B>> f) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.f = var2_2;
        }
    }

    public static class Map<A, B>
    extends AbstractView<B> {
        private final IterableOps<A, ?, Object> underlying;
        private final Function1<A, B> f;

        @Override
        public Iterator<B> iterator() {
            return this.underlying.iterator().map(this.f);
        }

        @Override
        public int knownSize() {
            return this.underlying.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public Map(IterableOps<A, ?, Object> underlying, Function1<A, B> f) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.f = var2_2;
        }
    }

    public static class Prepended<A>
    extends AbstractView<A> {
        private final A elem;
        private final IterableOps<A, ?, Object> underlying;

        @Override
        public Iterator<A> iterator() {
            return new Concat<A>(new Single<A>(this.elem), this.underlying).iterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                void var1_1;
                return (int)(var1_1 + true);
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public Prepended(A elem, IterableOps<A, ?, Object> underlying) {
            void var2_2;
            void var1_1;
            this.elem = var1_1;
            this.underlying = var2_2;
        }
    }

    public static class Single<A>
    extends AbstractView<A> {
        private final A a;

        /*
         * WARNING - void declaration
         */
        @Override
        public Iterator<A> iterator() {
            void var1_1;
            A single_a = this.a;
            return new AbstractIterator<A>(var1_1){
                private boolean consumed;
                private final Object a$1;

                public final boolean hasNext() {
                    return !this.consumed;
                }

                public final A next() {
                    if (this.consumed) {
                        return (A)Iterator$.scala$collection$Iterator$$_empty.next();
                    }
                    this.consumed = true;
                    return (A)this.a$1;
                }
                {
                    void var1_1;
                    this.a$1 = var1_1;
                    this.consumed = false;
                }
            };
        }

        @Override
        public int knownSize() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public Single(A a) {
            void var1_1;
            this.a = var1_1;
        }
    }

    public static class Tabulate<A>
    extends AbstractView<A> {
        private final int n;
        private final Function1<Object, A> f;

        /*
         * WARNING - void declaration
         */
        @Override
        public Iterator<A> iterator() {
            void var2_1;
            void var1_2;
            Function1<Object, A> tabulate_f = this.f;
            int tabulate_end = this.n;
            return new AbstractIterator<A>((int)var1_2, (Function1)var2_1){
                private int i;
                private final int end$1;
                private final Function1 f$5;

                public final int knownSize() {
                    int n = this.end$1 - this.i;
                    return Math.max(n, 0);
                }

                public final boolean hasNext() {
                    return this.i < this.end$1;
                }

                /*
                 * WARNING - void declaration
                 */
                public final A next() {
                    if (this.hasNext()) {
                        void var1_1;
                        R result = this.f$5.apply(this.i);
                        ++this.i;
                        return var1_1;
                    }
                    return (A)Iterator$.scala$collection$Iterator$$_empty.next();
                }
                {
                    void var2_2;
                    void var1_1;
                    this.end$1 = var1_1;
                    this.f$5 = var2_2;
                    this.i = 0;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int knownSize() {
            void var1_1;
            int max$extension_that = this.n;
            return Math.max(0, (int)var1_1);
        }

        @Override
        public boolean isEmpty() {
            return this.n <= 0;
        }

        /*
         * WARNING - void declaration
         */
        public Tabulate(int n, Function1<Object, A> f) {
            void var2_2;
            void var1_1;
            this.n = var1_1;
            this.f = var2_2;
        }
    }

    public static class Take<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final int n;
        private final int normN;

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().take(this.n);
        }

        public int normN() {
            return this.normN;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                void var2_2;
                void var1_1;
                int min$extension_that = this.normN();
                return Math.min((int)var1_1, (int)var2_2);
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public Take(IterableOps<A, ?, Object> underlying, int n) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.n = n;
            this.normN = Math.max((int)var2_2, 0);
        }
    }

    public static class TakeRight<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final int n;
        private final int normN;

        @Override
        public Iterator<A> iterator() {
            return View$.MODULE$.takeRightIterator(this.underlying.iterator(), this.n);
        }

        public int normN() {
            return this.normN;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                void var2_2;
                void var1_1;
                int min$extension_that = this.normN();
                return Math.min((int)var1_1, (int)var2_2);
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            if (this.knownSize() >= 0) {
                return this.knownSize() == 0;
            }
            return this.iterator().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public TakeRight(IterableOps<A, ?, Object> underlying, int n) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.n = n;
            this.normN = Math.max((int)var2_2, 0);
        }
    }

    private static final class TakeRightIterator<A>
    extends AbstractIterator<A> {
        private Iterator<A> underlying;
        private final int maxlen;
        private int len;
        private int pos;
        private ArrayBuffer<Object> buf;

        /*
         * WARNING - void declaration
         */
        public final void init() {
            if (this.buf == null) {
                int n = this.maxlen;
                this.buf = new ArrayBuffer(Math.min(n, 256));
                this.len = 0;
                while (this.underlying.hasNext()) {
                    A n2 = this.underlying.next();
                    if (this.pos >= this.buf.length()) {
                        this.buf.addOne((Object)n2);
                    } else {
                        void var1_2;
                        this.buf.update(this.pos, var1_2);
                    }
                    ++this.pos;
                    if (this.pos == this.maxlen) {
                        this.pos = 0;
                    }
                    ++this.len;
                }
                this.underlying = null;
                if (this.len > this.maxlen) {
                    this.len = this.maxlen;
                }
                this.pos -= this.len;
                if (this.pos < 0) {
                    this.pos += this.maxlen;
                    return;
                }
            }
        }

        @Override
        public final int knownSize() {
            return this.len;
        }

        @Override
        public final boolean hasNext() {
            this.init();
            return this.len > 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final A next() {
            void var1_1;
            this.init();
            if (this.len == 0) {
                return (A)Iterator$.scala$collection$Iterator$$_empty.next();
            }
            Object x = this.buf.apply(this.pos);
            ++this.pos;
            if (this.pos == this.maxlen) {
                this.pos = 0;
            }
            --this.len;
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Iterator<A> drop(int n) {
            this.init();
            if (n > 0) {
                void var1_1;
                int n2 = this.len - n;
                this.len = Math.max(n2, 0);
                this.pos = (this.pos + var1_1) % this.maxlen;
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public TakeRightIterator(Iterator<A> underlying, int maxlen) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.maxlen = var2_2;
            this.len = -1;
            this.pos = 0;
        }
    }

    public static class TakeWhile<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final Function1<A, Object> p;

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().takeWhile(this.p);
        }

        @Override
        public int knownSize() {
            if (this.underlying.knownSize() == 0) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public TakeWhile(IterableOps<A, ?, Object> underlying, Function1<A, Object> p) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.p = var2_2;
        }
    }

    public static class Updated<A>
    extends AbstractView<A> {
        public final IterableOps<A, ?, Object> scala$collection$View$Updated$$underlying;
        public final int scala$collection$View$Updated$$index;
        public final A scala$collection$View$Updated$$elem;

        @Override
        public Iterator<A> iterator() {
            return new AbstractIterator<A>(this){
                private final Iterator<A> it;
                private int i;
                private final /* synthetic */ Updated $outer;

                /*
                 * WARNING - void declaration
                 */
                public final A next() {
                    void var1_1;
                    A a;
                    if (this.i == this.$outer.scala$collection$View$Updated$$index) {
                        this.it.next();
                        a = this.$outer.scala$collection$View$Updated$$elem;
                    } else {
                        a = this.it.next();
                    }
                    A value = a;
                    ++this.i;
                    return var1_1;
                }

                public final boolean hasNext() {
                    if (this.it.hasNext()) {
                        return true;
                    }
                    if (this.$outer.scala$collection$View$Updated$$index >= this.i) {
                        throw new IndexOutOfBoundsException(Integer.toString(this.$outer.scala$collection$View$Updated$$index));
                    }
                    return false;
                }
                {
                    void var1_1;
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.it = var1_1.scala$collection$View$Updated$$underlying.iterator();
                    this.i = 0;
                }
            };
        }

        @Override
        public int knownSize() {
            return this.scala$collection$View$Updated$$underlying.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public Updated(IterableOps<A, ?, Object> underlying, int index, A elem) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.scala$collection$View$Updated$$underlying = var1_1;
            this.scala$collection$View$Updated$$index = var2_2;
            this.scala$collection$View$Updated$$elem = var3_3;
        }
    }

    public static class Zip<A, B>
    extends AbstractView<Tuple2<A, B>> {
        private final IterableOps<A, ?, Object> underlying;
        private final Iterable<B> other;

        @Override
        public Iterator<Tuple2<A, B>> iterator() {
            return this.underlying.iterator().zip(this.other);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int knownSize() {
            void var2_2;
            void var1_1;
            int s1 = this.underlying.knownSize();
            if (s1 == 0) {
                return 0;
            }
            int s2 = this.other.knownSize();
            if (s2 == 0) {
                return 0;
            }
            return Math.min((int)var1_1, (int)var2_2);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty() || this.other.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public Zip(IterableOps<A, ?, Object> underlying, Iterable<B> other) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.other = var2_2;
        }
    }

    public static class ZipWithIndex<A>
    extends AbstractView<Tuple2<A, Object>> {
        private final IterableOps<A, ?, Object> underlying;

        @Override
        public Iterator<Tuple2<A, Object>> iterator() {
            return this.underlying.iterator().zipWithIndex();
        }

        @Override
        public int knownSize() {
            return this.underlying.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public ZipWithIndex(IterableOps<A, ?, Object> underlying) {
            void var1_1;
            this.underlying = var1_1;
        }
    }
}

