/*
  File autogenerated by gengetopt version 2.12.1
  generated with the following command:
  /usr/local/bin/gengetopt --unamed-opts --no-handle-help --no-handle-version --input=Natch.ggo 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "cmdline.h"

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->beep_given = 0 ;
  args_info->continue_given = 0 ;
  args_info->explore_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->watch_given = 0 ;
  args_info->language_given = 0 ;
  args_info->moves_given = 0 ;
  args_info->output_given = 0 ;
  args_info->position_given = 0 ;
  args_info->stop_given = 0 ;
  args_info->hash_size_given = 0 ;
  args_info->visual_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->beep_flag = 1;
  args_info->explore_flag = 1;
  args_info->verbose_flag = 0;
  args_info->watch_arg = NULL;
  args_info->language_arg = NULL;
  args_info->output_arg = NULL;
  args_info->hash_size_arg = 6 ;
  args_info->visual_flag = 0;
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
  "  This program solves chess proof games.\n"
  "\n"
  "Usage: %s [OPTIONS]... [FILES]...\n", CMDLINE_PARSER_PACKAGE);
  printf("\n");
  printf("%s\n","  -h, --help            Print help and exit");
  printf("%s\n","  -V, --version         Print version and exit");
  printf("%s\n","  -b, --beep            Beep at the end of the resolution  (default=on)");
  printf("%s\n","  -c, --continue=N      Continue resolution at position N");
  printf("%s\n","  -e, --explore         Explore moves  (default=on)");
  printf("%s\n","  -f, --verbose         Show progress on standard output  (default=off)");
  printf("%s\n","  -k, --watch=STRING    Watch occupied squares. See documentation");
  printf("%s\n","  -l, --language=CHAR   Language of output.  CHAR is `d' or `g' for Deutsch, \n                          `e' for English or `f' for Franais");
  printf("%s\n","  -m, --moves=N         Find all solutions in N single moves");
  printf("%s\n","  -o, --output=FILE     Output informations to FILE");
  printf("%s\n","  -p, --position[=LEVEL]Show positions.  LEVEL is 1 for positions, 2 for \n                          positions and moves order.  Without LEVEL, 1 is \n                          assumed.");
  printf("%s\n","  -s, --stop=N          Stop resolution after N solutions");
  printf("%s\n","  -t, --hash-size=N     Use N Mb for hash-table size  (default=`6')");
  printf("%s\n","  -v, --visual          Visual mode  (default=off)");
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);

  args_info->inputs = NULL;
  args_info->inputs_num = 0;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  
  int i;
  if (args_info->watch_arg)
    {
      free (args_info->watch_arg); /* free previous argument */
      args_info->watch_arg = 0;
    }
  if (args_info->language_arg)
    {
      free (args_info->language_arg); /* free previous argument */
      args_info->language_arg = 0;
    }
  if (args_info->output_arg)
    {
      free (args_info->output_arg); /* free previous argument */
      args_info->output_arg = 0;
    }
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);
  
  if (args_info->inputs_num)
    free (args_info->inputs);
  
  clear_given (args_info);
}


/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  
  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);
  
  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */
  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "beep",	0, NULL, 'b' },
        { "continue",	1, NULL, 'c' },
        { "explore",	0, NULL, 'e' },
        { "verbose",	0, NULL, 'f' },
        { "watch",	1, NULL, 'k' },
        { "language",	1, NULL, 'l' },
        { "moves",	1, NULL, 'm' },
        { "output",	1, NULL, 'o' },
        { "position",	2, NULL, 'p' },
        { "stop",	1, NULL, 's' },
        { "hash-size",	1, NULL, 't' },
        { "visual",	0, NULL, 'v' },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVbc:efk:l:m:o:p::s:t:v", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          if (local_args_info.help_given)
            {
              fprintf (stderr, "%s: `--help' (`-h') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->help_given && ! override)
            continue;
          local_args_info.help_given = 1;
          args_info->help_given = 1;
          return 0;

        case 'V':	/* Print version and exit.  */
          if (local_args_info.version_given)
            {
              fprintf (stderr, "%s: `--version' (`-V') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->version_given && ! override)
            continue;
          local_args_info.version_given = 1;
          args_info->version_given = 1;
          return 0;

        case 'b':	/* Beep at the end of the resolution.  */
          if (local_args_info.beep_given)
            {
              fprintf (stderr, "%s: `--beep' (`-b') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->beep_given && ! override)
            continue;
          local_args_info.beep_given = 1;
          args_info->beep_given = 1;
          args_info->beep_flag = !(args_info->beep_flag);
          break;

        case 'c':	/* Continue resolution at position N.  */
          if (local_args_info.continue_given)
            {
              fprintf (stderr, "%s: `--continue' (`-c') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->continue_given && ! override)
            continue;
          local_args_info.continue_given = 1;
          args_info->continue_given = 1;
          args_info->continue_arg = strtol (optarg,&stop_char,0);
          break;

        case 'e':	/* Explore moves.  */
          if (local_args_info.explore_given)
            {
              fprintf (stderr, "%s: `--explore' (`-e') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->explore_given && ! override)
            continue;
          local_args_info.explore_given = 1;
          args_info->explore_given = 1;
          args_info->explore_flag = !(args_info->explore_flag);
          break;

        case 'f':	/* Show progress on standard output.  */
          if (local_args_info.verbose_given)
            {
              fprintf (stderr, "%s: `--verbose' (`-f') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->verbose_given && ! override)
            continue;
          local_args_info.verbose_given = 1;
          args_info->verbose_given = 1;
          args_info->verbose_flag = !(args_info->verbose_flag);
          break;

        case 'k':	/* Watch occupied squares. See documentation.  */
          if (local_args_info.watch_given)
            {
              fprintf (stderr, "%s: `--watch' (`-k') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->watch_given && ! override)
            continue;
          local_args_info.watch_given = 1;
          args_info->watch_given = 1;
          if (args_info->watch_arg)
            free (args_info->watch_arg); /* free previous string */
          args_info->watch_arg = gengetopt_strdup (optarg);
          break;

        case 'l':	/* Language of output.  CHAR is `d' or `g' for Deutsch, `e' for English or `f' for Franais.  */
          if (local_args_info.language_given)
            {
              fprintf (stderr, "%s: `--language' (`-l') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->language_given && ! override)
            continue;
          local_args_info.language_given = 1;
          args_info->language_given = 1;
          if (args_info->language_arg)
            free (args_info->language_arg); /* free previous string */
          args_info->language_arg = gengetopt_strdup (optarg);
          break;

        case 'm':	/* Find all solutions in N single moves.  */
          if (local_args_info.moves_given)
            {
              fprintf (stderr, "%s: `--moves' (`-m') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->moves_given && ! override)
            continue;
          local_args_info.moves_given = 1;
          args_info->moves_given = 1;
          args_info->moves_arg = strtol (optarg,&stop_char,0);
          break;

        case 'o':	/* Output informations to FILE.  */
          if (local_args_info.output_given)
            {
              fprintf (stderr, "%s: `--output' (`-o') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->output_given && ! override)
            continue;
          local_args_info.output_given = 1;
          args_info->output_given = 1;
          if (args_info->output_arg)
            free (args_info->output_arg); /* free previous string */
          args_info->output_arg = gengetopt_strdup (optarg);
          break;

        case 'p':	/* Show positions.  LEVEL is 1 for positions, 2 for positions and moves order.  Without LEVEL, 1 is assumed..  */
          if (local_args_info.position_given)
            {
              fprintf (stderr, "%s: `--position' (`-p') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->position_given && ! override)
            continue;
          local_args_info.position_given = 1;
          args_info->position_given = 1;
          if (optarg)
            {
              args_info->position_arg = strtol (optarg,&stop_char,0);
            }
          break;

        case 's':	/* Stop resolution after N solutions.  */
          if (local_args_info.stop_given)
            {
              fprintf (stderr, "%s: `--stop' (`-s') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->stop_given && ! override)
            continue;
          local_args_info.stop_given = 1;
          args_info->stop_given = 1;
          args_info->stop_arg = strtol (optarg,&stop_char,0);
          break;

        case 't':	/* Use N Mb for hash-table size.  */
          if (local_args_info.hash_size_given)
            {
              fprintf (stderr, "%s: `--hash-size' (`-t') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->hash_size_given && ! override)
            continue;
          local_args_info.hash_size_given = 1;
          args_info->hash_size_given = 1;
          args_info->hash_size_arg = strtol (optarg,&stop_char,0);
          break;

        case 'v':	/* Visual mode.  */
          if (local_args_info.visual_given)
            {
              fprintf (stderr, "%s: `--visual' (`-v') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->visual_given && ! override)
            continue;
          local_args_info.visual_given = 1;
          args_info->visual_given = 1;
          args_info->visual_flag = !(args_info->visual_flag);
          break;


        case 0:	/* Long option with no short option */

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (check_required)
    {
    }

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
  
      args_info->inputs_num = argc - optind ;
      args_info->inputs = 
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ; 
    }
  
  return 0;

failure:
  cmdline_parser_free (&local_args_info);
  return (EXIT_FAILURE);
}
