/*
 * distimmo.h --- distance package.
 *
 * Copyright (c) 2000, 2001 by Pascal Wassong All Rights Reserved.
 *
 * Time-stamp: <2001-04-16 18:21:45 Pascal>
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef	DISTIMMO_H
#define	DISTIMMO_H

#include	"types.h"
#include	"dis_type.h"

void distance_raz_tableaux_si_immobile();
void distance_cree_tableau_si_immobile(
    square_t		nouvelle_case_interdite ,
    piece_index_t	index );
void distance_ajouter_tableau_pour_case(
    square_t		case_potentiellement_bloquee );
void distance_supprimer_dernier_tableau_pour_case_potentiellement_bloquee();
void distance_reimmobilise_pieces(
    piece_index_t	pieces_ayant_du_bouger[],
    int			nombre_pieces_ayant_du_bouger );
distance_t	distance_avec_obstacle(
    piece_type_t	piece ,
    colour_t		camp ,
    square_t		case_depart ,
    square_t		case_arrivee ,
    bool_t		checkAvailableMoves ,
    piece_index_t	pieces_ayant_du_bouger[],
    int*		nombre_pieces_ayant_du_bouger );
bool_t		distance_desimmobilise_piece_sur_case(
    square_t		square );
void		distance_reimmobilise_piece_sur_case(
    square_t		square );
void	distance_libere_case(
    square_t		laCase ,
    void		(*function)(int indice),
    int			indice );

#endif /* DISTIMMO_H */
