/*
 * piece.c --- All functions dealing solely with the type `piece_t'.
 *
 * Copyright (c) 2003 by Pascal Wassong All Rights Reserved.
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include	"piece.h"

int
promotion_index( const piece_t* piece )
{
    int		i = 0;

    if ( piece->casePromotion == CASE_PAS_DE_PROMOTION )
    {
	return INFINI;
    }

    while ( i < piece->nbDestination )
    {
	if ( piece->destination[ i ] == piece->casePromotion )
	{
	    return i;
	}
	i++;
    }
    return INFINI;
}
