/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDate;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.MakeDate$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(year, month, day) - Create date from year, month and day fields.", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2013, 7, 15);\n       2013-07-15\n      > SELECT _FUNC_(2019, 13, 1);\n       NULL\n      > SELECT _FUNC_(2019, 7, NULL);\n       NULL\n      > SELECT _FUNC_(2019, 2, 30);\n       NULL\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001\u0002\u0014(\u0001RB\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001d\"A!\u000b\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005T\u0001\tE\t\u0015!\u0003O\u0011!!\u0006A!f\u0001\n\u0003i\u0005\u0002C+\u0001\u0005#\u0005\u000b\u0011\u0002(\t\u0011Y\u0003!Q3A\u0005\u0002]C\u0001b\u0017\u0001\u0003\u0012\u0003\u0006I\u0001\u0017\u0005\u00069\u0002!\t!\u0018\u0005\u00069\u0002!\ta\u0019\u0005\u0006O\u0002!\t\u0005\u001b\u0005\u0006i\u0002!\t%\u001e\u0005\u0006{\u0002!\tE \u0005\u0007\u0003\u000b\u0001A\u0011I,\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!9\u0011q\u0003\u0001\u0005B\u0005e\u0001bBA\u001b\u0001\u0011\u0005\u0013q\u0007\u0005\n\u0003\u0013\u0002\u0011\u0011!C\u0001\u0003\u0017B\u0011\"!\u0016\u0001#\u0003%\t!a\u0016\t\u0013\u00055\u0004!%A\u0005\u0002\u0005]\u0003\"CA8\u0001E\u0005I\u0011AA,\u0011%\t\t\bAI\u0001\n\u0003\t\u0019\bC\u0005\u0002x\u0001\t\t\u0011\"\u0011\u0002z!I\u0011\u0011\u0012\u0001\u0002\u0002\u0013\u0005\u00111\u0012\u0005\n\u0003'\u0003\u0011\u0011!C\u0001\u0003+C\u0011\"a'\u0001\u0003\u0003%\t%!(\t\u0013\u0005-\u0006!!A\u0005\u0002\u00055\u0006\"CAY\u0001\u0005\u0005I\u0011IAZ\u000f%\tinJA\u0001\u0012\u0003\tyN\u0002\u0005'O\u0005\u0005\t\u0012AAq\u0011\u0019af\u0004\"\u0001\u0002p\"I\u0011\u0011\u001f\u0010\u0002\u0002\u0013\u0015\u00131\u001f\u0005\n\u0003kt\u0012\u0011!CA\u0003oD\u0011B!\u0001\u001f#\u0003%\t!a\u001d\t\u0013\t\ra$!A\u0005\u0002\n\u0015\u0001\"\u0003B\f=E\u0005I\u0011AA:\u0011%\u0011IBHA\u0001\n\u0013\u0011YB\u0001\u0005NC.,G)\u0019;f\u0015\tA\u0013&A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0016,\u0003!\u0019\u0017\r^1msN$(B\u0001\u0017.\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003]=\nQa\u001d9be.T!\u0001M\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0014aA8sO\u000e\u00011C\u0002\u00016sq\u001a\u0015\n\u0005\u00027o5\tq%\u0003\u00029O\t\tB+\u001a:oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005YR\u0014BA\u001e(\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u001fA\u001d\t1d(\u0003\u0002@O\u00059\u0001/Y2lC\u001e,\u0017BA!C\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!aP\u0014\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\u000fA\u0013x\u000eZ;diB\u0011AIS\u0005\u0003\u0017\u0016\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fA!_3beV\ta\n\u0005\u00027\u001f&\u0011\u0001k\n\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!B=fCJ\u0004\u0013!B7p]RD\u0017AB7p]RD\u0007%A\u0002eCf\fA\u0001Z1zA\u0005Ya-Y5m\u001f:,%O]8s+\u0005A\u0006C\u0001#Z\u0013\tQVIA\u0004C_>dW-\u00198\u0002\u0019\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN\u001d\u0011\u0002\rqJg.\u001b;?)\u0015qv\fY1c!\t1\u0004\u0001C\u0003M\u0013\u0001\u0007a\nC\u0003S\u0013\u0001\u0007a\nC\u0003U\u0013\u0001\u0007a\nC\u0004W\u0013A\u0005\t\u0019\u0001-\u0015\ty#WM\u001a\u0005\u0006\u0019*\u0001\rA\u0014\u0005\u0006%*\u0001\rA\u0014\u0005\u0006)*\u0001\rAT\u0001\tG\"LG\u000e\u001a:f]V\t\u0011\u000eE\u0002kc:s!a\u001b9\u000f\u00051|W\"A7\u000b\u00059\u001c\u0014A\u0002\u001fs_>$h(C\u0001G\u0013\tyT)\u0003\u0002sg\n\u00191+Z9\u000b\u0005}*\u0015AC5oaV$H+\u001f9fgV\ta\u000fE\u0002kc^\u0004\"\u0001_>\u000e\u0003eT!A_\u0016\u0002\u000bQL\b/Z:\n\u0005qL(\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#A@\u0011\u0007a\f\t!C\u0002\u0002\u0004e\u0014\u0001\u0002R1uCRK\b/Z\u0001\t]VdG.\u00192mK\u0006aa.\u001e7m'\u00064W-\u0012<bYRA\u00111BA\t\u0003'\t)\u0002E\u0002E\u0003\u001bI1!a\u0004F\u0005\r\te.\u001f\u0005\u0007\u0019>\u0001\r!a\u0003\t\rI{\u0001\u0019AA\u0006\u0011\u0019!v\u00021\u0001\u0002\f\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0007\u00037\t9#!\r\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t(\u0003\u001d\u0019w\u000eZ3hK:LA!!\n\u0002 \tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002*A\u0001\r!a\u000b\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\u001e\u00055\u0012\u0002BA\u0018\u0003?\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u00024A\u0001\r!a\u0007\u0002\u0005\u00154\u0018A\u00039sKR$\u0018PT1nKV\u0011\u0011\u0011\b\t\u0005\u0003w\t\u0019E\u0004\u0003\u0002>\u0005}\u0002C\u00017F\u0013\r\t\t%R\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0013q\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005S)\u0001\u0003d_BLH#\u00030\u0002N\u0005=\u0013\u0011KA*\u0011\u001da%\u0003%AA\u00029CqA\u0015\n\u0011\u0002\u0003\u0007a\nC\u0004U%A\u0005\t\u0019\u0001(\t\u000fY\u0013\u0002\u0013!a\u00011\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA-U\rq\u00151L\u0016\u0003\u0003;\u0002B!a\u0018\u0002j5\u0011\u0011\u0011\r\u0006\u0005\u0003G\n)'A\u0005v]\u000eDWmY6fI*\u0019\u0011qM#\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002l\u0005\u0005$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\t)HK\u0002Y\u00037\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA>!\u0011\ti(a\"\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000bA\u0001\\1oO*\u0011\u0011QQ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002F\u0005}\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAAG!\r!\u0015qR\u0005\u0004\u0003#+%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0006\u0003/C\u0011\"!'\u001a\u0003\u0003\u0005\r!!$\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\n\u0005\u0004\u0002\"\u0006\u001d\u00161B\u0007\u0003\u0003GS1!!*F\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003S\u000b\u0019K\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001-\u00020\"I\u0011\u0011T\u000e\u0002\u0002\u0003\u0007\u00111B\u0001\u0007KF,\u0018\r\\:\u0015\u0007a\u000b)\fC\u0005\u0002\u001ar\t\t\u00111\u0001\u0002\f!:\u0002!!/\u0002@\u0006\u0005\u0017QYAd\u0003\u0017\fi-!5\u0002T\u0006]\u0017\u0011\u001c\t\u0004m\u0005m\u0016bAA_O\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAb\u0003\u001d{f)\u0016(D?\"JX-\u0019:-A5|g\u000e\u001e5-A\u0011\f\u00170\u000b\u0011.A\r\u0013X-\u0019;fA\u0011\fG/\u001a\u0011ge>l\u0007%_3be2\u0002Sn\u001c8uQ\u0002\ng\u000e\u001a\u0011eCf\u0004c-[3mINt\u0013!C1sOVlWM\u001c;tC\t\tI-AAT\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002\u00130Z1sA5\u0002C\u000f[3!s\u0016\f'\u000f\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t;pAeJ\u0014(\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016![>tG\u000f\u001b\u0011.AQDW\rI7p]RDWf\u001c4.s\u0016\f'\u000f\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t\u0015KC:,\u0018M]=*AQ|\u0007%\r\u001a!Q\u0011+7-Z7cKJL#\u0002\t\u0011!A\u0001\u0002#\u0006\t3bs\u0002j\u0003\u0005\u001e5fA\u0011\f\u00170L8g[5|g\u000e\u001e5!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|W\u000eI\u0019!i>\u00043'\r\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002P\u0006\t\u0019L\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00153aE\u001aD\u0006I\u001c-AE*\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE\u001aT\u0006M\u001c.cUR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00192s1\u0002\u0013g\r\u0017!c%Z$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C#\u0007M\u0019:Y\u0001:D\u0006\t(V\u00192K3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00192s1\u0002#\u0007\f\u00114a%Z$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002V\u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAn\u0003\u0015\u0019d\u0006\r\u00181\u0003!i\u0015m[3ECR,\u0007C\u0001\u001c\u001f'\u0011q\u00121]%\u0011\u0013\u0005\u0015\u00181\u001e(O\u001dbsVBAAt\u0015\r\tI/R\u0001\beVtG/[7f\u0013\u0011\ti/a:\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0006\u0002\u0002`\u0006AAo\\*ue&tw\r\u0006\u0002\u0002|\u0005)\u0011\r\u001d9msRIa,!?\u0002|\u0006u\u0018q \u0005\u0006\u0019\u0006\u0002\rA\u0014\u0005\u0006%\u0006\u0002\rA\u0014\u0005\u0006)\u0006\u0002\rA\u0014\u0005\b-\u0006\u0002\n\u00111\u0001Y\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u000f\u0011\u0019\u0002E\u0003E\u0005\u0013\u0011i!C\u0002\u0003\f\u0015\u0013aa\u00149uS>t\u0007c\u0002#\u0003\u00109se\nW\u0005\u0004\u0005#)%A\u0002+va2,G\u0007\u0003\u0005\u0003\u0016\r\n\t\u00111\u0001_\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005;\u0001B!! \u0003 %!!\u0011EA@\u0005\u0019y%M[3di\u0002")
public class MakeDate
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression year;
    private final Expression month;
    private final Expression day;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$4() {
        return MakeDate$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Expression, Expression, Object>> unapply(MakeDate makeDate) {
        return MakeDate$.MODULE$.unapply(makeDate);
    }

    public static boolean apply$default$4() {
        return MakeDate$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Object>, MakeDate> tupled() {
        return MakeDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, MakeDate>>>> curried() {
        return MakeDate$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression year() {
        return this.year;
    }

    public Expression month() {
        return this.month;
    }

    public Expression day() {
        return this.day;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.year(), this.month(), this.day()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IntegerType$[]{IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return this.failOnError() ? this.children().exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.nullable())) : true;
    }

    @Override
    public Object nullSafeEval(Object year, Object month, Object day) {
        Integer n;
        try {
            LocalDate ld = LocalDate.of(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), BoxesRunTime.unboxToInt((Object)day));
            n = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.localDateToDays(ld));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof DateTimeException) || this.failOnError()) {
                throw throwable;
            }
            Object var4_7 = null;
            n = var4_7;
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        String failOnErrorBranch = this.failOnError() ? "throw e;" : new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(year, month, day) -> new StringBuilder(136).append("\n      try {\n        ").append(ev.value()).append(" = ").append(dtu).append(".localDateToDays(java.time.LocalDate.of(").append((String)year).append(", ").append((String)month).append(", ").append((String)day).append("));\n      } catch (java.time.DateTimeException e) {\n        ").append(failOnErrorBranch).append("\n      }").toString());
    }

    @Override
    public String prettyName() {
        return "make_date";
    }

    public MakeDate copy(Expression year, Expression month, Expression day, boolean failOnError) {
        return new MakeDate(year, month, day, failOnError);
    }

    public Expression copy$default$1() {
        return this.year();
    }

    public Expression copy$default$2() {
        return this.month();
    }

    public Expression copy$default$3() {
        return this.day();
    }

    public boolean copy$default$4() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "MakeDate";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.year();
                break;
            }
            case 1: {
                object = this.month();
                break;
            }
            case 2: {
                object = this.day();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeDate makeDate = (MakeDate)x$1;
        Expression expression = this.year();
        Expression expression2 = makeDate.year();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.month();
        Expression expression4 = makeDate.month();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.day();
        Expression expression6 = makeDate.day();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.failOnError() != makeDate.failOnError()) return false;
        if (!makeDate.canEqual(this)) return false;
        return true;
    }

    public MakeDate(Expression year, Expression month, Expression day, boolean failOnError) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public MakeDate(Expression year, Expression month, Expression day) {
        this(year, month, day, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

